/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.compiler.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import net.binis.codegen.compiler.CGAnnotation;
import net.binis.codegen.compiler.CGAssign;
import net.binis.codegen.compiler.CGClassDeclaration;
import net.binis.codegen.compiler.CGDeclaration;
import net.binis.codegen.compiler.CGExpression;
import net.binis.codegen.compiler.CGList;
import net.binis.codegen.compiler.CGMethodDeclaration;
import net.binis.codegen.compiler.CGName;
import net.binis.codegen.compiler.CGSymbol;
import net.binis.codegen.compiler.CGTypeTag;
import net.binis.codegen.compiler.TreeMaker;
import net.binis.codegen.exception.GenericCodeGenException;

public class ElementUtils {
    public static CGAnnotation findAnnotation(Element element, Class<? extends Annotation> annotation) {
        return ElementUtils.findAnnotation(element, (CGAnnotation ann) -> ann.isAnnotation(annotation));
    }

    public static CGAnnotation findAnnotation(Element element, Predicate<CGAnnotation> filter) {
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!filter.test(ann)) continue;
            return ann;
        }
        return null;
    }

    public static List<CGAnnotation> findAnnotations(Element element, Predicate<CGAnnotation> filter) {
        ArrayList<CGAnnotation> result = new ArrayList<CGAnnotation>();
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!filter.test(ann)) continue;
            result.add(ann);
        }
        return result;
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        TreeMaker maker = TreeMaker.create();
        CGDeclaration decl = ElementUtils.getDeclaration(element, maker);
        CGList<CGExpression> list = CGList.nil();
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            list = list.append(maker.Assign(maker.Ident(CGName.create(attr.getKey())), ElementUtils.calcExpression(maker, attr.getValue())));
        }
        CGAnnotation ann = maker.Annotation(maker.QualIdent(maker.getSymbol(annotation.getCanonicalName())), list);
        decl.getModifiers().getAnnotations().append(ann);
        return ann;
    }

    public static CGAnnotation addAnnotation(Element element, Class<? extends Annotation> annotation, CGList<CGExpression> attributes) {
        TreeMaker maker = TreeMaker.create();
        CGDeclaration decl = ElementUtils.getDeclaration(element, maker);
        CGAnnotation ann = maker.Annotation(maker.QualIdent(maker.getSymbol(annotation.getCanonicalName())), attributes);
        decl.getModifiers().getAnnotations().append(ann);
        return ann;
    }

    public static CGAnnotation addOrReplaceAnnotation(Element element, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementUtils.removeAnnotation(element, annotation);
        return ElementUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotation(Element element, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation, Map<String, Object> attributes) {
        ElementUtils.removeAnnotation(element, oldAnnotation);
        return ElementUtils.addAnnotation(element, annotation, attributes);
    }

    public static CGAnnotation replaceAnnotationWithAttributes(Element element, CGAnnotation oldAnnotation, Class<? extends Annotation> annotation) {
        ElementUtils.removeAnnotation(element, oldAnnotation);
        return ElementUtils.addAnnotation(element, annotation, oldAnnotation.getArguments());
    }

    public static CGAnnotation removeAnnotation(Element element, Class<? extends Annotation> annotation) {
        CGAnnotation result = null;
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        CGList<CGAnnotation> list = CGList.nil();
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.isAnnotation(annotation)) {
                list = list.append(ann);
                continue;
            }
            result = ann;
        }
        decl.getModifiers().setAnnotations(list);
        return result;
    }

    public static CGAnnotation removeAnnotation(Element element, CGAnnotation annotation) {
        CGAnnotation result = null;
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        CGList<CGAnnotation> list = CGList.nil();
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.getInstance().equals(annotation.getInstance())) {
                list = list.append(ann);
                continue;
            }
            result = ann;
        }
        decl.getModifiers().setAnnotations(list);
        return result;
    }

    public static void addAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.isAnnotation(annotation)) continue;
            ElementUtils.addAnnotationAttribute(element, ann, name, value);
            break;
        }
    }

    public static void addAnnotationAttribute(Element element, CGAnnotation annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        annotation.getArguments().append(maker.Assign(maker.Ident(CGName.create(name)), ElementUtils.calcExpression(maker, value)));
    }

    public static void removeAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name) {
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.isAnnotation(annotation)) continue;
            ElementUtils.removeAnnotationAttribute(element, ann, name);
            break;
        }
    }

    public static void removeAnnotationAttribute(Element element, CGAnnotation annotation, String name) {
        CGList<CGExpression> list = CGList.nil();
        Iterator<CGExpression> iter = annotation.getArguments().iterator(CGExpression.class);
        while (iter.hasNext()) {
            CGExpression attr = iter.next();
            if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                CGAssign assign = new CGAssign(attr.getInstance());
                if (assign.getVariable().getInstance().toString().equals(name)) continue;
                list.append(attr);
                continue;
            }
            list.append(attr);
        }
        annotation.setArguments(list);
    }

    public static void replaceAnnotationAttribute(Element element, Class<? extends Annotation> annotation, String name, Object value) {
        CGDeclaration decl = ElementUtils.getDeclaration(element);
        Iterator<CGAnnotation> it = decl.getModifiers().getAnnotations().iterator(CGAnnotation.class);
        while (it.hasNext()) {
            CGAnnotation ann = it.next();
            if (!ann.isAnnotation(annotation)) continue;
            ElementUtils.replaceAnnotationAttribute(element, ann, name, value);
            break;
        }
    }

    public static void replaceAnnotationAttribute(Element element, CGAnnotation annotation, String name, Object value) {
        TreeMaker maker = TreeMaker.create();
        CGList<CGExpression> list = CGList.nil();
        Iterator<CGExpression> iter = annotation.getArguments().iterator(CGExpression.class);
        while (iter.hasNext()) {
            CGExpression attr = iter.next();
            if (attr.getInstance().getClass().equals(CGAssign.theClass())) {
                CGAssign assign = new CGAssign(attr.getInstance());
                if (!assign.getVariable().getInstance().toString().equals(name)) {
                    list.append(attr);
                    continue;
                }
                list.append(maker.Assign(maker.Ident(CGName.create(name)), ElementUtils.calcExpression(maker, value)));
                continue;
            }
            list.append(attr);
        }
        annotation.setArguments(list);
    }

    protected static CGExpression calcExpression(TreeMaker maker, Object value) {
        if (value instanceof String) {
            return maker.Literal(CGTypeTag.CLASS, value);
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return maker.Literal(CGTypeTag.BOOLEAN, b != false ? 1 : 0);
        }
        if (value instanceof Long) {
            return maker.Literal(CGTypeTag.LONG, value);
        }
        if (value instanceof Integer) {
            return maker.Literal(CGTypeTag.INT, value);
        }
        if (value instanceof Double) {
            return maker.Literal(CGTypeTag.DOUBLE, value);
        }
        if (value instanceof Float) {
            return maker.Literal(CGTypeTag.FLOAT, value);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return maker.Literal(CGTypeTag.CHAR, c.charValue());
        }
        if (value instanceof Short) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.SHORT), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Byte) {
            return maker.TypeCast(maker.TypeIdent(CGTypeTag.BYTE), maker.Literal(CGTypeTag.INT, value));
        }
        if (value instanceof Enum) {
            CGSymbol symbol = maker.getSymbol(value.getClass().getCanonicalName());
            return maker.Select(maker.QualIdent(symbol), CGName.create(value.toString()));
        }
        if (value instanceof Class) {
            Class c = (Class)value;
            CGSymbol symbol = maker.getSymbol(c.getCanonicalName());
            return maker.Select(maker.QualIdent(symbol), CGName.create("class"));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            CGList<CGExpression> list = CGList.nil();
            for (int i = 0; i < length; ++i) {
                list.append(ElementUtils.calcExpression(maker, Array.get(value, i)));
            }
            return maker.NewArray(null, CGList.nil(), list);
        }
        return ElementUtils.classIdent(maker, value.toString());
    }

    protected static CGExpression classIdent(TreeMaker maker, String className) {
        String[] strings = className.split("\\.");
        CGExpression classNameIdent = maker.Ident(CGName.create(strings[0]));
        for (int i = 1; i < strings.length; ++i) {
            classNameIdent = maker.Select(classNameIdent, CGName.create(strings[i]));
        }
        return classNameIdent;
    }

    protected static CGDeclaration getDeclaration(Element element) {
        TreeMaker maker = TreeMaker.create();
        return ElementUtils.getDeclaration(element, maker);
    }

    protected static CGDeclaration getDeclaration(Element element, TreeMaker maker) {
        return switch (element.getKind()) {
            case ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE -> CGClassDeclaration.create(maker.getTrees(), element);
            case ElementKind.METHOD -> CGMethodDeclaration.create(maker.getTrees(), element);
            default -> throw new GenericCodeGenException("Invalid element kind: " + element.getKind().toString());
        };
    }
}

