/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.tools;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Tools {
    private Tools() {
    }

    public static <T, R> T nullCheck(R object, Function<R, T> func) {
        return Tools.nullCheck(object, func, null);
    }

    public static <T> T nullCheck(T object, T defaultObject) {
        return Objects.nonNull(object) ? object : defaultObject;
    }

    public static <T, R, Q> T nullCheck(R object, Class<Q> iface, Function<Q, T> func) {
        return Objects.nonNull(object) ? (T)func.apply(iface.cast(object)) : null;
    }

    public static <T, R> T nullCheck(R object, Function<R, T> func, T defaultObject) {
        return Objects.nonNull(object) ? func.apply(object) : defaultObject;
    }

    public static <R> void notNull(R object, Consumer<R> consumer) {
        if (Objects.nonNull(object)) {
            consumer.accept(object);
        }
    }

    public static <R> void with(R object, Consumer<R> consumer) {
        if (Objects.nonNull(object)) {
            consumer.accept(object);
        }
    }

    public static <R> void with(R object, Consumer<R> consumer, Runnable defaultRunnable) {
        if (Objects.nonNull(object)) {
            consumer.accept(object);
        } else {
            defaultRunnable.run();
        }
    }

    public static <R> R ifNull(R object, Supplier<R> supplier) {
        if (object == null) {
            return supplier.get();
        }
        return object;
    }

    public static void ifNull(Object object, Runnable runnable) {
        if (object == null) {
            runnable.run();
        }
    }

    public static <R> void conditional(R object, Predicate<R> condition, Consumer<R> consumer) {
        if (object != null && condition.test(object)) {
            consumer.accept(object);
        }
    }

    public static <T> T condition(boolean condition, Supplier<T> supplier) {
        return condition ? (T)supplier.get() : null;
    }

    public static <T> T condition(boolean condition, T constant) {
        return (T)(condition ? constant : null);
    }

    public static void condition(boolean condition, Runnable task) {
        if (condition) {
            task.run();
        }
    }

    public static <T, R> T emptyCheck(Optional<R> optional, Function<R, T> func, T defaultObject) {
        return optional.isPresent() ? func.apply(optional.get()) : defaultObject;
    }

    public static <T, R, Q> T condition(boolean condition, R object, Class<Q> iface, Function<Q, T> func) {
        return condition && Objects.nonNull(object) ? (T)func.apply(iface.cast(object)) : null;
    }

    public static <T> T safeCall(Supplier<T> func, Function<Exception, T> onException) {
        try {
            return func.get();
        }
        catch (Exception e) {
            return onException.apply(e);
        }
    }

    public static <T, R> R withRes(T object, Function<T, R> wither) {
        if (Objects.nonNull(object)) {
            return wither.apply(object);
        }
        return null;
    }

    public static <T, R> R withRes(T object, Function<T, R> wither, R defaultValue) {
        if (Objects.nonNull(object)) {
            return wither.apply(object);
        }
        return defaultValue;
    }

    @SafeVarargs
    public static <T> boolean in(T object, T ... list) {
        for (T o : list) {
            if (!o.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean allNotNull(Object ... values) {
        if (values == null) {
            return false;
        }
        for (Object value : values) {
            if (value != null) continue;
            return false;
        }
        return true;
    }

    public static <T> void as(Object obj, Class<T> intf, Consumer<T> consumer) {
        if (Objects.nonNull(obj) && intf.isAssignableFrom(obj.getClass())) {
            consumer.accept(intf.cast(obj));
        }
    }

    public static <T, R> R asRes(Object obj, Class<T> intf, Function<T, R> func) {
        if (Objects.nonNull(obj) && intf.isAssignableFrom(obj.getClass())) {
            return func.apply(intf.cast(obj));
        }
        return null;
    }

    public static boolean anyNull(Object ... values) {
        return !Tools.allNotNull(values);
    }

    public static long measure(Runnable run) {
        long start = System.currentTimeMillis();
        run.run();
        return System.currentTimeMillis() - start;
    }
}

