package net.binis.codegen.test;

/*-
 * #%L
 * code-generator
 * %%
 * Copyright (C) 2021 Binis Belev
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static java.util.Objects.nonNull;

public class TestClassLoader extends ClassLoader {

    protected Map<String, Class<?>> classes = new ConcurrentHashMap<>();

    public Class<?> define(String name, JavaByteObject byteObject) throws ClassFormatError {
        byte[] bytes = byteObject.getBytes();

        var cls = defineClass(name, bytes, 0, bytes.length);

        if (nonNull(cls)) {
            classes.put(name, cls);
        }

        return cls;
    }

    @Override
    public Class<?> findClass(String name) {
        return classes.get(name);
    }

}
