/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.keanalytics.api;

import dev.crashteam.openapi.keanalytics.ApiClient;
import dev.crashteam.openapi.keanalytics.model.GetProductSales200ResponseInner;
import dev.crashteam.openapi.keanalytics.model.ProductSkuHistory;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="dev.crashteam.openapi.keanalytics.api.ProductApi")
public class ProductApi {
    private ApiClient apiClient;

    public ProductApi() {
        this(new ApiClient());
    }

    @Autowired
    public ProductApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<GetProductSales200ResponseInner> getProductSales(List<Long> productIds, OffsetDateTime fromTime, OffsetDateTime toTime) throws RestClientException {
        return (List)this.getProductSalesWithHttpInfo(productIds, fromTime, toTime).getBody();
    }

    public ResponseEntity<List<GetProductSales200ResponseInner>> getProductSalesWithHttpInfo(List<Long> productIds, OffsetDateTime fromTime, OffsetDateTime toTime) throws RestClientException {
        Object localVarPostBody = null;
        if (productIds == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'productIds' when calling getProductSales");
        }
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getProductSales");
        }
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getProductSales");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "productIds", productIds));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearer"};
        ParameterizedTypeReference<List<GetProductSales200ResponseInner>> localReturnType = new ParameterizedTypeReference<List<GetProductSales200ResponseInner>>(){};
        return this.apiClient.invokeAPI("/product/sales", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<ProductSkuHistory> productSkuHistory(String xRequestID, Long productId, Long skuId, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, Integer offset) throws RestClientException {
        return (List)this.productSkuHistoryWithHttpInfo(xRequestID, productId, skuId, fromTime, toTime, limit, offset).getBody();
    }

    public ResponseEntity<List<ProductSkuHistory>> productSkuHistoryWithHttpInfo(String xRequestID, Long productId, Long skuId, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, Integer offset) throws RestClientException {
        Object localVarPostBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling productSkuHistory");
        }
        if (productId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'productId' when calling productSkuHistory");
        }
        if (skuId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'skuId' when calling productSkuHistory");
        }
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling productSkuHistory");
        }
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling productSkuHistory");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("productId", productId);
        uriVariables.put("skuId", skuId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "offset", offset));
        if (xRequestID != null) {
            localVarHeaderParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearer"};
        ParameterizedTypeReference<List<ProductSkuHistory>> localReturnType = new ParameterizedTypeReference<List<ProductSkuHistory>>(){};
        return this.apiClient.invokeAPI("/product/{productId}/sku/{skuId}/sales", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

