/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.keanalytics.api;

import dev.crashteam.openapi.keanalytics.api.ApiUtil;
import dev.crashteam.openapi.keanalytics.model.CategoryAveragePrice400Response;
import dev.crashteam.openapi.keanalytics.model.Error;
import dev.crashteam.openapi.keanalytics.model.GetProductSales200ResponseInner;
import dev.crashteam.openapi.keanalytics.model.ProductSkuHistory;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Validated
@Tag(name="product", description="the product API")
public interface ProductApi {
    @Operation(operationId="getProductSales", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043f\u043e \u043f\u0440\u043e\u0434\u0430\u0436\u0430\u043c \u0442\u043e\u0432\u0430\u0440\u043e\u0432", tags={"product"}, responses={@ApiResponse(responseCode="200", description="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u043f\u0440\u043e\u0434\u0430\u0436\u0430\u043c \u0442\u043e\u0432\u0430\u0440\u043e\u0432", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetProductSales200ResponseInner.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/product/sales"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<GetProductSales200ResponseInner>>> getProductSales(@NotNull @Parameter(name="productIds", description="List of product id", required=true) @Valid @RequestParam(value="productIds", required=true) List<Long> productIds, @NotNull @Parameter(name="fromTime", description="Start date time.", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @Parameter(name="toTime", description="End date time.", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"seller\" : { \"accountId\" : 5, \"link\" : \"link\", \"title\" : \"title\" }, \"orderAmount\" : 1, \"productId\" : 0, \"salesAmount\" : 6.027456183070403, \"dailyOrder\" : 5.962133916683182 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="productSkuHistory", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0442\u043e\u0432\u0430\u0440\u0430", tags={"product"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProductSkuHistory.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/product/{productId}/sku/{skuId}/sales"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<ProductSkuHistory>>> productSkuHistory(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @Parameter(name="productId", description="", required=true) @PathVariable(value="productId") Long productId, @Parameter(name="skuId", description="", required=true) @PathVariable(value="skuId") Long skuId, @NotNull @Parameter(name="fromTime", description="Start date time.", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @Parameter(name="toTime", description="End date time.", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The collection items limit.") @Valid @RequestParam(value="limit", required=false) @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Min(value=0L) @Parameter(name="offset", description="The collection items offset.") @Valid @RequestParam(value="offset", required=false) @Min(value=0L) @Valid Integer offset, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"date\" : \"2023-03-16T00:00:00.000+00:00\", \"totalAvailableAmount\" : 5, \"orderAmount\" : 1, \"reviewsAmount\" : 5, \"productId\" : 0, \"availableAmount\" : 2, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"purchasePrice\" : 10, \"fullPrice\" : 10, \"skuId\" : 6 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }
}

