/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.keanalytics.api;

import dev.crashteam.openapi.keanalytics.api.ApiUtil;
import dev.crashteam.openapi.keanalytics.model.CategoryAveragePrice400Response;
import dev.crashteam.openapi.keanalytics.model.Error;
import dev.crashteam.openapi.keanalytics.model.GetReportBySeller200Response;
import dev.crashteam.openapi.keanalytics.model.GetReportStateByJobId200Response;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Validated
@Tag(name="report", description="the report API")
public interface ReportApi {
    @Operation(operationId="getReportByCategory", summary="\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", tags={"report"}, responses={@ApiResponse(responseCode="200", description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0439 job", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetReportBySeller200Response.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/report/category"}, produces={"application/json"})
    default public Mono<ResponseEntity<GetReportBySeller200Response>> getReportByCategory(@NotNull @Parameter(name="path", description="Category path.", required=true) @Valid @RequestParam(value="path", required=true) List<Long> path, @NotNull @Parameter(name="period", description="", required=true) @Valid @RequestParam(value="period", required=true) Integer period, @Parameter(name="Idempotence-Key", description="", required=true) @RequestHeader(value="Idempotence-Key", required=true) String idempotenceKey, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"jobId\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"reportId\" : \"61dc6a6a453cd26524fd42b4\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getReportByReportId", summary="\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043f\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 \u043e\u0442\u0447\u0435\u0442\u0430", tags={"report"}, responses={@ApiResponse(responseCode="200", description="\u0424\u0430\u0439\u043b \u043e\u0442\u0447\u0435\u0442\u0430", content={@Content(mediaType="application/xlsx", schema=@Schema(implementation=Resource.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/xlsx", schema=@Schema(implementation=CategoryAveragePrice400Response.class)), @Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/xlsx", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/xlsx", schema=@Schema(implementation=Error.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/report/{reportId}"}, produces={"application/xlsx", "application/json"})
    default public Mono<ResponseEntity<Resource>> getReportByReportId(@Parameter(name="reportId", description="", required=true) @PathVariable(value="reportId") String reportId, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="getReportBySeller", summary="\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443", tags={"report"}, responses={@ApiResponse(responseCode="200", description="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0439 job", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetReportBySeller200Response.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/report/seller/{sellerLink}"}, produces={"application/json"})
    default public Mono<ResponseEntity<GetReportBySeller200Response>> getReportBySeller(@Parameter(name="sellerLink", description="", required=true) @PathVariable(value="sellerLink") String sellerLink, @NotNull @Parameter(name="period", description="", required=true) @Valid @RequestParam(value="period", required=true) Integer period, @Parameter(name="Idempotence-Key", description="", required=true) @RequestHeader(value="Idempotence-Key", required=true) String idempotenceKey, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"jobId\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"reportId\" : \"61dc6a6a453cd26524fd42b4\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getReportStateByJobId", summary="\u0421\u0442\u0430\u0442\u0443\u0441 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442\u0447\u0435\u0442\u0430", tags={"report"}, responses={@ApiResponse(responseCode="200", description="\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u0447\u0435\u0442\u0430", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetReportStateByJobId200Response.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/report/state/{jobId}"}, produces={"application/json"})
    default public Mono<ResponseEntity<GetReportStateByJobId200Response>> getReportStateByJobId(@Parameter(name="jobId", description="", required=true) @PathVariable(value="jobId") UUID jobId, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"reportType\" : \"SELLER\", \"jobId\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"reportId\" : \"61dc6a6a453cd26524fd42b4\", \"sellerLink\" : \"mimaximum\", \"interval\" : 30, \"categoryId\" : 0, \"status\" : \"COMPLETED\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }
}

