/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.keanalytics.api;

import dev.crashteam.openapi.keanalytics.api.ApiUtil;
import dev.crashteam.openapi.keanalytics.model.CategoryAveragePrice400Response;
import dev.crashteam.openapi.keanalytics.model.Error;
import dev.crashteam.openapi.keanalytics.model.Report;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Validated
@Tag(name="reports", description="the reports API")
public interface ReportsApi {
    @Operation(operationId="getReports", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u043e\u0442\u0447\u0435\u0442\u043e\u0432", tags={"report"}, responses={@ApiResponse(responseCode="200", description="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", content={@Content(mediaType="application/json", schema=@Schema(implementation=Report.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=CategoryAveragePrice400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="Access forbidden.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="apiKey")})
    @RequestMapping(method={RequestMethod.GET}, value={"/reports"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<Report>>> getReports(@NotNull @Parameter(name="fromTime", description="Start date time.", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"reportType\" : \"reportType\", \"jobId\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"reportId\" : \"61dc6a6a453cd26524fd42b4\", \"sellerLink\" : \"sellerLink\", \"interval\" : 0, \"categoryId\" : 6, \"status\" : \"status\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }
}

