/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.activity;

import dev.dsf.bpe.v1.ProcessPluginApi;
import dev.dsf.bpe.v1.constants.CodeSystems;
import dev.dsf.bpe.v1.variables.Variables;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractServiceDelegate
implements JavaDelegate,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceDelegate.class);
    protected final ProcessPluginApi api;

    public AbstractServiceDelegate(ProcessPluginApi api) {
        this.api = api;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.api, "api");
    }

    public final void execute(DelegateExecution execution) throws Exception {
        Variables variables = this.api.getVariables(execution);
        try {
            logger.trace("Execution of task with id='{}'", (Object)execution.getCurrentActivityId());
            this.doExecute(execution, variables);
        }
        catch (BpmnError error) {
            logger.debug("Error while executing service delegate " + this.getClass().getName(), (Throwable)error);
            logger.error("Process {} encountered error boundary event in step {} for task {}, error-code: {}, message: {}", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), error.getErrorCode(), error.getMessage()});
            throw error;
        }
        catch (Exception exception) {
            logger.debug("Error while executing service delegate " + this.getClass().getName(), (Throwable)exception);
            logger.error("Process {} has fatal error in step {} for task {}, reason: {} - {}", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), exception.getClass().getName(), exception.getMessage()});
            String errorMessage = "Process " + execution.getProcessDefinitionId() + " has fatal error in step " + execution.getActivityInstanceId() + ", reason: " + exception.getMessage();
            this.updateFailedIfInprogress(variables.getTasks(), errorMessage);
            execution.getProcessEngine().getRuntimeService().deleteProcessInstance(execution.getProcessInstanceId(), exception.getMessage());
        }
    }

    protected abstract void doExecute(DelegateExecution var1, Variables var2) throws BpmnError, Exception;

    private void updateFailedIfInprogress(List<Task> tasks, String errorMessage) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = tasks.get(i);
            if (Task.TaskStatus.INPROGRESS.equals((Object)task.getStatus())) {
                task.setStatus(Task.TaskStatus.FAILED);
                task.addOutput(new Task.TaskOutputComponent(new CodeableConcept(CodeSystems.BpmnMessage.error()), (Type)new StringType(errorMessage)));
                this.updateAndHandleException(task);
                continue;
            }
            logger.debug("Not updating Task {} with status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus());
        }
    }

    private void updateAndHandleException(Task task) {
        try {
            logger.debug("Updating Task {}, new status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus().toCode());
            this.api.getFhirWebserviceClientProvider().getLocalWebserviceClient().withMinimalReturn().update((Resource)task);
        }
        catch (Exception e) {
            logger.error("Unable to update Task " + this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Throwable)e);
        }
    }
}

