/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.activity;

import dev.dsf.bpe.v1.ProcessPluginApi;
import dev.dsf.bpe.v1.constants.CodeSystems;
import dev.dsf.bpe.v1.constants.NamingSystems;
import dev.dsf.bpe.v1.variables.Target;
import dev.dsf.bpe.v1.variables.Targets;
import dev.dsf.bpe.v1.variables.Variables;
import dev.dsf.fhir.client.FhirWebserviceClient;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractTaskMessageSend
implements JavaDelegate,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTaskMessageSend.class);
    protected final ProcessPluginApi api;
    private FixedValue instantiatesCanonical;
    private FixedValue messageName;
    private FixedValue profile;

    public AbstractTaskMessageSend(ProcessPluginApi api) {
        this.api = api;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.api, "api");
    }

    @Deprecated
    public final void setInstantiatesCanonical(FixedValue instantiatesCanonical) {
        this.instantiatesCanonical = instantiatesCanonical;
    }

    protected String getInstantiatesCanonical(DelegateExecution execution, Variables variables) {
        return this.instantiatesCanonical == null ? null : this.instantiatesCanonical.getExpressionText();
    }

    @Deprecated
    public final void setMessageName(FixedValue messageName) {
        this.messageName = messageName;
    }

    protected String getMessageName(DelegateExecution execution, Variables variables) {
        return this.messageName == null ? null : this.messageName.getExpressionText();
    }

    @Deprecated
    public final void setProfile(FixedValue profile) {
        this.profile = profile;
    }

    protected String getProfile(DelegateExecution execution, Variables variables) {
        return this.profile == null ? null : this.profile.getExpressionText();
    }

    public final void execute(DelegateExecution execution) throws Exception {
        this.doExecute(execution, this.api.getVariables(execution));
    }

    protected void doExecute(DelegateExecution execution, Variables variables) throws Exception {
        String instantiatesCanonical = this.getInstantiatesCanonical(execution, variables);
        String messageName = this.getMessageName(execution, variables);
        String profile = this.getProfile(execution, variables);
        String businessKey = execution.getBusinessKey();
        Target target = variables.getTarget();
        try {
            this.sendTask(execution, variables, target, instantiatesCanonical, messageName, businessKey, profile, this.getAdditionalInputParameters(execution, variables));
        }
        catch (Exception e) {
            Object exceptionMessage = e.getMessage();
            if (e instanceof WebApplicationException && (e.getMessage() == null || e.getMessage().isBlank())) {
                Response.StatusType statusInfo = ((WebApplicationException)e).getResponse().getStatusInfo();
                exceptionMessage = statusInfo.getStatusCode() + " " + statusInfo.getReasonPhrase();
            }
            String errorMessage = "Task " + instantiatesCanonical + " send failed [recipient: " + target.getOrganizationIdentifierValue() + ", endpoint: " + target.getEndpointIdentifierValue() + ", businessKey: " + businessKey + (String)(target.getCorrelationKey() == null ? "" : ", correlationKey: " + target.getCorrelationKey()) + ", message: " + messageName + ", error: " + e.getClass().getName() + " - " + (String)exceptionMessage + "]";
            logger.warn(errorMessage);
            logger.debug("Error while sending Task", (Throwable)e);
            if (execution.getBpmnModelElementInstance() instanceof IntermediateThrowEvent) {
                this.handleIntermediateThrowEventError(execution, variables, e, errorMessage);
            }
            if (execution.getBpmnModelElementInstance() instanceof EndEvent) {
                this.handleEndEventError(execution, variables, e, errorMessage);
            }
            if (execution.getBpmnModelElementInstance() instanceof SendTask) {
                this.handleSendTaskError(execution, variables, e, errorMessage);
            }
            logger.warn("Error handling for {} not implemented", (Object)execution.getBpmnModelElementInstance().getClass().getName());
        }
    }

    protected void handleIntermediateThrowEventError(DelegateExecution execution, Variables variables, Exception exception, String errorMessage) {
        logger.debug("Error while executing Task message send " + this.getClass().getName(), (Throwable)exception);
        logger.error("Process {} has fatal error in step {} for task {}, reason: {} - {}", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), exception.getClass().getName(), exception.getMessage()});
        this.updateFailedIfInprogress(variables.getTasks(), errorMessage);
        execution.getProcessEngine().getRuntimeService().deleteProcessInstance(execution.getProcessInstanceId(), exception.getMessage());
    }

    protected void handleEndEventError(DelegateExecution execution, Variables variables, Exception exception, String errorMessage) {
        logger.debug("Error while executing Task message send " + this.getClass().getName(), (Throwable)exception);
        logger.error("Process {} has fatal error in step {} for task {}, reason: {} - {}", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), exception.getClass().getName(), exception.getMessage()});
        this.updateFailedIfInprogress(variables.getTasks(), errorMessage);
    }

    protected void handleSendTaskError(DelegateExecution execution, Variables variables, Exception exception, String errorMessage) {
        Targets targets = variables.getTargets();
        if (targets != null && !targets.isEmpty()) {
            Target target = variables.getTarget();
            targets = targets.removeByEndpointIdentifierValue(target);
            variables.setTargets(targets);
            this.addErrorIfInprogress(variables.getTasks(), errorMessage);
            logger.debug("Target organization {}, endpoint {} with error {} removed from target list", new Object[]{target.getOrganizationIdentifierValue(), target.getEndpointIdentifierValue(), exception.getMessage()});
        } else {
            logger.debug("Error while executing Task message send " + this.getClass().getName(), (Throwable)exception);
            logger.error("Process {} has fatal error in step {} for task {}, last reason: {} - ", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), exception.getClass().getName(), exception.getMessage()});
            this.updateFailedIfInprogress(variables.getTasks(), errorMessage);
            execution.getProcessEngine().getRuntimeService().deleteProcessInstance(execution.getProcessInstanceId(), exception.getMessage());
        }
    }

    private void addErrorIfInprogress(List<Task> tasks, String errorMessage) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = tasks.get(i);
            if (Task.TaskStatus.INPROGRESS.equals((Object)task.getStatus())) {
                this.addErrorMessage(task, errorMessage);
                continue;
            }
            logger.debug("Not adding error to Task {} with status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus());
        }
    }

    private void updateFailedIfInprogress(List<Task> tasks, String errorMessage) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = tasks.get(i);
            if (Task.TaskStatus.INPROGRESS.equals((Object)task.getStatus())) {
                task.setStatus(Task.TaskStatus.FAILED);
                this.addErrorMessage(task, errorMessage);
                this.updateAndHandleException(task);
                continue;
            }
            logger.debug("Not updating Task {} with status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus());
        }
    }

    protected void addErrorMessage(Task task, String errorMessage) {
        task.addOutput(new Task.TaskOutputComponent(new CodeableConcept(CodeSystems.BpmnMessage.error()), (Type)new StringType(errorMessage)));
    }

    private void updateAndHandleException(Task task) {
        try {
            logger.debug("Updating Task {}, new status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus().toCode());
            this.api.getFhirWebserviceClientProvider().getLocalWebserviceClient().withMinimalReturn().update((Resource)task);
        }
        catch (Exception e) {
            logger.error("Unable to update Task " + this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Throwable)e);
        }
    }

    protected Stream<Task.ParameterComponent> getAdditionalInputParameters(DelegateExecution execution, Variables variables) {
        return Stream.empty();
    }

    protected final String createAndSaveAlternativeBusinessKey(DelegateExecution execution, Variables variables) {
        String alternativeBusinessKey = UUID.randomUUID().toString();
        variables.setAlternativeBusinessKey(alternativeBusinessKey);
        return alternativeBusinessKey;
    }

    protected void sendTask(DelegateExecution execution, Variables variables, Target target, String instantiatesCanonical, String messageName, String businessKey, String profile, Stream<Task.ParameterComponent> additionalInputParameters) {
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(instantiatesCanonical, "instantiatesCanonical");
        if (instantiatesCanonical.isEmpty()) {
            throw new IllegalArgumentException("instantiatesCanonical empty");
        }
        Objects.requireNonNull(messageName, "messageName");
        if (messageName.isEmpty()) {
            throw new IllegalArgumentException("messageName empty");
        }
        Objects.requireNonNull(businessKey, "businessKey");
        if (businessKey.isEmpty()) {
            throw new IllegalArgumentException("profile empty");
        }
        Objects.requireNonNull(profile, "profile");
        if (profile.isEmpty()) {
            throw new IllegalArgumentException("profile empty");
        }
        Task task = new Task();
        task.setMeta(new Meta().addProfile(profile));
        task.setStatus(Task.TaskStatus.REQUESTED);
        task.setIntent(Task.TaskIntent.ORDER);
        task.setAuthoredOn(new Date());
        task.setRequester(this.getRequester());
        task.getRestriction().addRecipient(this.getRecipient(target));
        task.setInstantiatesCanonical(instantiatesCanonical);
        Task.ParameterComponent messageNameInput = new Task.ParameterComponent(new CodeableConcept(CodeSystems.BpmnMessage.messageName()), (Type)new StringType(messageName));
        task.getInput().add(messageNameInput);
        Task.ParameterComponent businessKeyInput = new Task.ParameterComponent(new CodeableConcept(CodeSystems.BpmnMessage.businessKey()), (Type)new StringType(businessKey));
        task.getInput().add(businessKeyInput);
        String correlationKey = target.getCorrelationKey();
        if (correlationKey != null) {
            Task.ParameterComponent correlationKeyInput = new Task.ParameterComponent(new CodeableConcept(CodeSystems.BpmnMessage.correlationKey()), (Type)new StringType(correlationKey));
            task.getInput().add(correlationKeyInput);
        }
        if (additionalInputParameters != null) {
            additionalInputParameters.forEach(task.getInput()::add);
        }
        FhirWebserviceClient client = this.api.getFhirWebserviceClientProvider().getWebserviceClient(target.getEndpointUrl());
        if (correlationKey != null) {
            logger.info("Sending task {} [recipient: {}, endpoint: {}, businessKey: {}, correlationKey: {}, message: {}] ...", new Object[]{task.getInstantiatesCanonical(), target.getOrganizationIdentifierValue(), target.getEndpointIdentifierValue(), businessKey, correlationKey, messageName});
        } else {
            logger.info("Sending task {} [recipient: {}, endpoint: {}, businessKey: {}, message: {}] ...", new Object[]{task.getInstantiatesCanonical(), target.getOrganizationIdentifierValue(), target.getEndpointIdentifierValue(), businessKey, messageName});
        }
        logger.trace("Task resource to send: {}", (Object)this.api.getFhirContext().newJsonParser().encodeResourceToString((IBaseResource)task));
        IdType created = this.doSend(client, task);
        logger.info("Task {} send [task: {}]", (Object)task.getInstantiatesCanonical(), (Object)created.toVersionless().getValue());
    }

    protected IdType doSend(FhirWebserviceClient client, Task task) {
        return client.withMinimalReturn().create((Resource)task);
    }

    protected Reference getRecipient(Target target) {
        return new Reference().setType(ResourceType.Organization.name()).setIdentifier(NamingSystems.OrganizationIdentifier.withValue(target.getOrganizationIdentifierValue()));
    }

    protected Reference getRequester() {
        return new Reference().setType(ResourceType.Organization.name()).setIdentifier(this.api.getOrganizationProvider().getLocalOrganizationIdentifier().orElseThrow(() -> new IllegalStateException("Local organization identifier unknown")));
    }
}

