/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.activity;

import dev.dsf.bpe.v1.ProcessPluginApi;
import dev.dsf.bpe.v1.constants.CodeSystems;
import dev.dsf.bpe.v1.variables.Variables;
import dev.dsf.fhir.client.BasicFhirWebserviceClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultUserTaskListener
implements TaskListener,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUserTaskListener.class);
    private final ProcessPluginApi api;

    public DefaultUserTaskListener(ProcessPluginApi api) {
        this.api = api;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.api, "api");
    }

    public final void notify(DelegateTask userTask) {
        DelegateExecution execution = userTask.getExecution();
        Variables variables = this.api.getVariables(execution);
        try {
            logger.trace("Execution of user task with id='{}'", (Object)execution.getCurrentActivityId());
            String questionnaireUrlWithVersion = userTask.getBpmnModelElementInstance().getCamundaFormKey();
            Questionnaire questionnaire = this.readQuestionnaire(questionnaireUrlWithVersion);
            String businessKey = execution.getBusinessKey();
            String userTaskId = userTask.getId();
            QuestionnaireResponse questionnaireResponse = this.createDefaultQuestionnaireResponse(questionnaireUrlWithVersion, businessKey, userTaskId);
            this.transformQuestionnaireItemsToQuestionnaireResponseItems(questionnaireResponse, questionnaire);
            this.beforeQuestionnaireResponseCreate(userTask, questionnaireResponse);
            this.checkQuestionnaireResponse(questionnaireResponse);
            QuestionnaireResponse created = ((BasicFhirWebserviceClient)this.api.getFhirWebserviceClientProvider().getLocalWebserviceClient().withRetryForever(60000L)).create(questionnaireResponse);
            logger.info("Created QuestionnaireResponse for user task at {}, process waiting for it's completion", (Object)this.api.getQuestionnaireResponseHelper().getLocalVersionlessAbsoluteUrl(created));
            this.afterQuestionnaireResponseCreate(userTask, created);
        }
        catch (Exception exception) {
            logger.debug("Error while executing user task listener {}", (Object)this.getClass().getName(), (Object)exception);
            logger.error("Process {} has fatal error in step {} for task {}, reason: {} - {}", new Object[]{execution.getProcessDefinitionId(), execution.getActivityInstanceId(), this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(variables.getStartTask()), exception.getClass().getName(), exception.getMessage()});
            String errorMessage = "Process " + execution.getProcessDefinitionId() + " has fatal error in step " + execution.getActivityInstanceId() + ", reason: " + exception.getMessage();
            this.updateFailedIfInprogress(variables.getTasks(), errorMessage);
            execution.getProcessEngine().getRuntimeService().deleteProcessInstance(execution.getProcessInstanceId(), exception.getMessage());
        }
    }

    private Questionnaire readQuestionnaire(String urlWithVersion) {
        Bundle search = this.api.getFhirWebserviceClientProvider().getLocalWebserviceClient().search(Questionnaire.class, Map.of("url", Collections.singletonList(urlWithVersion)));
        List questionnaires = search.getEntry().stream().filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(r -> r instanceof Questionnaire).map(r -> (Questionnaire)r).collect(Collectors.toList());
        if (questionnaires.size() < 1) {
            throw new RuntimeException("Could not find Questionnaire resource with url|version=" + urlWithVersion);
        }
        if (questionnaires.size() > 1) {
            logger.info("Found {} Questionnaire resources with url|version={}, using the first", (Object)questionnaires.size(), (Object)urlWithVersion);
        }
        return (Questionnaire)questionnaires.get(0);
    }

    private QuestionnaireResponse createDefaultQuestionnaireResponse(String questionnaireUrlWithVersion, String businessKey, String userTaskId) {
        QuestionnaireResponse questionnaireResponse = new QuestionnaireResponse();
        questionnaireResponse.setQuestionnaire(questionnaireUrlWithVersion);
        questionnaireResponse.setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
        questionnaireResponse.setAuthor(new Reference().setType(ResourceType.Organization.name()).setIdentifier(this.api.getOrganizationProvider().getLocalOrganizationIdentifier().orElseThrow(() -> new IllegalStateException("Local organization identifier unknown"))));
        this.api.getQuestionnaireResponseHelper().addItemLeafWithAnswer(questionnaireResponse, "business-key", "The business-key of the process execution", (Type)new StringType(businessKey));
        this.api.getQuestionnaireResponseHelper().addItemLeafWithAnswer(questionnaireResponse, "user-task-id", "The user-task-id of the process execution", (Type)new StringType(userTaskId));
        return questionnaireResponse;
    }

    private void transformQuestionnaireItemsToQuestionnaireResponseItems(QuestionnaireResponse questionnaireResponse, Questionnaire questionnaire) {
        questionnaire.getItem().stream().filter(i -> !"business-key".equals(i.getLinkId())).filter(i -> !"user-task-id".equals(i.getLinkId())).forEach(i -> this.transformItem(questionnaireResponse, (Questionnaire.QuestionnaireItemComponent)i));
    }

    private void transformItem(QuestionnaireResponse questionnaireResponse, Questionnaire.QuestionnaireItemComponent question) {
        if (Questionnaire.QuestionnaireItemType.DISPLAY.equals((Object)question.getType())) {
            this.api.getQuestionnaireResponseHelper().addItemLeafWithoutAnswer(questionnaireResponse, question.getLinkId(), question.getText());
        } else {
            Type answer = this.api.getQuestionnaireResponseHelper().transformQuestionTypeToAnswerType(question);
            this.api.getQuestionnaireResponseHelper().addItemLeafWithAnswer(questionnaireResponse, question.getLinkId(), question.getText(), answer);
        }
    }

    private void checkQuestionnaireResponse(QuestionnaireResponse questionnaireResponse) {
        questionnaireResponse.getItem().stream().filter(i -> "business-key".equals(i.getLinkId())).findFirst().orElseThrow(() -> new RuntimeException("QuestionnaireResponse does not contain an item with linkId='business-key'"));
        questionnaireResponse.getItem().stream().filter(i -> "user-task-id".equals(i.getLinkId())).findFirst().orElseThrow(() -> new RuntimeException("QuestionnaireResponse does not contain an item with linkId='user-task-id'"));
        if (!QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS.equals((Object)questionnaireResponse.getStatus())) {
            throw new RuntimeException("QuestionnaireResponse must be in status 'in-progress'");
        }
    }

    protected void beforeQuestionnaireResponseCreate(DelegateTask userTask, QuestionnaireResponse beforeCreate) {
    }

    protected void afterQuestionnaireResponseCreate(DelegateTask userTask, QuestionnaireResponse afterCreate) {
    }

    private void updateFailedIfInprogress(List<Task> tasks, String errorMessage) {
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = tasks.get(i);
            if (Task.TaskStatus.INPROGRESS.equals((Object)task.getStatus())) {
                task.setStatus(Task.TaskStatus.FAILED);
                task.addOutput(new Task.TaskOutputComponent(new CodeableConcept(CodeSystems.BpmnMessage.error()), (Type)new StringType(errorMessage)));
                this.updateAndHandleException(task);
                continue;
            }
            logger.debug("Not updating Task {} with status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus());
        }
    }

    private void updateAndHandleException(Task task) {
        try {
            logger.debug("Updating Task {}, new status: {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus().toCode());
            this.api.getFhirWebserviceClientProvider().getLocalWebserviceClient().withMinimalReturn().update((Resource)task);
        }
        catch (Exception e) {
            logger.debug("Unable to update Task {}", (Object)this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), (Object)e);
            logger.error("Unable to update Task {}: {} - {}", new Object[]{this.api.getTaskHelper().getLocalVersionlessAbsoluteUrl(task), e.getClass().getName(), e.getMessage()});
        }
    }
}

