/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.OrganizationIdentity;
import dev.dsf.common.auth.conf.PractitionerIdentity;
import dev.dsf.fhir.authorization.process.Recipient;
import dev.dsf.fhir.authorization.process.Requester;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class Organization
implements Recipient,
Requester {
    private final String organizationIdentifier;
    private final boolean localIdentity;
    private final String practitionerRoleSystem;
    private final String practitionerRoleCode;

    public Organization(boolean localIdentity, String organizationIdentifier, String practitionerRoleSystem, String practitionerRoleCode) {
        Objects.requireNonNull(organizationIdentifier, "organizationIdentifier");
        if (organizationIdentifier.isBlank()) {
            throw new IllegalArgumentException("organizationIdentifier blank");
        }
        this.localIdentity = localIdentity;
        this.organizationIdentifier = organizationIdentifier;
        this.practitionerRoleSystem = practitionerRoleSystem;
        this.practitionerRoleCode = practitionerRoleCode;
    }

    private boolean needsPractitionerRole() {
        return this.practitionerRoleSystem != null && this.practitionerRoleCode != null;
    }

    @Override
    public boolean isRequesterAuthorized(Identity requester, Stream<OrganizationAffiliation> requesterAffiliations) {
        return this.isAuthorized(requester);
    }

    @Override
    public boolean isRecipientAuthorized(Identity recipient, Stream<OrganizationAffiliation> recipientAffiliations) {
        return this.isAuthorized(recipient);
    }

    private boolean isAuthorized(Identity identity) {
        return identity != null && identity.getOrganization() != null && identity.getOrganization().getActive() && identity.isLocalIdentity() == this.localIdentity && this.hasOrganizationIdentifier(identity.getOrganization()) && (this.needsPractitionerRole() && this.hasPractitionerRole(this.getPractitionerRoles(identity)) || !this.needsPractitionerRole() && identity instanceof OrganizationIdentity);
    }

    private boolean hasOrganizationIdentifier(org.hl7.fhir.r4.model.Organization organization) {
        return organization.getIdentifier().stream().filter(Identifier::hasSystem).filter(Identifier::hasValue).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).anyMatch(i -> this.organizationIdentifier.equals(i.getValue()));
    }

    private Set<Coding> getPractitionerRoles(Identity identity) {
        if (identity instanceof PractitionerIdentity) {
            PractitionerIdentity p = (PractitionerIdentity)identity;
            return p.getPractionerRoles();
        }
        return Collections.emptySet();
    }

    private boolean hasPractitionerRole(Set<Coding> practitionerRoles) {
        return practitionerRoles.stream().anyMatch(c -> this.practitionerRoleSystem.equals(c.getSystem()) && this.practitionerRoleCode.equals(c.getCode()));
    }

    @Override
    public Extension toRecipientExtension() {
        return new Extension().setUrl("recipient").setValue((Type)this.toCoding(false));
    }

    @Override
    public Extension toRequesterExtension() {
        return new Extension().setUrl("requester").setValue((Type)this.toCoding(this.needsPractitionerRole()));
    }

    private Coding toCoding(boolean needsPractitionerRole) {
        Identifier organization = new Reference().getIdentifier().setSystem("http://dsf.dev/sid/organization-identifier").setValue(this.organizationIdentifier);
        Coding coding = this.getProcessAuthorizationCode();
        if (needsPractitionerRole) {
            Extension extension = coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner");
            extension.addExtension("organization", (Type)organization);
            extension.addExtension("practitioner-role", (Type)new Coding(this.practitionerRoleSystem, this.practitionerRoleCode, null));
        } else {
            coding.addExtension().setUrl("http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization").setValue((Type)organization);
        }
        return coding;
    }

    @Override
    public Coding getProcessAuthorizationCode() {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ORGANIZATION_PRACTITIONER", null);
            }
            return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "LOCAL_ORGANIZATION", null);
        }
        return new Coding("http://dsf.dev/fhir/CodeSystem/process-authorization", "REMOTE_ORGANIZATION", null);
    }

    @Override
    public boolean requesterMatches(Extension requesterExtension) {
        return this.matches(requesterExtension, "requester", this.needsPractitionerRole());
    }

    @Override
    public boolean recipientMatches(Extension recipientExtension) {
        return this.matches(recipientExtension, "recipient", false);
    }

    private boolean matches(Extension extension, String url, boolean needsPractitionerRole) {
        Coding value;
        Type type;
        return extension != null && url.equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.matches(value = (Coding)type) && value.hasExtension() && this.hasMatchingOrganizationExtension(value.getExtension(), needsPractitionerRole);
    }

    private boolean hasMatchingOrganizationExtension(List<Extension> extensions, boolean needsPractitionerRole) {
        return extensions.stream().anyMatch(this.organizationExtensionMatches(needsPractitionerRole));
    }

    private Predicate<Extension> organizationExtensionMatches(boolean needsPractitionerRole) {
        if (needsPractitionerRole) {
            return extension -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner".equals(extension.getUrl()) && !extension.hasValue() && this.hasMatchingSubOrganizationExtension(extension.getExtension()) && this.hasMatchingPractitionerExtension(extension.getExtension());
        }
        return extension -> {
            Identifier value;
            Type patt0$temp;
            return "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization".equals(extension.getUrl()) && extension.hasValue() && (patt0$temp = extension.getValue()) instanceof Identifier && this.organizationIdentifierMatches(value = (Identifier)patt0$temp);
        };
    }

    private boolean organizationIdentifierMatches(Identifier identifier) {
        return identifier != null && identifier.hasSystem() && identifier.hasValue() && "http://dsf.dev/sid/organization-identifier".equals(identifier.getSystem()) && this.organizationIdentifier.equals(identifier.getValue());
    }

    private boolean hasMatchingSubOrganizationExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::subOrganizationExtensionMatches);
    }

    private boolean subOrganizationExtensionMatches(Extension extension) {
        Identifier value;
        Type type;
        return "organization".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Identifier && this.organizationIdentifierMatches(value = (Identifier)type);
    }

    private boolean hasMatchingPractitionerExtension(List<Extension> extensions) {
        return extensions.stream().anyMatch(this::practitionerExtensionMatches);
    }

    private boolean practitionerExtensionMatches(Extension extension) {
        Coding value;
        Type type;
        return "practitioner-role".equals(extension.getUrl()) && extension.hasValue() && (type = extension.getValue()) instanceof Coding && this.practitionerRoleMatches(value = (Coding)type);
    }

    private boolean practitionerRoleMatches(Coding coding) {
        return coding != null && coding.hasSystem() && coding.hasCode() && this.practitionerRoleSystem.equals(coding.getSystem()) && this.practitionerRoleCode.equals(coding.getCode());
    }

    @Override
    public boolean matches(Coding processAuthorizationCode) {
        if (this.localIdentity) {
            if (this.needsPractitionerRole()) {
                return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ORGANIZATION_PRACTITIONER".equals(processAuthorizationCode.getCode());
            }
            return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "LOCAL_ORGANIZATION".equals(processAuthorizationCode.getCode());
        }
        return processAuthorizationCode != null && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(processAuthorizationCode.getSystem()) && "REMOTE_ORGANIZATION".equals(processAuthorizationCode.getCode());
    }

    public static Optional<Requester> fromRequester(Coding coding, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode()) {
            if ("LOCAL_ORGANIZATION".equals(coding.getCode())) {
                return Organization.from(true, coding, organizationWithIdentifierExists).map(r -> (Requester)r);
            }
            if ("REMOTE_ORGANIZATION".equals(coding.getCode())) {
                return Organization.from(false, coding, organizationWithIdentifierExists).map(r -> (Requester)r);
            }
            if ("LOCAL_ORGANIZATION_PRACTITIONER".equals(coding.getCode())) {
                return Organization.fromPractitionerRequester(coding, practitionerRoleExists, organizationWithIdentifierExists);
            }
        }
        return Optional.empty();
    }

    public static Optional<Recipient> fromRecipient(Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        if (coding != null && coding.hasSystem() && "http://dsf.dev/fhir/CodeSystem/process-authorization".equals(coding.getSystem()) && coding.hasCode() && "LOCAL_ORGANIZATION".equals(coding.getCode())) {
            return Organization.from(true, coding, organizationWithIdentifierExists).map(r -> (Recipient)r);
        }
        return Optional.empty();
    }

    private static Optional<? super Organization> from(boolean localIdentity, Coding coding, Predicate<Identifier> organizationWithIdentifierExists) {
        Identifier identifier;
        Type type;
        Extension organization;
        List organizations;
        if (coding != null && coding.hasExtension() && (organizations = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization".equals(e.getUrl())).collect(Collectors.toList())).size() == 1 && (organization = (Extension)organizations.get(0)).hasValue() && (type = organization.getValue()) instanceof Identifier && "http://dsf.dev/sid/organization-identifier".equals((identifier = (Identifier)type).getSystem()) && organizationWithIdentifierExists.test(identifier)) {
            return Optional.of(new Organization(localIdentity, identifier.getValue(), null, null));
        }
        return Optional.empty();
    }

    private static Optional<Requester> fromPractitionerRequester(Coding coding, Predicate<Coding> practitionerRoleExists, Predicate<Identifier> organizationWithIdentifierExists) {
        List organizationPractitioners;
        if (coding != null && coding.hasExtension() && (organizationPractitioners = coding.getExtension().stream().filter(Extension::hasUrl).filter(e -> "http://dsf.dev/fhir/StructureDefinition/extension-process-authorization-organization-practitioner".equals(e.getUrl())).collect(Collectors.toList())).size() == 1) {
            Extension organizationPractitioner = (Extension)organizationPractitioners.get(0);
            List organizations = organizationPractitioner.getExtension().stream().filter(Extension::hasUrl).filter(e -> "organization".equals(e.getUrl())).collect(Collectors.toList());
            List practitionerRoles = organizationPractitioner.getExtension().stream().filter(Extension::hasUrl).filter(e -> "practitioner-role".equals(e.getUrl())).collect(Collectors.toList());
            if (organizations.size() == 1 && practitionerRoles.size() == 1) {
                Type type;
                Extension organization = (Extension)organizations.get(0);
                Extension practitionerRole = (Extension)practitionerRoles.get(0);
                if (organization.hasValue() && (type = organization.getValue()) instanceof Identifier) {
                    Identifier organizationIdentifier = (Identifier)type;
                    if (practitionerRole.hasValue() && (type = practitionerRole.getValue()) instanceof Coding) {
                        Coding practitionerRoleCoding = (Coding)type;
                        if ("http://dsf.dev/sid/organization-identifier".equals(organizationIdentifier.getSystem()) && organizationWithIdentifierExists.test(organizationIdentifier) && practitionerRoleExists.test(practitionerRoleCoding)) {
                            return Optional.of(new Organization(true, organizationIdentifier.getValue(), practitionerRoleCoding.getSystem(), practitionerRoleCoding.getCode()));
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }
}

