/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization.process;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authorization.process.All;
import dev.dsf.fhir.authorization.process.Organization;
import dev.dsf.fhir.authorization.process.Role;
import dev.dsf.fhir.authorization.process.WithAuthorization;
import java.util.Collection;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OrganizationAffiliation;

public interface Recipient
extends WithAuthorization {
    public static Recipient localAll() {
        return new All(true, null, null);
    }

    public static Recipient localOrganization(String organizationIdentifier) {
        return new Organization(true, organizationIdentifier, null, null);
    }

    public static Recipient localRole(String parentOrganizationIdentifier, String roleSystem, String roleCode) {
        return new Role(true, parentOrganizationIdentifier, roleSystem, roleCode, null, null);
    }

    public boolean recipientMatches(Extension var1);

    public boolean isRecipientAuthorized(Identity var1, Stream<OrganizationAffiliation> var2);

    default public boolean isRecipientAuthorized(Identity recipientUser, Collection<OrganizationAffiliation> recipientAffiliations) {
        return this.isRecipientAuthorized(recipientUser, recipientAffiliations == null ? null : recipientAffiliations.stream());
    }

    public Extension toRecipientExtension();
}

