/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFhirWebserviceClientJerseyWithRetry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFhirWebserviceClientJerseyWithRetry.class);
    protected final FhirWebserviceClientJersey delegate;
    protected final int nTimes;
    protected final long delayMillis;

    protected AbstractFhirWebserviceClientJerseyWithRetry(FhirWebserviceClientJersey delegate, int nTimes, long delayMillis) {
        this.delegate = delegate;
        this.nTimes = nTimes;
        this.delayMillis = delayMillis;
    }

    protected final <R> R retry(int nTimes, long delayMillis, Supplier<R> supplier) {
        Throwable caughtException = null;
        for (int tryNumber = 0; tryNumber <= nTimes || nTimes == -1; ++tryNumber) {
            try {
                if (tryNumber == 0) {
                    logger.debug("First try ...");
                } else if (nTimes != -1) {
                    logger.debug("Retry {} of {}", (Object)tryNumber, (Object)nTimes);
                }
                return supplier.get();
            }
            catch (ProcessingException | WebApplicationException e) {
                if (this.shouldRetry((RuntimeException)e)) {
                    if (tryNumber < nTimes || nTimes == -1) {
                        logger.warn("Caught {} - {}; trying again in {} ms{}", new Object[]{e.getClass(), e.getMessage(), delayMillis, nTimes == -1 ? " (retry " + (tryNumber + 1) + ")" : ""});
                        try {
                            Thread.sleep(delayMillis);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        logger.warn("Caught {} - {}; not trying again", e.getClass(), (Object)e.getMessage());
                    }
                    if (caughtException != null) {
                        e.addSuppressed(caughtException);
                    }
                } else {
                    throw e;
                }
                caughtException = e;
                continue;
            }
        }
        throw caughtException;
    }

    private boolean shouldRetry(RuntimeException e) {
        if (e instanceof WebApplicationException) {
            WebApplicationException w = (WebApplicationException)((Object)e);
            return this.isRetryStatusCode(w);
        }
        if (e instanceof ProcessingException) {
            Throwable cause = e;
            if (this.isRetryCause(cause)) {
                return true;
            }
            while (cause.getCause() != null) {
                if (!this.isRetryCause(cause = cause.getCause())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRetryStatusCode(WebApplicationException e) {
        return Response.Status.Family.SERVER_ERROR.equals((Object)e.getResponse().getStatusInfo().getFamily());
    }

    private boolean isRetryCause(Throwable cause) {
        return cause instanceof ConnectTimeoutException || cause instanceof HttpHostConnectException || cause instanceof UnknownHostException;
    }
}

