/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.security.KeyStore;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.glassfish.jersey.logging.LoggingFeature;

public class AbstractJerseyClient {
    private static final Logger requestDebugLogger = Logger.getLogger(AbstractJerseyClient.class.getName());
    private final Client client;
    private final String baseUrl;

    public AbstractJerseyClient(String baseUrl, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword, ObjectMapper objectMapper, Collection<?> componentsToRegister) {
        this(baseUrl, trustStore, keyStore, keyStorePassword, objectMapper, componentsToRegister, null, null, null, 0, 0, false, null);
    }

    public AbstractJerseyClient(String baseUrl, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword, ObjectMapper objectMapper, Collection<?> componentsToRegister, String proxySchemeHostPort, String proxyUserName, char[] proxyPassword, int connectTimeout, int readTimeout, boolean logRequests, String userAgentValue) {
        SSLContext sslContext = null;
        if (trustStore != null && keyStore == null && keyStorePassword == null) {
            sslContext = SslConfigurator.newInstance().trustStore(trustStore).createSSLContext();
        } else if (trustStore != null && keyStore != null && keyStorePassword != null) {
            sslContext = SslConfigurator.newInstance().trustStore(trustStore).keyStore(keyStore).keyStorePassword(keyStorePassword).createSSLContext();
        }
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            builder = builder.sslContext(sslContext);
        }
        ClientConfig config = new ClientConfig();
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        config.property("jersey.config.client.proxy.uri", (Object)proxySchemeHostPort);
        config.property("jersey.config.client.proxy.username", (Object)proxyUserName);
        config.property("jersey.config.client.proxy.password", (Object)(proxyPassword == null ? null : String.valueOf(proxyPassword)));
        builder = builder.withConfig((Configuration)config);
        if (userAgentValue != null && !userAgentValue.isBlank()) {
            builder = (ClientBuilder)builder.register(requestContext -> requestContext.getHeaders().add((Object)"User-Agent", (Object)userAgentValue));
        }
        builder = builder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        if (objectMapper != null) {
            JacksonJaxbJsonProvider p = new JacksonJaxbJsonProvider(JacksonJsonProvider.BASIC_ANNOTATIONS);
            p.setMapper(objectMapper);
            builder.register((Object)p);
        }
        if (componentsToRegister != null) {
            componentsToRegister.forEach(arg_0 -> ((ClientBuilder)builder).register(arg_0));
        }
        if (logRequests) {
            builder = (ClientBuilder)builder.register((Object)new LoggingFeature(requestDebugLogger, Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(8192)));
        }
        this.client = builder.build();
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    protected WebTarget getResource() {
        return this.client.target(this.baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    static {
        requestDebugLogger.setLevel(Level.INFO);
    }
}

