/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.dsf.fhir.adapter.FhirAdapter;
import dev.dsf.fhir.client.AbstractJerseyClient;
import dev.dsf.fhir.client.BasicFhirWebserviceCientWithRetryImpl;
import dev.dsf.fhir.client.BasicFhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.PreferReturn;
import dev.dsf.fhir.client.PreferReturnMinimalWithRetry;
import dev.dsf.fhir.client.PreferReturnMinimalWithRetryImpl;
import dev.dsf.fhir.client.PreferReturnOutcomeWithRetry;
import dev.dsf.fhir.client.PreferReturnOutcomeWithRetryImpl;
import dev.dsf.fhir.prefer.PreferHandlingType;
import dev.dsf.fhir.prefer.PreferReturnType;
import dev.dsf.fhir.service.ReferenceCleaner;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.InputStream;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirWebserviceClientJersey
extends AbstractJerseyClient
implements FhirWebserviceClient {
    private static final Logger logger = LoggerFactory.getLogger(FhirWebserviceClientJersey.class);
    private static final String RFC_7231_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Map<String, Class<?>> RESOURCE_TYPES_BY_NAME = Stream.of(ResourceType.values()).filter(type -> !ResourceType.List.equals(type)).collect(Collectors.toMap(Enum::name, FhirWebserviceClientJersey::getFhirClass));
    private final ReferenceCleaner referenceCleaner;
    private final PreferReturnMinimalWithRetry preferReturnMinimal;
    private final PreferReturnOutcomeWithRetry preferReturnOutcome;

    private static Class<?> getFhirClass(ResourceType type) {
        try {
            return Class.forName("org.hl7.fhir.r4.model." + type.name());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public FhirWebserviceClientJersey(String baseUrl, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword, ObjectMapper objectMapper, String proxySchemeHostPort, String proxyUserName, char[] proxyPassword, int connectTimeout, int readTimeout, boolean logRequests, String userAgentValue, FhirContext fhirContext, ReferenceCleaner referenceCleaner) {
        super(baseUrl, trustStore, keyStore, keyStorePassword, objectMapper, Collections.singleton(new FhirAdapter(fhirContext)), proxySchemeHostPort, proxyUserName, proxyPassword, connectTimeout, readTimeout, logRequests, userAgentValue);
        this.referenceCleaner = referenceCleaner;
        this.preferReturnMinimal = new PreferReturnMinimalWithRetryImpl(this);
        this.preferReturnOutcome = new PreferReturnOutcomeWithRetryImpl(this);
    }

    private WebApplicationException handleError(Response response) {
        try {
            OperationOutcome outcome = (OperationOutcome)response.readEntity(OperationOutcome.class);
            String message = this.toString(outcome);
            logger.warn("Request failed, OperationOutcome: {}", (Object)message);
            return new WebApplicationException(message, response.getStatus());
        }
        catch (ProcessingException e) {
            response.close();
            logger.warn("Request failed: {} - {}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            return new WebApplicationException((Throwable)e, response.getStatus());
        }
    }

    private String toString(OperationOutcome outcome) {
        return outcome == null ? "" : outcome.getIssue().stream().map(this::toString).collect(Collectors.joining("\n"));
    }

    private String toString(OperationOutcome.OperationOutcomeIssueComponent issue) {
        return issue == null ? "" : String.valueOf(issue.getSeverity()) + " " + String.valueOf(issue.getCode()) + " " + issue.getDiagnostics();
    }

    private void logStatusAndHeaders(Response response) {
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        logger.debug("HTTP header Location: {}", (Object)response.getLocation());
        logger.debug("HTTP header ETag: {}", (Object)response.getHeaderString("ETag"));
        logger.debug("HTTP header Last-Modified: {}", (Object)response.getHeaderString("Last-Modified"));
    }

    private PreferReturn toPreferReturn(PreferReturnType returnType, Class<? extends Resource> resourceType, Response response) {
        return switch (returnType) {
            case PreferReturnType.REPRESENTATION -> {
                Resource resource = this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)response.readEntity(resourceType));
                yield PreferReturn.resource(resource);
            }
            case PreferReturnType.MINIMAL -> PreferReturn.minimal(response.getLocation());
            case PreferReturnType.OPERATION_OUTCOME -> PreferReturn.outcome((OperationOutcome)response.readEntity(OperationOutcome.class));
            default -> throw new RuntimeException(PreferReturn.class.getName() + " value " + String.valueOf(returnType) + " not supported");
        };
    }

    @Override
    public PreferReturnMinimalWithRetry withMinimalReturn() {
        return this.preferReturnMinimal;
    }

    @Override
    public PreferReturnOutcomeWithRetry withOperationOutcomeReturn() {
        return this.preferReturnOutcome;
    }

    PreferReturn create(PreferReturnType returnType, Resource resource) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(resource, "resource");
        Response response = this.getResource().path(resource.getClass().getAnnotation(ResourceDef.class).name()).request().header("Prefer", (Object)returnType.getHeaderValue()).accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)resource, (String)"application/fhir+json"));
        this.logStatusAndHeaders(response);
        if (Response.Status.CREATED.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, resource.getClass(), response);
        }
        throw this.handleError(response);
    }

    PreferReturn createConditionaly(PreferReturnType returnType, Resource resource, String ifNoneExistCriteria) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(ifNoneExistCriteria, "ifNoneExistCriteria");
        Response response = this.getResource().path(resource.getClass().getAnnotation(ResourceDef.class).name()).request().header("Prefer", (Object)returnType.getHeaderValue()).header("If-None-Exist", (Object)ifNoneExistCriteria).accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)resource, (String)"application/fhir+json"));
        this.logStatusAndHeaders(response);
        if (Response.Status.CREATED.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, resource.getClass(), response);
        }
        throw this.handleError(response);
    }

    PreferReturn createBinary(PreferReturnType returnType, InputStream in, MediaType mediaType, String securityContextReference) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(mediaType, "mediaType");
        Invocation.Builder request = this.getResource().path("Binary").request().header("Prefer", (Object)returnType.getHeaderValue());
        if (securityContextReference != null && !securityContextReference.isBlank()) {
            request = request.header("X-Security-Context", (Object)securityContextReference);
        }
        Response response = request.accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)in, (MediaType)mediaType));
        this.logStatusAndHeaders(response);
        if (Response.Status.CREATED.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, Binary.class, response);
        }
        throw this.handleError(response);
    }

    PreferReturn update(PreferReturnType returnType, Resource resource) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(resource, "resource");
        Invocation.Builder builder = this.getResource().path(resource.getClass().getAnnotation(ResourceDef.class).name()).path(resource.getIdElement().getIdPart()).request().header("Prefer", (Object)returnType.getHeaderValue()).accept(new String[]{"application/fhir+json"});
        if (resource.getMeta().hasVersionId()) {
            builder.header("If-Match", (Object)new EntityTag(resource.getMeta().getVersionId(), true));
        }
        Response response = builder.put(Entity.entity((Object)resource, (String)"application/fhir+json"));
        this.logStatusAndHeaders(response);
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, resource.getClass(), response);
        }
        throw this.handleError(response);
    }

    PreferReturn updateConditionaly(PreferReturnType returnType, Resource resource, Map<String, List<String>> criteria) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(criteria, "criteria");
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("criteria map empty");
        }
        WebTarget target = this.getResource().path(resource.getClass().getAnnotation(ResourceDef.class).name());
        for (Map.Entry<String, List<String>> entry : criteria.entrySet()) {
            target = target.queryParam(entry.getKey(), entry.getValue().toArray());
        }
        Invocation.Builder builder = target.request().accept(new String[]{"application/fhir+json"}).header("Prefer", (Object)returnType.getHeaderValue());
        if (resource.getMeta().hasVersionId()) {
            builder.header("If-Match", (Object)new EntityTag(resource.getMeta().getVersionId(), true));
        }
        Response response = builder.put(Entity.entity((Object)resource, (String)"application/fhir+json"));
        this.logStatusAndHeaders(response);
        if (Response.Status.CREATED.getStatusCode() == response.getStatus() || Response.Status.OK.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, resource.getClass(), response);
        }
        throw this.handleError(response);
    }

    PreferReturn updateBinary(PreferReturnType returnType, String id, InputStream in, MediaType mediaType, String securityContextReference) {
        Objects.requireNonNull(returnType, "returnType");
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(mediaType, "mediaType");
        Invocation.Builder request = this.getResource().path("Binary").path(id).request().header("Prefer", (Object)returnType.getHeaderValue());
        if (securityContextReference != null && !securityContextReference.isBlank()) {
            request = request.header("X-Security-Context", (Object)securityContextReference);
        }
        Response response = request.accept(new String[]{"application/fhir+json"}).put(Entity.entity((Object)in, (MediaType)mediaType));
        this.logStatusAndHeaders(response);
        if (Response.Status.CREATED.getStatusCode() == response.getStatus()) {
            return this.toPreferReturn(returnType, Binary.class, response);
        }
        throw this.handleError(response);
    }

    Bundle postBundle(PreferReturnType returnType, Bundle bundle) {
        Objects.requireNonNull(bundle, "bundle");
        Response response = this.getResource().request().header("Prefer", (Object)returnType.getHeaderValue()).accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)bundle, (String)"application/fhir+json"));
        this.logStatusAndHeaders(response);
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (Bundle)this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)((Bundle)response.readEntity(Bundle.class)));
        }
        throw this.handleError(response);
    }

    @Override
    public <R extends Resource> R create(R resource) {
        return (R)this.create(PreferReturnType.REPRESENTATION, resource).getResource();
    }

    @Override
    public <R extends Resource> R createConditionaly(R resource, String ifNoneExistCriteria) {
        return (R)this.createConditionaly(PreferReturnType.REPRESENTATION, resource, ifNoneExistCriteria).getResource();
    }

    @Override
    public Binary createBinary(InputStream in, MediaType mediaType, String securityContextReference) {
        return (Binary)this.createBinary(PreferReturnType.REPRESENTATION, in, mediaType, securityContextReference).getResource();
    }

    @Override
    public <R extends Resource> R update(R resource) {
        return (R)this.update(PreferReturnType.REPRESENTATION, resource).getResource();
    }

    @Override
    public <R extends Resource> R updateConditionaly(R resource, Map<String, List<String>> criteria) {
        return (R)this.updateConditionaly(PreferReturnType.REPRESENTATION, resource, criteria).getResource();
    }

    @Override
    public Binary updateBinary(String id, InputStream in, MediaType mediaType, String securityContextReference) {
        return (Binary)this.updateBinary(PreferReturnType.REPRESENTATION, id, in, mediaType, securityContextReference).getResource();
    }

    @Override
    public Bundle postBundle(Bundle bundle) {
        return this.postBundle(PreferReturnType.REPRESENTATION, bundle);
    }

    @Override
    public void delete(Class<? extends Resource> resourceClass, String id) {
        Objects.requireNonNull(resourceClass, "resourceClass");
        Objects.requireNonNull(id, "id");
        Response response = this.getResource().path(resourceClass.getAnnotation(ResourceDef.class).name()).path(id).request().accept(new String[]{"application/fhir+json"}).delete();
        this.logStatusAndHeaders(response);
        if (Response.Status.OK.getStatusCode() != response.getStatus() && Response.Status.NO_CONTENT.getStatusCode() != response.getStatus()) {
            throw this.handleError(response);
        }
        response.close();
    }

    @Override
    public void deleteConditionaly(Class<? extends Resource> resourceClass, Map<String, List<String>> criteria) {
        Objects.requireNonNull(resourceClass, "resourceClass");
        Objects.requireNonNull(criteria, "criteria");
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("criteria map empty");
        }
        WebTarget target = this.getResource().path(resourceClass.getAnnotation(ResourceDef.class).name());
        for (Map.Entry<String, List<String>> entry : criteria.entrySet()) {
            target = target.queryParam(entry.getKey(), entry.getValue().toArray());
        }
        Response response = target.request().accept(new String[]{"application/fhir+json"}).delete();
        this.logStatusAndHeaders(response);
        if (Response.Status.OK.getStatusCode() != response.getStatus() && Response.Status.NO_CONTENT.getStatusCode() != response.getStatus()) {
            throw this.handleError(response);
        }
        response.close();
    }

    @Override
    public void deletePermanently(Class<? extends Resource> resourceClass, String id) {
        Objects.requireNonNull(resourceClass, "resourceClass");
        Objects.requireNonNull(id, "id");
        Response response = this.getResource().path(resourceClass.getAnnotation(ResourceDef.class).name()).path(id).path("$permanent-delete").request().accept(new String[]{"application/fhir+json"}).post(null);
        this.logStatusAndHeaders(response);
        if (Response.Status.OK.getStatusCode() != response.getStatus()) {
            throw this.handleError(response);
        }
        response.close();
    }

    @Override
    public Resource read(String resourceTypeName, String id) {
        Objects.requireNonNull(resourceTypeName, "resourceTypeName");
        Objects.requireNonNull(id, "id");
        if (!RESOURCE_TYPES_BY_NAME.containsKey(resourceTypeName)) {
            throw new IllegalArgumentException("Resource of type " + resourceTypeName + " not supported");
        }
        Response response = this.getResource().path(resourceTypeName).path(id).request().accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)response.readEntity(RESOURCE_TYPES_BY_NAME.get(resourceTypeName)));
        }
        throw this.handleError(response);
    }

    @Override
    public <R extends Resource> R read(Class<R> resourceType, String id) {
        return (R)this.read(resourceType, id, (Resource)null);
    }

    @Override
    public <R extends Resource> R read(R oldValue) {
        return (R)this.read(oldValue.getClass(), oldValue.getIdElement().getIdPart(), oldValue);
    }

    private <R extends Resource> R read(Class<R> resourceType, String id, R oldValue) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(id, "id");
        Invocation.Builder request = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name()).path(id).request();
        if (oldValue != null && oldValue.hasMeta()) {
            if (oldValue.getMeta().hasVersionId()) {
                EntityTag eTag = new EntityTag(oldValue.getMeta().getVersionIdElement().getValue(), true);
                String eTagValue = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)eTag);
                request.header("If-None-Match", (Object)eTagValue);
                logger.trace("Sending {} Header with value '{}'", (Object)"If-None-Match", (Object)eTagValue);
            }
            if (oldValue.getMeta().hasLastUpdated()) {
                String dateValue = this.formatRfc7231(oldValue.getMeta().getLastUpdated());
                request.header("If-Modified-Since", (Object)dateValue);
                logger.trace("Sending {} Header with value '{}'", (Object)"If-Modified-Since", (Object)dateValue.toString());
            }
        }
        Response response = request.accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (R)this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)response.readEntity(resourceType));
        }
        if (oldValue != null && oldValue.hasMeta() && (oldValue.getMeta().hasVersionId() || oldValue.getMeta().hasLastUpdated()) && Response.Status.NOT_MODIFIED.getStatusCode() == response.getStatus()) {
            return oldValue;
        }
        throw this.handleError(response);
    }

    private String formatRfc7231(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(RFC_7231_FORMAT, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    @Override
    public <R extends Resource> boolean exists(Class<R> resourceType, String id) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(id, "id");
        Response response = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name()).path(id).request().accept(new String[]{"application/fhir+json"}).head();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == response.getStatus()) {
            return false;
        }
        throw this.handleError(response);
    }

    @Override
    public InputStream readBinary(String id, MediaType mediaType) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(mediaType, "mediaType");
        Response response = this.getResource().path("Binary").path(id).request().accept(new MediaType[]{mediaType}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (InputStream)response.readEntity(InputStream.class);
        }
        throw this.handleError(response);
    }

    @Override
    public Resource read(String resourceTypeName, String id, String version) {
        Objects.requireNonNull(resourceTypeName, "resourceTypeName");
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(version, "version");
        if (!RESOURCE_TYPES_BY_NAME.containsKey(resourceTypeName)) {
            throw new IllegalArgumentException("Resource of type " + resourceTypeName + " not supported");
        }
        Response response = this.getResource().path(resourceTypeName).path(id).path("_history").path(version).request().accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)response.readEntity(RESOURCE_TYPES_BY_NAME.get(resourceTypeName)));
        }
        throw this.handleError(response);
    }

    @Override
    public <R extends Resource> R read(Class<R> resourceType, String id, String version) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(version, "version");
        Response response = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name()).path(id).path("_history").path(version).request().accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (R)this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)response.readEntity(resourceType));
        }
        throw this.handleError(response);
    }

    @Override
    public <R extends Resource> boolean exists(Class<R> resourceType, String id, String version) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(version, "version");
        Response response = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name()).path(id).path("_history").path(version).request().accept(new String[]{"application/fhir+json"}).head();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == response.getStatus()) {
            return false;
        }
        throw this.handleError(response);
    }

    @Override
    public InputStream readBinary(String id, String version, MediaType mediaType) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(mediaType, "mediaType");
        Response response = this.getResource().path("Binary").path(id).path("_history").path(version).request().accept(new MediaType[]{mediaType}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (InputStream)response.readEntity(InputStream.class);
        }
        throw this.handleError(response);
    }

    @Override
    public boolean exists(IdType resourceTypeIdVersion) {
        Objects.requireNonNull(resourceTypeIdVersion, "resourceTypeIdVersion");
        Objects.requireNonNull(resourceTypeIdVersion.getResourceType(), "resourceTypeIdVersion.resourceType");
        Objects.requireNonNull(resourceTypeIdVersion.getIdPart(), "resourceTypeIdVersion.idPart");
        WebTarget path = this.getResource().path(resourceTypeIdVersion.getResourceType()).path(resourceTypeIdVersion.getIdPart());
        if (resourceTypeIdVersion.hasVersionIdPart()) {
            path = path.path("_history").path(resourceTypeIdVersion.getVersionIdPart());
        }
        Response response = path.request().accept(new String[]{"application/fhir+json"}).head();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == response.getStatus()) {
            return false;
        }
        throw this.handleError(response);
    }

    @Override
    public Bundle search(Class<? extends Resource> resourceType, Map<String, List<String>> parameters) {
        Objects.requireNonNull(resourceType, "resourceType");
        WebTarget target = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name());
        if (parameters != null) {
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                target = target.queryParam(entry.getKey(), entry.getValue().toArray());
            }
        }
        Response response = target.request().accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (Bundle)this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)((Bundle)response.readEntity(Bundle.class)));
        }
        throw this.handleError(response);
    }

    @Override
    public Bundle searchWithStrictHandling(Class<? extends Resource> resourceType, Map<String, List<String>> parameters) {
        Objects.requireNonNull(resourceType, "resourceType");
        WebTarget target = this.getResource().path(resourceType.getAnnotation(ResourceDef.class).name());
        if (parameters != null) {
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                target = target.queryParam(entry.getKey(), entry.getValue().toArray());
            }
        }
        Response response = target.request().header("Prefer", (Object)PreferHandlingType.STRICT.getHeaderValue()).accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (Bundle)this.referenceCleaner.cleanReferenceResourcesIfBundle((Resource)((Bundle)response.readEntity(Bundle.class)));
        }
        throw this.handleError(response);
    }

    @Override
    public CapabilityStatement getConformance() {
        Response response = this.getResource().path("metadata").request().accept(new String[]{"application/fhir+json; fhirVersion=4.0"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (CapabilityStatement)response.readEntity(CapabilityStatement.class);
        }
        throw this.handleError(response);
    }

    @Override
    public StructureDefinition generateSnapshot(String url) {
        Objects.requireNonNull(url, "url");
        Parameters parameters = new Parameters();
        parameters.addParameter().setName("url").setValue((Type)new UriType(url));
        Response response = this.getResource().path(StructureDefinition.class.getAnnotation(ResourceDef.class).name()).path("$snapshot").request().accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)parameters, (String)"application/fhir+json"));
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (StructureDefinition)response.readEntity(StructureDefinition.class);
        }
        throw this.handleError(response);
    }

    @Override
    public StructureDefinition generateSnapshot(StructureDefinition differential) {
        Objects.requireNonNull(differential, "differential");
        Parameters parameters = new Parameters();
        parameters.addParameter().setName("resource").setResource((Resource)differential);
        Response response = this.getResource().path(StructureDefinition.class.getAnnotation(ResourceDef.class).name()).path("$snapshot").request().accept(new String[]{"application/fhir+json"}).post(Entity.entity((Object)parameters, (String)"application/fhir+json"));
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (StructureDefinition)response.readEntity(StructureDefinition.class);
        }
        throw this.handleError(response);
    }

    @Override
    public BasicFhirWebserviceClient withRetry(int nTimes, long delayMillis) {
        if (nTimes < 0) {
            throw new IllegalArgumentException("nTimes < 0");
        }
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new BasicFhirWebserviceCientWithRetryImpl(this, nTimes, delayMillis);
    }

    @Override
    public BasicFhirWebserviceClient withRetryForever(long delayMillis) {
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new BasicFhirWebserviceCientWithRetryImpl(this, -1, delayMillis);
    }

    @Override
    public Bundle history(Class<? extends Resource> resourceType, String id, int page, int count) {
        WebTarget target = this.getResource();
        if (resourceType != null) {
            target = target.path(resourceType.getAnnotation(ResourceDef.class).name());
        }
        if (!StringUtils.isBlank((CharSequence)id)) {
            target = target.path(id);
        }
        if (page != Integer.MIN_VALUE) {
            target = target.queryParam("_page", new Object[]{page});
        }
        if (count != Integer.MIN_VALUE) {
            target = target.queryParam("_count", new Object[]{count});
        }
        Response response = target.path("_history").request().accept(new String[]{"application/fhir+json"}).get();
        logger.debug("HTTP {}: {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            return (Bundle)response.readEntity(Bundle.class);
        }
        throw this.handleError(response);
    }
}

