/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import dev.dsf.fhir.client.PreferReturnMinimal;
import dev.dsf.fhir.client.PreferReturnMinimalRetryImpl;
import dev.dsf.fhir.client.PreferReturnMinimalWithRetry;
import dev.dsf.fhir.prefer.PreferReturnType;
import jakarta.ws.rs.core.MediaType;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;

class PreferReturnMinimalWithRetryImpl
implements PreferReturnMinimalWithRetry {
    private final FhirWebserviceClientJersey delegate;

    PreferReturnMinimalWithRetryImpl(FhirWebserviceClientJersey delegate) {
        this.delegate = delegate;
    }

    @Override
    public IdType create(Resource resource) {
        return this.delegate.create(PreferReturnType.MINIMAL, resource).getId();
    }

    @Override
    public IdType createConditionaly(Resource resource, String ifNoneExistCriteria) {
        return this.delegate.createConditionaly(PreferReturnType.MINIMAL, resource, ifNoneExistCriteria).getId();
    }

    @Override
    public IdType createBinary(InputStream in, MediaType mediaType, String securityContextReference) {
        return this.delegate.createBinary(PreferReturnType.MINIMAL, in, mediaType, securityContextReference).getId();
    }

    @Override
    public IdType update(Resource resource) {
        return this.delegate.update(PreferReturnType.MINIMAL, resource).getId();
    }

    @Override
    public IdType updateConditionaly(Resource resource, Map<String, List<String>> criteria) {
        return this.delegate.updateConditionaly(PreferReturnType.MINIMAL, resource, criteria).getId();
    }

    @Override
    public IdType updateBinary(String id, InputStream in, MediaType mediaType, String securityContextReference) {
        return this.delegate.updateBinary(PreferReturnType.MINIMAL, id, in, mediaType, securityContextReference).getId();
    }

    @Override
    public Bundle postBundle(Bundle bundle) {
        return this.delegate.postBundle(PreferReturnType.MINIMAL, bundle);
    }

    @Override
    public PreferReturnMinimal withRetry(int nTimes, long delayMillis) {
        if (nTimes < 0) {
            throw new IllegalArgumentException("nTimes < 0");
        }
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new PreferReturnMinimalRetryImpl(this.delegate, nTimes, delayMillis);
    }

    @Override
    public PreferReturnMinimal withRetryForever(long delayMillis) {
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new PreferReturnMinimalRetryImpl(this.delegate, -1, delayMillis);
    }
}

