/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import dev.dsf.fhir.client.PreferReturnOutcome;
import dev.dsf.fhir.client.PreferReturnOutcomeRetryImpl;
import dev.dsf.fhir.client.PreferReturnOutcomeWithRetry;
import dev.dsf.fhir.prefer.PreferReturnType;
import jakarta.ws.rs.core.MediaType;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;

class PreferReturnOutcomeWithRetryImpl
implements PreferReturnOutcomeWithRetry {
    private final FhirWebserviceClientJersey delegate;

    PreferReturnOutcomeWithRetryImpl(FhirWebserviceClientJersey delegate) {
        this.delegate = delegate;
    }

    @Override
    public OperationOutcome create(Resource resource) {
        return this.delegate.create(PreferReturnType.OPERATION_OUTCOME, resource).getOperationOutcome();
    }

    @Override
    public OperationOutcome createConditionaly(Resource resource, String ifNoneExistCriteria) {
        return this.delegate.createConditionaly(PreferReturnType.OPERATION_OUTCOME, resource, ifNoneExistCriteria).getOperationOutcome();
    }

    @Override
    public OperationOutcome createBinary(InputStream in, MediaType mediaType, String securityContextReference) {
        return this.delegate.createBinary(PreferReturnType.OPERATION_OUTCOME, in, mediaType, securityContextReference).getOperationOutcome();
    }

    @Override
    public OperationOutcome update(Resource resource) {
        return this.delegate.update(PreferReturnType.OPERATION_OUTCOME, resource).getOperationOutcome();
    }

    @Override
    public OperationOutcome updateConditionaly(Resource resource, Map<String, List<String>> criteria) {
        return this.delegate.updateConditionaly(PreferReturnType.OPERATION_OUTCOME, resource, criteria).getOperationOutcome();
    }

    @Override
    public OperationOutcome updateBinary(String id, InputStream in, MediaType mediaType, String securityContextReference) {
        return this.delegate.updateBinary(PreferReturnType.OPERATION_OUTCOME, id, in, mediaType, securityContextReference).getOperationOutcome();
    }

    @Override
    public Bundle postBundle(Bundle bundle) {
        return this.delegate.postBundle(PreferReturnType.OPERATION_OUTCOME, bundle);
    }

    @Override
    public PreferReturnOutcome withRetry(int nTimes, long delayMillis) {
        if (nTimes < 0) {
            throw new IllegalArgumentException("nTimes < 0");
        }
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new PreferReturnOutcomeRetryImpl(this.delegate, nTimes, delayMillis);
    }

    @Override
    public PreferReturnOutcome withRetryForever(long delayMillis) {
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delayMillis < 0");
        }
        return new PreferReturnOutcomeRetryImpl(this.delegate, -1, delayMillis);
    }
}

