/*
 * Decompiled with CFR 0.152.
 */
package elide.runtime.plugins.java.shell;

import elide.runtime.core.DelicateElideApi;
import elide.runtime.plugins.java.shell.GuestExecutionProvider;
import elide.runtime.plugins.jvm.interop.GuestValueMappersKt;
import java.util.Arrays;
import jdk.jshell.spi.ExecutionControl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DelicateElideApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\n\u001a\u00060\u0004j\u0002`\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0013\u001a\u00020\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u000eH\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u000eH\u0016\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\u001c\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\f2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lelide/runtime/plugins/java/shell/GuestExecutionControl;", "Ljdk/jshell/spi/ExecutionControl;", "delegate", "Lelide/runtime/core/PolyglotValue;", "Lorg/graalvm/polyglot/Value;", "provider", "Lelide/runtime/plugins/java/shell/GuestExecutionProvider;", "<init>", "(Lorg/graalvm/polyglot/Value;Lelide/runtime/plugins/java/shell/GuestExecutionProvider;)V", "Lorg/graalvm/polyglot/Value;", "tryInvoke", "method", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lorg/graalvm/polyglot/Value;", "close", "", "load", "cbcs", "Ljdk/jshell/spi/ExecutionControl$ClassBytecodes;", "([Ljdk/jshell/spi/ExecutionControl$ClassBytecodes;)V", "redefine", "invoke", "className", "methodName", "varValue", "varName", "addToClasspath", "path", "stop", "extensionCommand", "command", "arg", "graalvm-java"})
public final class GuestExecutionControl
implements ExecutionControl {
    @NotNull
    private final Value delegate;
    @NotNull
    private final GuestExecutionProvider provider;

    public GuestExecutionControl(@NotNull Value delegate, @NotNull GuestExecutionProvider provider) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.delegate = delegate;
        this.provider = provider;
    }

    private final Value tryInvoke(String method, Object ... args) {
        Value value;
        try {
            value = this.delegate.invokeMember(method, Arrays.copyOf(args, args.length));
        }
        catch (PolyglotException error) {
            throw this.provider.mapException$graalvm_java(error);
        }
        return value;
    }

    @Override
    public void close() {
        this.tryInvoke("close", new Object[0]);
    }

    @Override
    public void load(@NotNull ExecutionControl.ClassBytecodes[] cbcs) {
        Intrinsics.checkNotNullParameter((Object)cbcs, (String)"cbcs");
        Object[] objectArray = new Object[]{this.provider.mapBytecodes$graalvm_java(cbcs)};
        this.tryInvoke("load", objectArray);
    }

    @Override
    public void redefine(@NotNull ExecutionControl.ClassBytecodes[] cbcs) {
        Intrinsics.checkNotNullParameter((Object)cbcs, (String)"cbcs");
        Object[] objectArray = new Object[]{this.provider.mapBytecodes$graalvm_java(cbcs)};
        this.tryInvoke("redefine", objectArray);
    }

    @Override
    @Nullable
    public String invoke(@Nullable String className, @Nullable String methodName) {
        Object[] objectArray = new Object[]{className, methodName};
        return GuestValueMappersKt.asStringOrNull((Value)this.tryInvoke("invoke", objectArray));
    }

    @Override
    @Nullable
    public String varValue(@Nullable String className, @Nullable String varName) {
        Object[] objectArray = new Object[]{className, varName};
        return GuestValueMappersKt.asStringOrNull((Value)this.tryInvoke("varValue", objectArray));
    }

    @Override
    public void addToClasspath(@Nullable String path) {
        Object[] objectArray = new Object[]{path};
        this.tryInvoke("addToClasspath", objectArray);
    }

    @Override
    public void stop() {
        this.tryInvoke("stop", new Object[0]);
    }

    @Override
    @NotNull
    public Object extensionCommand(@Nullable String command, @Nullable Object arg) {
        throw new ExecutionControl.NotImplementedException("Extension commands are not supported: " + command);
    }
}

