/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.io;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;

public class BufferCleaner {
    private Class<?> unmappableBufferClass;
    private MethodHandle unmapper;
    public static BufferCleaner BUFFER_CLEANER;
    public static String UNMAP_NOT_SUPPORTED_REASON;

    private BufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        this.unmappableBufferClass = unmappableBufferClass;
        this.unmapper = unmapper;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UnmapImplResult unmapImpl() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return new UnmapImplResult(BufferCleaner.newBufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe)));
        }
        catch (SecurityException se) {
            try {
                throw se;
                catch (ReflectiveOperationException | RuntimeException e) {
                    Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                    Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                    m.setAccessible(true);
                    MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                    TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                    MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                    MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                    MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                    MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                    return new UnmapImplResult(BufferCleaner.newBufferCleaner(directBufferClass, unmapper));
                }
            }
            catch (SecurityException se2) {
                return new UnmapImplResult("Unmapping is not supported, because not all required permissions are given to the JAR file: " + se2 + " [Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\") and ReflectPermission(\"suppressAccessChecks\")]");
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                return new UnmapImplResult("Unmapping is not supported on this platform, because internal Java APIs are not compatible with this library version: " + e);
            }
        }
    }

    private static BufferCleaner newBufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return new BufferCleaner(unmappableBufferClass, unmapper);
    }

    public void clean(ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("unmapping only works with direct buffers");
        }
        if (!this.unmappableBufferClass.isInstance(buffer)) {
            throw new IllegalArgumentException("buffer is not an instance of " + this.unmappableBufferClass.getName());
        }
        Throwable error = AccessController.doPrivileged(() -> {
            try {
                this.unmapper.invokeExact(buffer);
                return null;
            }
            catch (Throwable t) {
                return t;
            }
        });
        if (error != null) {
            throw new IOException("Unable to unmap the mapped buffer", error);
        }
    }

    static {
        UnmapImplResult unmapImplResult = AccessController.doPrivileged(BufferCleaner::unmapImpl);
        BUFFER_CLEANER = unmapImplResult.bufferCleaner;
        UNMAP_NOT_SUPPORTED_REASON = unmapImplResult.notSupportedReason;
    }

    private static class UnmapImplResult {
        BufferCleaner bufferCleaner;
        String notSupportedReason;

        UnmapImplResult(BufferCleaner bufferCleaner2) {
            this.bufferCleaner = bufferCleaner2;
            this.notSupportedReason = null;
        }

        UnmapImplResult(String notSupportedReason) {
            this.bufferCleaner = null;
            this.notSupportedReason = notSupportedReason;
        }
    }
}

