/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.io;

import dev.evo.io.MutableIOBuffer;
import dev.evo.io.UnsafeBuffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020!H\u0016\u00a8\u0006#"}, d2={"Ldev/evo/io/MutableUnsafeBuffer;", "Ldev/evo/io/UnsafeBuffer;", "Ldev/evo/io/MutableIOBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "fsync", "", "writeByte", "ix", "", "v", "", "writeByteVolatile", "writeBytes", "src", "", "offset", "length", "writeDouble", "", "writeDoubleVolatile", "writeFloat", "", "writeFloatVolatile", "writeInt", "writeIntOrdered", "writeIntVolatile", "writeLong", "", "writeLongOrdered", "writeLongVolatile", "writeShort", "", "writeShortVolatile", "persistent-hashmap"})
public final class MutableUnsafeBuffer
extends UnsafeBuffer
implements MutableIOBuffer {
    public MutableUnsafeBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer);
    }

    @Override
    public void writeBytes(int ix, @NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, src.length);
        UnsafeBuffer.getUNSAFE().copyMemory(src, UnsafeBuffer.getARRAY_BASE_OFFSET(), this.getByteArray(), this.getArrayAddress() + (long)ix, src.length);
    }

    @Override
    public void writeBytes(int ix, @NotNull byte[] src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkNotDropped();
        this.checkLength(length);
        this.checkBounds(this.getBuffer(), ix, length);
        this.checkBounds(src, offset, length);
        UnsafeBuffer.getUNSAFE().copyMemory(src, UnsafeBuffer.getARRAY_BASE_OFFSET() + (long)offset, this.getByteArray(), this.getArrayAddress() + (long)ix, length);
    }

    @Override
    public void writeByte(int ix, byte v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 1);
        UnsafeBuffer.getUNSAFE().putByte(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeShort(int ix, short v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 2);
        UnsafeBuffer.getUNSAFE().putShort(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeInt(int ix, int v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 4);
        UnsafeBuffer.getUNSAFE().putInt(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeLong(int ix, long v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 8);
        UnsafeBuffer.getUNSAFE().putLong(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeFloat(int ix, float v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 4);
        UnsafeBuffer.getUNSAFE().putFloat(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeDouble(int ix, double v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 8);
        UnsafeBuffer.getUNSAFE().putDouble(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeByteVolatile(int ix, byte v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 1);
        UnsafeBuffer.getUNSAFE().putByteVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeShortVolatile(int ix, short v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 2);
        UnsafeBuffer.getUNSAFE().putShortVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeIntVolatile(int ix, int v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 4);
        UnsafeBuffer.getUNSAFE().putIntVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeLongVolatile(int ix, long v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 8);
        UnsafeBuffer.getUNSAFE().putLongVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeFloatVolatile(int ix, float v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 4);
        UnsafeBuffer.getUNSAFE().putFloatVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeDoubleVolatile(int ix, double v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 8);
        UnsafeBuffer.getUNSAFE().putDoubleVolatile(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeIntOrdered(int ix, int v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 4);
        UnsafeBuffer.getUNSAFE().putOrderedInt(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void writeLongOrdered(int ix, long v) {
        this.checkNotDropped();
        this.checkBounds(this.getBuffer(), ix, 8);
        UnsafeBuffer.getUNSAFE().putOrderedLong(this.getByteArray(), this.getArrayAddress() + (long)ix, v);
    }

    @Override
    public void fsync() {
        if (this.getBuffer() instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.getBuffer()).force();
        }
    }
}

