/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.io;

import dev.evo.io.BufferCleaner;
import dev.evo.io.IOBuffer;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0004\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J\b\u0010\u0018\u001a\u00020\u0012H\u0004J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\fH\u0016J(\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u00100\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ldev/evo/io/UnsafeBuffer;", "Ldev/evo/io/IOBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "arrayAddress", "", "getArrayAddress", "()J", "getBuffer", "()Ljava/nio/ByteBuffer;", "byteArray", "", "getByteArray", "()[B", "isDropped", "", "checkBounds", "", "ix", "", "len", "capacity", "checkLength", "checkNotDropped", "drop", "getByteBuffer", "isDirect", "readByte", "", "readByteVolatile", "readBytes", "dst", "offset", "length", "readDouble", "", "readDoubleVolatile", "readFloat", "", "readFloatVolatile", "readInt", "readIntVolatile", "readLong", "readLongVolatile", "readShort", "", "readShortVolatile", "size", "Companion", "persistent-hashmap"})
public class UnsafeBuffer
implements IOBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    @Nullable
    private final byte[] byteArray;
    private final long arrayAddress;
    private boolean isDropped;
    @NotNull
    private static final Unsafe UNSAFE;
    private static final long ARRAY_BASE_OFFSET;
    private static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;
    private static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET;
    private static final long BYTE_BUFFER_HB_FIELD_OFFSET;

    public UnsafeBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        if (this.buffer.isDirect()) {
            this.byteArray = null;
            this.arrayAddress = UnsafeBuffer.Companion.getDirectArrayAddress(this.buffer);
        } else {
            this.byteArray = UnsafeBuffer.Companion.getByteArray(this.buffer);
            this.arrayAddress = ARRAY_BASE_OFFSET + UnsafeBuffer.Companion.getArrayAddress(this.buffer);
        }
    }

    @NotNull
    protected final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Nullable
    protected final byte[] getByteArray() {
        return this.byteArray;
    }

    protected final long getArrayAddress() {
        return this.arrayAddress;
    }

    protected final void checkNotDropped() {
        if (this.isDropped) {
            throw new IllegalStateException("Buffer was dropped");
        }
    }

    protected final void checkLength(int len) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Length " + len + " should not be < 0");
        }
    }

    protected final void checkBounds(@NotNull ByteBuffer buffer, int ix, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.checkBounds(buffer.capacity(), ix, len);
    }

    protected final void checkBounds(@NotNull byte[] buffer, int ix, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.checkBounds(buffer.length, ix, len);
    }

    private final void checkBounds(int capacity, int ix, int len) {
        if (ix < 0 || ix + len > capacity) {
            throw new ArrayIndexOutOfBoundsException("buffer capacity: " + capacity + ", index: " + ix + ", length: " + len);
        }
    }

    @Override
    @Nullable
    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int size() {
        return this.buffer.capacity();
    }

    @Override
    public void drop() {
        if (BufferCleaner.BUFFER_CLEANER == null) {
            return;
        }
        if (!this.buffer.isDirect()) {
            return;
        }
        BufferCleaner.BUFFER_CLEANER.clean(this.buffer);
        this.isDropped = true;
    }

    @Override
    public void readBytes(int ix, @NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.checkBounds(this.buffer, ix, dst.length);
        UNSAFE.copyMemory(this.byteArray, this.arrayAddress + (long)ix, dst, ARRAY_BASE_OFFSET, dst.length);
    }

    @Override
    public void readBytes(int ix, @NotNull byte[] dst, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.checkNotDropped();
        this.checkLength(length);
        this.checkBounds(this.buffer, ix, length);
        this.checkBounds(dst, offset, length);
        UNSAFE.copyMemory(this.byteArray, this.arrayAddress + (long)ix, dst, ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public byte readByte(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 1);
        return UNSAFE.getByte(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public short readShort(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 2);
        return UNSAFE.getShort(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public int readInt(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 4);
        return UNSAFE.getInt(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public long readLong(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 8);
        return UNSAFE.getLong(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public float readFloat(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 4);
        return UNSAFE.getFloat(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public double readDouble(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 8);
        return UNSAFE.getDouble(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public byte readByteVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 1);
        return UNSAFE.getByteVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public short readShortVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 2);
        return UNSAFE.getShortVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public int readIntVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 4);
        return UNSAFE.getIntVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public long readLongVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 8);
        return UNSAFE.getLongVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public float readFloatVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 4);
        return UNSAFE.getFloatVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    @Override
    public double readDoubleVolatile(int ix) {
        this.checkNotDropped();
        this.checkBounds(this.buffer, ix, 8);
        return UNSAFE.getDoubleVolatile(this.byteArray, this.arrayAddress + (long)ix);
    }

    private static final Unsafe UNSAFE$lambda$0() {
        Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        Object object = theUnsafeField.get(null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
        return (Unsafe)object;
    }

    private static final Long BYTE_BUFFER_ADDRESS_FIELD_OFFSET$lambda$1() {
        return UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
    }

    private static final Long BYTE_BUFFER_OFFSET_FIELD_OFFSET$lambda$2() {
        return UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
    }

    private static final Long BYTE_BUFFER_HB_FIELD_OFFSET$lambda$3() {
        return UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
    }

    @NotNull
    protected static final Unsafe getUNSAFE() {
        return Companion.getUNSAFE();
    }

    protected static final long getARRAY_BASE_OFFSET() {
        return Companion.getARRAY_BASE_OFFSET();
    }

    static {
        Unsafe unsafe = AccessController.doPrivileged(UnsafeBuffer::UNSAFE$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)unsafe, (String)"doPrivileged(PrivilegedE\u2026ull) as Unsafe\n        })");
        UNSAFE = unsafe;
        ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        Long l = AccessController.doPrivileged(UnsafeBuffer::BYTE_BUFFER_ADDRESS_FIELD_OFFSET$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"doPrivileged(PrivilegedE\u2026\n            )\n        })");
        BYTE_BUFFER_ADDRESS_FIELD_OFFSET = ((Number)l).longValue();
        Long l2 = AccessController.doPrivileged(UnsafeBuffer::BYTE_BUFFER_OFFSET_FIELD_OFFSET$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"doPrivileged(PrivilegedE\u2026\n            )\n        })");
        BYTE_BUFFER_OFFSET_FIELD_OFFSET = ((Number)l2).longValue();
        Long l3 = AccessController.doPrivileged(UnsafeBuffer::BYTE_BUFFER_HB_FIELD_OFFSET$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"doPrivileged(PrivilegedE\u2026\n            )\n        })");
        BYTE_BUFFER_HB_FIELD_OFFSET = ((Number)l3).longValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Ldev/evo/io/UnsafeBuffer$Companion;", "", "()V", "ARRAY_BASE_OFFSET", "", "getARRAY_BASE_OFFSET$annotations", "getARRAY_BASE_OFFSET", "()J", "BYTE_BUFFER_ADDRESS_FIELD_OFFSET", "BYTE_BUFFER_HB_FIELD_OFFSET", "BYTE_BUFFER_OFFSET_FIELD_OFFSET", "UNSAFE", "Lsun/misc/Unsafe;", "getUNSAFE$annotations", "getUNSAFE", "()Lsun/misc/Unsafe;", "getArrayAddress", "buffer", "Ljava/nio/ByteBuffer;", "getByteArray", "", "getDirectArrayAddress", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Unsafe getUNSAFE() {
            return UNSAFE;
        }

        @JvmStatic
        protected static /* synthetic */ void getUNSAFE$annotations() {
        }

        protected final long getARRAY_BASE_OFFSET() {
            return ARRAY_BASE_OFFSET;
        }

        @JvmStatic
        protected static /* synthetic */ void getARRAY_BASE_OFFSET$annotations() {
        }

        private final long getDirectArrayAddress(ByteBuffer buffer) {
            return UnsafeBuffer.getUNSAFE().getLong(buffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
        }

        private final long getArrayAddress(ByteBuffer buffer) {
            return UnsafeBuffer.getUNSAFE().getInt(buffer, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
        }

        private final byte[] getByteArray(ByteBuffer buffer) {
            Object object = UnsafeBuffer.getUNSAFE().getObject(buffer, BYTE_BUFFER_HB_FIELD_OFFSET);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            return (byte[])object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

