/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent;

import dev.evo.io.BufferCleaner;
import dev.evo.io.IOBuffer;
import dev.evo.io.MutableIOBuffer;
import dev.evo.io.MutableUnsafeBuffer;
import dev.evo.persistent.AbstractVersionedDirectory;
import dev.evo.persistent.CorruptedVersionFileException;
import dev.evo.persistent.FileAlreadyExistsException;
import dev.evo.persistent.FileDoesNotExistException;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.ReadOnlyException;
import dev.evo.persistent.VersionedMmapDirectory;
import dev.evo.persistent.WriteLockException;
import dev.evo.rc.AtomicRefCounted;
import dev.evo.rc.RefCounted;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0003'()B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u000fH\u0016J,\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u000fH\u0002J\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0016R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory;", "Ldev/evo/persistent/AbstractVersionedDirectory;", "path", "Ljava/nio/file/Path;", "versionFile", "Ldev/evo/persistent/MappedFile;", "Ldev/evo/io/MutableIOBuffer;", "writeLock", "Ldev/evo/persistent/VersionedMmapDirectory$VersionLock;", "created", "", "(Ljava/nio/file/Path;Ldev/evo/persistent/MappedFile;Ldev/evo/persistent/VersionedMmapDirectory$VersionLock;Z)V", "bufferCleaner", "Lkotlin/Function1;", "Ldev/evo/io/IOBuffer;", "", "getCreated", "()Z", "getPath", "()Ljava/nio/file/Path;", "useUnmapHack", "getUseUnmapHack", "setUseUnmapHack", "(Z)V", "close", "createFile", "Ldev/evo/rc/RefCounted;", "name", "", "size", "", "deleteOnExit", "deleteFile", "ensureWriteLock", "openFileReadOnly", "openFileWritable", "rename", "source", "dest", "Companion", "Mode", "VersionLock", "persistent-hashmap"})
public final class VersionedMmapDirectory
extends AbstractVersionedDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final MappedFile<MutableIOBuffer> versionFile;
    @Nullable
    private final VersionLock writeLock;
    private final boolean created;
    @NotNull
    private Function1<? super MappedFile<? extends IOBuffer>, Unit> bufferCleaner;
    private boolean useUnmapHack;

    private VersionedMmapDirectory(Path path, MappedFile<? extends MutableIOBuffer> versionFile, VersionLock writeLock, boolean created) {
        super(versionFile);
        this.path = path;
        this.versionFile = versionFile;
        this.writeLock = writeLock;
        this.created = created;
        this.bufferCleaner = bufferCleaner.1.INSTANCE;
    }

    /* synthetic */ VersionedMmapDirectory(Path path, MappedFile mappedFile, VersionLock versionLock, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            versionLock = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(path, mappedFile, versionLock, bl);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final boolean getCreated() {
        return this.created;
    }

    public final boolean getUseUnmapHack() {
        return this.useUnmapHack;
    }

    public final void setUseUnmapHack(boolean useUnmapHack2) {
        if (useUnmapHack2 && BufferCleaner.BUFFER_CLEANER == null) {
            throw new IllegalArgumentException(BufferCleaner.UNMAP_NOT_SUPPORTED_REASON);
        }
        this.useUnmapHack = useUnmapHack2;
        this.bufferCleaner = useUnmapHack.1.INSTANCE;
    }

    @Override
    public void close() {
        block0: {
            super.close();
            this.bufferCleaner.invoke(this.versionFile);
            VersionLock versionLock = this.writeLock;
            if (versionLock == null) break block0;
            versionLock.close();
        }
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<MutableIOBuffer>> createFile(@NotNull String name, int size, boolean deleteOnExit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureWriteLock();
        Path filepath = this.path.resolve(name);
        if (filepath.toFile().exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)filepath, (String)"filepath");
            throw new FileAlreadyExistsException(filepath);
        }
        File file2 = filepath.toFile();
        if (deleteOnExit) {
            file2.deleteOnExit();
        }
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        return new AtomicRefCounted<MappedFile<? extends IOBuffer>>(VersionedMmapDirectory.Companion.mmapFile(file2, new Mode.Create(size)), this.bufferCleaner);
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<MutableIOBuffer>> openFileWritable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureWriteLock();
        Path filepath = this.path.resolve(name);
        if (!filepath.toFile().exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)filepath, (String)"filepath");
            throw new FileDoesNotExistException(filepath);
        }
        File file2 = filepath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"filepath.toFile()");
        return new AtomicRefCounted<MappedFile<? extends IOBuffer>>(VersionedMmapDirectory.Companion.mmapFile(file2, new Mode.OpenRW()), this.bufferCleaner);
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<IOBuffer>> openFileReadOnly(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path filepath = this.path.resolve(name);
        if (!filepath.toFile().exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)filepath, (String)"filepath");
            throw new FileDoesNotExistException(filepath);
        }
        File file2 = filepath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"filepath.toFile()");
        return new AtomicRefCounted<MappedFile<? extends IOBuffer>>(VersionedMmapDirectory.Companion.mmapFile(file2, new Mode.OpenRO()), this.bufferCleaner);
    }

    @Override
    public void deleteFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path filepath = this.path.resolve(name);
        if (!filepath.toFile().exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)filepath, (String)"filepath");
            throw new FileDoesNotExistException(filepath);
        }
        filepath.toFile().delete();
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
        Files.move(this.path.resolve(source), this.path.resolve(dest), copyOptionArray);
    }

    private final void ensureWriteLock() {
        if (this.writeLock == null) {
            throw new ReadOnlyException("Write operation is not allowed for the directory opened in a readonly mode");
        }
    }

    public /* synthetic */ VersionedMmapDirectory(Path path, MappedFile versionFile, VersionLock writeLock, boolean created, DefaultConstructorMarker $constructor_marker) {
        this(path, versionFile, writeLock, created);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$VersionLock;", "Ljava/lang/AutoCloseable;", "versionPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "file", "Ljava/io/RandomAccessFile;", "lock", "Ljava/nio/channels/FileLock;", "close", "", "persistent-hashmap"})
    private static final class VersionLock
    implements AutoCloseable {
        @NotNull
        private final RandomAccessFile file;
        @NotNull
        private final FileLock lock;

        /*
         * WARNING - void declaration
         */
        public VersionLock(@NotNull Path versionPath) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)versionPath, (String)"versionPath");
            this.file = new RandomAccessFile(((Object)versionPath).toString(), "rw");
            VersionLock versionLock = this;
            VersionLock versionLock2 = this;
            boolean bl = false;
            try {
                void $this$lock_u24lambda_u240;
                pair = TuplesKt.to((Object)$this$lock_u24lambda_u240.file.getChannel().tryLock(), null);
            }
            catch (OverlappingFileLockException e) {
                pair = TuplesKt.to(null, (Object)e);
            }
            Pair pair2 = pair;
            FileLock lock = (FileLock)pair2.component1();
            OverlappingFileLockException ex = (OverlappingFileLockException)pair2.component2();
            if (lock == null || ex != null) {
                throw new WriteLockException("Cannot retain a write lock of the file: " + versionPath, ex);
            }
            versionLock2.lock = lock;
        }

        @Override
        public void close() {
            this.lock.close();
            this.file.close();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$Companion;", "", "()V", "getVersionFile", "Ldev/evo/persistent/MappedFile;", "Ldev/evo/io/MutableIOBuffer;", "versionPath", "Ljava/nio/file/Path;", "mode", "Ldev/evo/persistent/VersionedMmapDirectory$Mode;", "getVersionPath", "path", "versionFilename", "", "mmapFile", "file", "Ljava/io/File;", "openReadOnly", "Ldev/evo/persistent/VersionedMmapDirectory;", "openWritable", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getVersionPath(Path path, String versionFilename) {
            Path path2 = path.resolve(versionFilename);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(versionFilename)");
            return path2;
        }

        private final MappedFile<MutableIOBuffer> getVersionFile(Path versionPath, Mode mode) {
            File file2 = versionPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"versionPath.toFile()");
            MappedFile<MutableIOBuffer> file3 = this.mmapFile(file2, mode);
            if (file3.getBuffer().size() != 8) {
                throw new CorruptedVersionFileException("Version file must have size 8");
            }
            return file3;
        }

        @NotNull
        public final VersionedMmapDirectory openWritable(@NotNull Path path, @NotNull String versionFilename) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)versionFilename, (String)"versionFilename");
            Path versionPath = this.getVersionPath(path, versionFilename);
            Pair pair = !versionPath.toFile().exists() ? TuplesKt.to(this.getVersionFile(versionPath, new Mode.Create(8)), (Object)true) : TuplesKt.to(this.getVersionFile(versionPath, new Mode.OpenRW()), (Object)false);
            MappedFile versionFile = (MappedFile)pair.component1();
            boolean created = (Boolean)pair.component2();
            VersionLock versionLock = new VersionLock(versionPath);
            return new VersionedMmapDirectory(path, versionFile, versionLock, created, null);
        }

        @NotNull
        public final VersionedMmapDirectory openReadOnly(@NotNull Path path, @NotNull String versionFilename) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)versionFilename, (String)"versionFilename");
            Path versionPath = this.getVersionPath(path, versionFilename);
            if (!versionPath.toFile().exists()) {
                throw new FileDoesNotExistException(versionPath);
            }
            MappedFile<MutableIOBuffer> versionFile = this.getVersionFile(versionPath, new Mode.OpenRO());
            return new VersionedMmapDirectory(path, versionFile, null, false, 12, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final MappedFile<MutableIOBuffer> mmapFile(File file2, Mode mode) {
            MappedFile<IOBuffer> mappedFile;
            Closeable closeable = new RandomAccessFile(file2, mode.getMode());
            Throwable throwable = null;
            try {
                ByteBuffer byteBuffer;
                RandomAccessFile f = (RandomAccessFile)closeable;
                boolean bl = false;
                if (mode instanceof Mode.Create) {
                    f.setLength(((Mode.Create)mode).getSize());
                }
                Closeable closeable2 = f.getChannel();
                Throwable throwable2 = null;
                try {
                    FileChannel channel = (FileChannel)closeable2;
                    boolean bl2 = false;
                    byteBuffer = channel.map(mode.getMapMode(), 0L, channel.size()).order(ByteOrder.nativeOrder());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ByteBuffer mappedBuffer = byteBuffer;
                String string = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                Intrinsics.checkNotNullExpressionValue((Object)mappedBuffer, (String)"mappedBuffer");
                mappedFile = new MappedFile<IOBuffer>(string, new MutableUnsafeBuffer(mappedBuffer));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return mappedFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$Mode;", "", "mode", "", "mapMode", "Ljava/nio/channels/FileChannel$MapMode;", "(Ljava/lang/String;Ljava/nio/channels/FileChannel$MapMode;)V", "getMapMode", "()Ljava/nio/channels/FileChannel$MapMode;", "getMode", "()Ljava/lang/String;", "Create", "OpenRO", "OpenRW", "Ldev/evo/persistent/VersionedMmapDirectory$Mode$Create;", "Ldev/evo/persistent/VersionedMmapDirectory$Mode$OpenRO;", "Ldev/evo/persistent/VersionedMmapDirectory$Mode$OpenRW;", "persistent-hashmap"})
    private static abstract class Mode {
        @NotNull
        private final String mode;
        @NotNull
        private final FileChannel.MapMode mapMode;

        private Mode(String mode, FileChannel.MapMode mapMode) {
            this.mode = mode;
            this.mapMode = mapMode;
        }

        @NotNull
        public final String getMode() {
            return this.mode;
        }

        @NotNull
        public final FileChannel.MapMode getMapMode() {
            return this.mapMode;
        }

        public /* synthetic */ Mode(String mode, FileChannel.MapMode mapMode, DefaultConstructorMarker $constructor_marker) {
            this(mode, mapMode);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$Mode$Create;", "Ldev/evo/persistent/VersionedMmapDirectory$Mode;", "size", "", "(I)V", "getSize", "()I", "persistent-hashmap"})
        public static final class Create
        extends Mode {
            private final int size;

            public Create(int size) {
                FileChannel.MapMode mapMode = FileChannel.MapMode.READ_WRITE;
                Intrinsics.checkNotNullExpressionValue((Object)mapMode, (String)"READ_WRITE");
                super("rw", mapMode, null);
                this.size = size;
            }

            public final int getSize() {
                return this.size;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$Mode$OpenRO;", "Ldev/evo/persistent/VersionedMmapDirectory$Mode;", "()V", "persistent-hashmap"})
        public static final class OpenRO
        extends Mode {
            public OpenRO() {
                FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
                Intrinsics.checkNotNullExpressionValue((Object)mapMode, (String)"READ_ONLY");
                super("r", mapMode, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ldev/evo/persistent/VersionedMmapDirectory$Mode$OpenRW;", "Ldev/evo/persistent/VersionedMmapDirectory$Mode;", "()V", "persistent-hashmap"})
        public static final class OpenRW
        extends Mode {
            public OpenRW() {
                FileChannel.MapMode mapMode = FileChannel.MapMode.READ_WRITE;
                Intrinsics.checkNotNullExpressionValue((Object)mapMode, (String)"READ_WRITE");
                super("rw", mapMode, null);
            }
        }
    }
}

