/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent;

import dev.evo.io.BufferCleaner;
import dev.evo.io.IOBuffer;
import dev.evo.io.MutableIOBuffer;
import dev.evo.io.MutableUnsafeBuffer;
import dev.evo.persistent.AbstractVersionedDirectory;
import dev.evo.persistent.FileAlreadyExistsException;
import dev.evo.persistent.FileDoesNotExistException;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.VersionedRamDirectory;
import dev.evo.rc.AtomicRefCounted;
import dev.evo.rc.RefCounted;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u000bH\u0016J,\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Ldev/evo/persistent/VersionedRamDirectory;", "Ldev/evo/persistent/AbstractVersionedDirectory;", "bufferAllocator", "Lkotlin/Function1;", "", "Ljava/nio/ByteBuffer;", "isDirect", "", "(Lkotlin/jvm/functions/Function1;Z)V", "bufferCleaner", "Ldev/evo/io/MutableIOBuffer;", "", "buffers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ldev/evo/rc/RefCounted;", "Ldev/evo/persistent/MappedFile;", "useUnmapHack", "getUseUnmapHack", "()Z", "setUseUnmapHack", "(Z)V", "close", "createFile", "name", "size", "deleteOnExit", "deleteFile", "openFileReadOnly", "Ldev/evo/io/IOBuffer;", "openFileWritable", "rename", "source", "dest", "Companion", "persistent-hashmap"})
public final class VersionedRamDirectory
extends AbstractVersionedDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Integer, ByteBuffer> bufferAllocator;
    private final boolean isDirect;
    @NotNull
    private final ConcurrentHashMap<String, RefCounted<MappedFile<MutableIOBuffer>>> buffers;
    @NotNull
    private Function1<? super MutableIOBuffer, Unit> bufferCleaner;
    private boolean useUnmapHack;

    private VersionedRamDirectory(Function1<? super Integer, ? extends ByteBuffer> bufferAllocator, boolean isDirect) {
        super(new MappedFile<IOBuffer>("<version>", new MutableUnsafeBuffer((ByteBuffer)bufferAllocator.invoke((Object)8))));
        this.bufferAllocator = bufferAllocator;
        this.isDirect = isDirect;
        this.buffers = new ConcurrentHashMap();
        this.bufferCleaner = bufferCleaner.1.INSTANCE;
    }

    public final boolean getUseUnmapHack() {
        return this.useUnmapHack;
    }

    public final void setUseUnmapHack(boolean useUnmapHack2) {
        if (!this.isDirect) {
            throw new IllegalArgumentException("Only direct buffers support unmappping");
        }
        if (useUnmapHack2 && BufferCleaner.BUFFER_CLEANER == null) {
            throw new IllegalArgumentException(BufferCleaner.UNMAP_NOT_SUPPORTED_REASON);
        }
        this.useUnmapHack = useUnmapHack2;
        this.bufferCleaner = useUnmapHack.1.INSTANCE;
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<MutableIOBuffer>> createFile(@NotNull String name, int size, boolean deleteOnExit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.buffers.containsKey(name)) {
            Path path = Paths.get(name, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(name)");
            throw new FileAlreadyExistsException(path);
        }
        MutableUnsafeBuffer buffer = new MutableUnsafeBuffer((ByteBuffer)this.bufferAllocator.invoke((Object)size));
        AtomicRefCounted<MappedFile<IOBuffer>> file2 = new AtomicRefCounted<MappedFile<IOBuffer>>(new MappedFile<IOBuffer>(name, buffer), createFile.file.1.INSTANCE);
        ((Map)this.buffers).put(name, file2);
        return file2;
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<MutableIOBuffer>> openFileWritable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RefCounted refCounted = this.buffers.computeIfPresent(name, (arg_0, arg_1) -> VersionedRamDirectory.openFileWritable$lambda$0(openFileWritable.1.INSTANCE, arg_0, arg_1));
        if (refCounted == null) {
            Path path = Paths.get(name, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(name)");
            throw new FileDoesNotExistException(path);
        }
        return refCounted;
    }

    @Override
    @NotNull
    public RefCounted<MappedFile<IOBuffer>> openFileReadOnly(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.openFileWritable(name);
    }

    @Override
    public void deleteFile(@NotNull String name) {
        RefCounted<MappedFile<MutableIOBuffer>> refCounted;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RefCounted<MappedFile<MutableIOBuffer>> refCounted2 = this.buffers.remove(name);
        if (refCounted2 == null) {
            Path path = Paths.get(name, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(name)");
            throw new FileDoesNotExistException(path);
        }
        RefCounted<MappedFile<MutableIOBuffer>> it = refCounted = refCounted2;
        boolean bl = false;
        it.release();
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (this.buffers.containsKey(dest)) {
            Path path = Paths.get(dest, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(dest)");
            throw new FileAlreadyExistsException(path);
        }
        Map map = this.buffers;
        RefCounted<MappedFile<MutableIOBuffer>> refCounted = this.buffers.remove(source);
        if (refCounted == null) {
            Path path = Paths.get(source, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(source)");
            throw new FileDoesNotExistException(path);
        }
        RefCounted<MappedFile<MutableIOBuffer>> refCounted2 = refCounted;
        map.put(dest, refCounted2);
    }

    @Override
    public void close() {
        super.close();
        Map $this$forEach$iv = this.buffers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            RefCounted file2 = (RefCounted)entry.getValue();
            file2.release();
        }
        this.buffers.clear();
    }

    private static final RefCounted openFileWritable$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RefCounted)$tmp0.invoke(p0, p1);
    }

    public /* synthetic */ VersionedRamDirectory(Function1 bufferAllocator, boolean isDirect, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super Integer, ? extends ByteBuffer>)bufferAllocator, isDirect);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Ldev/evo/persistent/VersionedRamDirectory$Companion;", "", "()V", "createDirect", "Ldev/evo/persistent/VersionedRamDirectory;", "createHeap", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionedRamDirectory createHeap() {
            return new VersionedRamDirectory(createHeap.1.INSTANCE, false, null);
        }

        @NotNull
        public final VersionedRamDirectory createDirect() {
            return new VersionedRamDirectory(createDirect.1.INSTANCE, true, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

