/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Ldev/evo/persistent/hashmap/BucketLayout;", "", "metaSize", "", "keySize", "valueSize", "(III)V", "keyOffset", "getKeyOffset", "()I", "getKeySize", "metaOffset", "getMetaOffset", "getMetaSize", "size", "getSize", "valueOffset", "getValueOffset", "getValueSize", "toString", "", "persistent-hashmap"})
public final class BucketLayout {
    private final int metaSize;
    private final int keySize;
    private final int valueSize;
    private final int metaOffset;
    private final int keyOffset;
    private final int valueOffset;
    private final int size;

    public BucketLayout(int metaSize, int keySize, int valueSize) {
        this.metaSize = metaSize;
        this.keySize = keySize;
        this.valueSize = valueSize;
        int bucketSize = 0;
        if (this.keySize <= this.valueSize) {
            this.keyOffset = this.metaSize + Math.max(0, this.keySize - this.metaSize);
            int baseValueOffset = this.keyOffset + this.keySize;
            this.valueOffset = baseValueOffset + Math.max(0, this.valueSize - baseValueOffset);
            bucketSize = this.valueOffset + this.valueSize;
        } else {
            this.valueOffset = this.metaSize + Math.max(0, this.valueSize - this.metaSize);
            int baseKeyOffset = this.valueOffset + this.valueSize;
            this.keyOffset = baseKeyOffset + Math.max(0, this.keySize - baseKeyOffset);
            bucketSize = this.keyOffset + this.keySize;
        }
        int align = Math.max(this.metaSize, Math.max(this.keySize, this.valueSize));
        this.size = ((bucketSize - 1) / align + 1) * align;
    }

    public final int getMetaSize() {
        return this.metaSize;
    }

    public final int getKeySize() {
        return this.keySize;
    }

    public final int getValueSize() {
        return this.valueSize;
    }

    public final int getMetaOffset() {
        return this.metaOffset;
    }

    public final int getKeyOffset() {
        return this.keyOffset;
    }

    public final int getValueOffset() {
        return this.valueOffset;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public String toString() {
        return "BucketLayout<metaOffset = " + this.metaOffset + ", metaSize = " + this.metaSize + ", keyOffset = " + this.keyOffset + ", keySize = " + this.keySize + ", valueOffset = " + this.valueOffset + ", valueSize = " + this.valueSize + ", size = " + this.size + ">";
    }
}

