/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap;

import dev.evo.persistent.hashmap.Dummy32;
import dev.evo.persistent.hashmap.Hash32;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.HasherProvider;
import dev.evo.persistent.hashmap.Hasher_Int;
import dev.evo.persistent.hashmap.Knuth32;
import dev.evo.persistent.hashmap.Lowbias32;
import dev.evo.persistent.hashmap.Murmurhash32Mix;
import dev.evo.persistent.hashmap.Prospector32;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ldev/evo/persistent/hashmap/HasherProvider_Int;", "Ldev/evo/persistent/hashmap/HasherProvider;", "Ldev/evo/persistent/hashmap/Hasher_Int;", "()V", "defaultHasherSerial", "", "getDefaultHasherSerial", "()J", "getHasher", "Ldev/evo/persistent/hashmap/Hasher;", "serial", "persistent-hashmap"})
public final class HasherProvider_Int
implements HasherProvider<Hasher_Int> {
    @NotNull
    public static final HasherProvider_Int INSTANCE = new HasherProvider_Int();
    private static final long defaultHasherSerial = Hash32.INSTANCE.getSerial();

    private HasherProvider_Int() {
    }

    @Override
    public long getDefaultHasherSerial() {
        return defaultHasherSerial;
    }

    @Override
    @NotNull
    public Hasher getHasher(long serial) {
        Hasher hasher;
        long l = serial;
        if (l == Hash32.INSTANCE.getSerial()) {
            hasher = Hash32.INSTANCE;
        } else if (l == Prospector32.INSTANCE.getSerial()) {
            hasher = Prospector32.INSTANCE;
        } else if (l == Murmurhash32Mix.INSTANCE.getSerial()) {
            hasher = Murmurhash32Mix.INSTANCE;
        } else if (l == Lowbias32.INSTANCE.getSerial()) {
            hasher = Lowbias32.INSTANCE;
        } else if (l == Knuth32.INSTANCE.getSerial()) {
            hasher = Knuth32.INSTANCE;
        } else if (l == Dummy32.INSTANCE.getSerial()) {
            hasher = Dummy32.INSTANCE;
        } else {
            throw new IllegalArgumentException("Unknown serial for int: " + serial);
        }
        return hasher;
    }
}

