/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.IOBuffer;
import dev.evo.io.MutableIOBuffer;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.HasherProvider;
import dev.evo.persistent.hashmap.Serializer;
import dev.evo.persistent.hashmap.straight.InvalidHashtableException;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u0001)B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020 J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001fJ\u001e\u0010%\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\"J\b\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006*"}, d2={"Ldev/evo/persistent/hashmap/straight/Header;", "H", "Ldev/evo/persistent/hashmap/Hasher;", "", "capacity", "", "maxEntries", "maxDistance", "keySerializer", "Ldev/evo/persistent/hashmap/Serializer;", "valueSerializer", "hasher", "(IIILdev/evo/persistent/hashmap/Serializer;Ldev/evo/persistent/hashmap/Serializer;Ldev/evo/persistent/hashmap/Hasher;)V", "getCapacity", "()I", "getHasher", "()Ldev/evo/persistent/hashmap/Hasher;", "Ldev/evo/persistent/hashmap/Hasher;", "getKeySerializer", "()Ldev/evo/persistent/hashmap/Serializer;", "getMaxDistance", "getMaxEntries", "getValueSerializer", "bookmarkOffset", "bookmarkIx", "checkNumBookmarks", "", "dump", "buffer", "Ldev/evo/io/MutableIOBuffer;", "loadAllBookmarks", "", "Ldev/evo/io/IOBuffer;", "loadBookmark", "", "storeAllBookmarks", "bookmarks", "storeBookmark", "value", "toString", "", "Companion", "persistent-hashmap"})
public final class Header<H extends Hasher> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    private final int maxEntries;
    private final int maxDistance;
    @NotNull
    private final Serializer keySerializer;
    @NotNull
    private final Serializer valueSerializer;
    @NotNull
    private final H hasher;
    @NotNull
    private static final byte[] MAGIC;
    public static final int FLAGS_OFFSET = 8;
    public static final int CAPACITY_OFFSET = 16;
    public static final int MAX_ENTRIES_OFFSET = 24;
    public static final int SIZE_OFFSET = 32;
    public static final int TOMBSTONES_OFFSET = 40;
    public static final int MAX_DISTANCE_OFFSET = 48;
    private static final int TYPE_BITS = 3;
    private static final long TYPE_MASK = 7L;
    private static final int KEY_TYPE_SHIFT = 0;
    private static final int VALUE_TYPE_SHIFT = 3;
    private static final int HASHER_SERIAL_BITS = 8;
    private static final int HASHER_SERIAL_SHIFT = 8;
    private static final long HASHER_SERIAL_MASK = 255L;
    public static final int NUM_BOOKMARKS = 32;

    public Header(int capacity, int maxEntries, int maxDistance, @NotNull Serializer keySerializer, @NotNull Serializer valueSerializer, @NotNull H hasher) {
        Intrinsics.checkNotNullParameter((Object)keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter((Object)valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter(hasher, (String)"hasher");
        this.capacity = capacity;
        this.maxEntries = maxEntries;
        this.maxDistance = maxDistance;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.hasher = hasher;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public final int getMaxDistance() {
        return this.maxDistance;
    }

    @NotNull
    public final Serializer getKeySerializer() {
        return this.keySerializer;
    }

    @NotNull
    public final Serializer getValueSerializer() {
        return this.valueSerializer;
    }

    @NotNull
    public final H getHasher() {
        return this.hasher;
    }

    public final void dump(@NotNull MutableIOBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeBytes(0, MAGIC);
        buffer.writeLong(8, Header.Companion.calcFlags(this.keySerializer, this.valueSerializer, this.hasher));
        buffer.writeLong(16, this.capacity);
        buffer.writeLong(24, this.maxEntries);
        buffer.writeLong(32, 0L);
        buffer.writeLong(40, 0L);
        buffer.writeLong(48, 0L);
    }

    public final long loadBookmark(@NotNull IOBuffer buffer, int bookmarkIx) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.checkNumBookmarks(bookmarkIx);
        return buffer.readLongVolatile(this.bookmarkOffset(bookmarkIx));
    }

    public final void storeBookmark(@NotNull MutableIOBuffer buffer, int bookmarkIx, long value) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.checkNumBookmarks(bookmarkIx);
        buffer.writeLongVolatile(this.bookmarkOffset(bookmarkIx), value);
    }

    @NotNull
    public final long[] loadAllBookmarks(@NotNull IOBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long[] bookmarks = new long[32];
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)32);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int ix = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            bookmarks[ix] = buffer.readLongVolatile(this.bookmarkOffset(ix));
        }
        return bookmarks;
    }

    public final void storeAllBookmarks(@NotNull MutableIOBuffer buffer, @NotNull long[] bookmarks) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)bookmarks, (String)"bookmarks");
        this.checkNumBookmarks(bookmarks.length - 1);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)32);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int ix = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            buffer.writeLongVolatile(this.bookmarkOffset(ix), bookmarks[ix]);
        }
    }

    private final void checkNumBookmarks(int bookmarkIx) {
        if (!(0 <= bookmarkIx ? bookmarkIx < 32 : false)) {
            boolean bl = false;
            String string = "Only 32 bookmarks are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final int bookmarkOffset(int bookmarkIx) {
        return 4096 - (bookmarkIx + 1) * 8;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + "<capacity = " + this.capacity + ", maxEntries = " + this.maxEntries + ">";
    }

    static {
        String string = "SPHT\r\n\r\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        MAGIC = byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJK\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0001\u0010$\"\u0004\b\u0002\u0010%\"\n\b\u0003\u0010#\u0018\u0001*\u00020\u001c2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H$0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H%0)H\u0086\bJ\u0016\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ldev/evo/persistent/hashmap/straight/Header$Companion;", "", "()V", "CAPACITY_OFFSET", "", "FLAGS_OFFSET", "HASHER_SERIAL_BITS", "HASHER_SERIAL_MASK", "", "HASHER_SERIAL_SHIFT", "KEY_TYPE_SHIFT", "MAGIC", "", "getMAGIC", "()[B", "MAX_DISTANCE_OFFSET", "MAX_ENTRIES_OFFSET", "NUM_BOOKMARKS", "SIZE_OFFSET", "TOMBSTONES_OFFSET", "TYPE_BITS", "TYPE_MASK", "VALUE_TYPE_SHIFT", "calcFlags", "keySerializer", "Ldev/evo/persistent/hashmap/Serializer;", "valueSerializer", "hasher", "Ldev/evo/persistent/hashmap/Hasher;", "getHasherSerial", "flags", "getKeySerial", "getValueSerial", "load", "Ldev/evo/persistent/hashmap/straight/Header;", "H", "K", "V", "buffer", "Ldev/evo/io/IOBuffer;", "keyClazz", "Ljava/lang/Class;", "valueClazz", "toPositiveIntOrFail", "v", "property", "", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getMAGIC() {
            return MAGIC;
        }

        public final /* synthetic */ <K, V, H extends Hasher> Header<H> load(IOBuffer buffer, Class<K> keyClazz, Class<V> valueClazz) {
            boolean $i$a$-assert-Header$Companion$load$keySerializer$1$222;
            boolean bl;
            Serializer serializer;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter(keyClazz, (String)"keyClazz");
            Intrinsics.checkNotNullParameter(valueClazz, (String)"valueClazz");
            boolean $i$f$load = false;
            byte[] magic = new byte[this.getMAGIC().length];
            buffer.readBytes(0, magic);
            if (!Arrays.equals(magic, this.getMAGIC())) {
                String string = Arrays.toString(this.getMAGIC());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                String string2 = Arrays.toString(magic);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
                throw new InvalidHashtableException("Expected " + string + " magic number but was: " + string2);
            }
            long flags = buffer.readLong(8);
            Serializer it = serializer = Serializer.Companion.getForClass(keyClazz);
            boolean bl2 = false;
            long serial = Companion.getKeySerial(flags);
            boolean bl3 = bl = serial == it.getSerial();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-Header$Companion$load$keySerializer$1$222 = false;
                String $i$a$-assert-Header$Companion$load$keySerializer$1$222 = "Mismatch key type serial: expected " + it.getSerial() + " but was " + serial;
                throw new AssertionError((Object)$i$a$-assert-Header$Companion$load$keySerializer$1$222);
            }
            Serializer keySerializer = serializer;
            Serializer it2 = it = Serializer.Companion.getForClass(valueClazz);
            boolean bl4 = false;
            long serial2 = Companion.getValueSerial(flags);
            boolean bl5 = $i$a$-assert-Header$Companion$load$keySerializer$1$222 = serial2 == it2.getSerial();
            if (_Assertions.ENABLED && !$i$a$-assert-Header$Companion$load$keySerializer$1$222) {
                boolean $i$a$-assert-Header$Companion$load$valueSerializer$1$22 = false;
                String $i$a$-assert-Header$Companion$load$valueSerializer$1$22 = "Mismatch value type serial: expected " + it2.getSerial() + " but was " + serial2;
                throw new AssertionError((Object)$i$a$-assert-Header$Companion$load$valueSerializer$1$22);
            }
            Serializer valueSerializer = it;
            Hasher hasher = HasherProvider.Companion.getHashProvider(keyClazz).getHasher(this.getHasherSerial(flags));
            Intrinsics.reifiedOperationMarker((int)2, (String)"H");
            if (hasher == null) {
                throw new InvalidHashtableException("Mismatched hasher for a key type");
            }
            Hasher hasher2 = hasher;
            int capacity = this.toPositiveIntOrFail(buffer.readLong(16), "capacity");
            int maxEntries = this.toPositiveIntOrFail(buffer.readLong(24), "initialEntries");
            int maxDist = this.toPositiveIntOrFail(buffer.readLong(48), "maxDistance");
            boolean bl6 = false;
            int maxDistance = maxDist <= 0 ? maxEntries : maxDist;
            return new Header<Hasher>(capacity, maxEntries, maxDistance, keySerializer, valueSerializer, hasher2);
        }

        public final int toPositiveIntOrFail(long v, @NotNull String property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            if (v < 0L) {
                throw new InvalidHashtableException(property + " must not be negative but was: " + v);
            }
            if (v > Integer.MAX_VALUE) {
                throw new InvalidHashtableException("Maximum supported " + property + " value is: 2147483647, but was: " + v);
            }
            return (int)v;
        }

        private final long calcFlags(Serializer keySerializer, Serializer valueSerializer, Hasher hasher) {
            return (keySerializer.getSerial() & 7L) << 0 | (valueSerializer.getSerial() & 7L) << 3 | (hasher.getSerial() & 0xFFL) << 8;
        }

        public final long getKeySerial(long flags) {
            return flags >>> 0 & 7L;
        }

        public final long getValueSerial(long flags) {
            return flags >>> 3 & 7L;
        }

        public final long getHasherSerial(long flags) {
            return flags >>> 8 & 0xFFL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

