/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.MutableIOBuffer;
import dev.evo.persistent.hashmap.ConstantsKt;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.Serializer;
import dev.evo.persistent.hashmap.straight.Header;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006-"}, d2={"Ldev/evo/persistent/hashmap/straight/MapInfo;", "", "maxEntries", "", "loadFactor", "", "capacity", "bucketsPerPage", "numDataPages", "maxDistance", "bufferSize", "(IDIIIII)V", "getBucketsPerPage", "()I", "getBufferSize", "getCapacity", "getLoadFactor", "()D", "getMaxDistance", "getMaxEntries", "getNumDataPages", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "initBuffer", "", "buffer", "Ldev/evo/io/MutableIOBuffer;", "keySerializer", "Ldev/evo/persistent/hashmap/Serializer;", "valueSerializer", "hasher", "Ldev/evo/persistent/hashmap/Hasher;", "toString", "", "Companion", "persistent-hashmap"})
public final class MapInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxEntries;
    private final double loadFactor;
    private final int capacity;
    private final int bucketsPerPage;
    private final int numDataPages;
    private final int maxDistance;
    private final int bufferSize;
    public static final int DATA_PAGE_HEADER_SIZE = 16;
    public static final int META_SIZE = 2;
    public static final int META_TAG_BITS = 2;
    public static final int META_TAG_SHIFT = 14;
    public static final int META_TAG_MASK = 49152;
    public static final int META_FREE = 0;
    public static final int META_OCCUPIED = 32768;
    public static final int META_TOMBSTONE = 16384;
    public static final int VER_TAG_BITS = 14;
    public static final int VER_TAG_MASK = 16383;

    public MapInfo(int maxEntries, double loadFactor, int capacity, int bucketsPerPage, int numDataPages, int maxDistance, int bufferSize) {
        this.maxEntries = maxEntries;
        this.loadFactor = loadFactor;
        this.capacity = capacity;
        this.bucketsPerPage = bucketsPerPage;
        this.numDataPages = numDataPages;
        this.maxDistance = maxDistance;
        this.bufferSize = bufferSize;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public final double getLoadFactor() {
        return this.loadFactor;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getBucketsPerPage() {
        return this.bucketsPerPage;
    }

    public final int getNumDataPages() {
        return this.numDataPages;
    }

    public final int getMaxDistance() {
        return this.maxDistance;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void initBuffer(@NotNull MutableIOBuffer buffer, @NotNull Serializer keySerializer, @NotNull Serializer valueSerializer, @NotNull Hasher hasher) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter((Object)valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Header<Hasher> header = new Header<Hasher>(this.capacity, this.maxEntries, this.maxDistance, keySerializer, valueSerializer, hasher);
        header.dump(buffer);
    }

    public final int component1() {
        return this.maxEntries;
    }

    public final double component2() {
        return this.loadFactor;
    }

    public final int component3() {
        return this.capacity;
    }

    public final int component4() {
        return this.bucketsPerPage;
    }

    public final int component5() {
        return this.numDataPages;
    }

    public final int component6() {
        return this.maxDistance;
    }

    public final int component7() {
        return this.bufferSize;
    }

    @NotNull
    public final MapInfo copy(int maxEntries, double loadFactor, int capacity, int bucketsPerPage, int numDataPages, int maxDistance, int bufferSize) {
        return new MapInfo(maxEntries, loadFactor, capacity, bucketsPerPage, numDataPages, maxDistance, bufferSize);
    }

    public static /* synthetic */ MapInfo copy$default(MapInfo mapInfo, int n, double d, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = mapInfo.maxEntries;
        }
        if ((n7 & 2) != 0) {
            d = mapInfo.loadFactor;
        }
        if ((n7 & 4) != 0) {
            n2 = mapInfo.capacity;
        }
        if ((n7 & 8) != 0) {
            n3 = mapInfo.bucketsPerPage;
        }
        if ((n7 & 0x10) != 0) {
            n4 = mapInfo.numDataPages;
        }
        if ((n7 & 0x20) != 0) {
            n5 = mapInfo.maxDistance;
        }
        if ((n7 & 0x40) != 0) {
            n6 = mapInfo.bufferSize;
        }
        return mapInfo.copy(n, d, n2, n3, n4, n5, n6);
    }

    @NotNull
    public String toString() {
        return "MapInfo(maxEntries=" + this.maxEntries + ", loadFactor=" + this.loadFactor + ", capacity=" + this.capacity + ", bucketsPerPage=" + this.bucketsPerPage + ", numDataPages=" + this.numDataPages + ", maxDistance=" + this.maxDistance + ", bufferSize=" + this.bufferSize + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.maxEntries);
        result = result * 31 + Double.hashCode(this.loadFactor);
        result = result * 31 + Integer.hashCode(this.capacity);
        result = result * 31 + Integer.hashCode(this.bucketsPerPage);
        result = result * 31 + Integer.hashCode(this.numDataPages);
        result = result * 31 + Integer.hashCode(this.maxDistance);
        result = result * 31 + Integer.hashCode(this.bufferSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapInfo)) {
            return false;
        }
        MapInfo mapInfo = (MapInfo)other;
        if (this.maxEntries != mapInfo.maxEntries) {
            return false;
        }
        if (Double.compare(this.loadFactor, mapInfo.loadFactor) != 0) {
            return false;
        }
        if (this.capacity != mapInfo.capacity) {
            return false;
        }
        if (this.bucketsPerPage != mapInfo.bucketsPerPage) {
            return false;
        }
        if (this.numDataPages != mapInfo.numDataPages) {
            return false;
        }
        if (this.maxDistance != mapInfo.maxDistance) {
            return false;
        }
        return this.bufferSize == mapInfo.bufferSize;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/evo/persistent/hashmap/straight/MapInfo$Companion;", "", "()V", "DATA_PAGE_HEADER_SIZE", "", "META_FREE", "META_OCCUPIED", "META_SIZE", "META_TAG_BITS", "META_TAG_MASK", "META_TAG_SHIFT", "META_TOMBSTONE", "VER_TAG_BITS", "VER_TAG_MASK", "calcBucketsPerPage", "bucketSize", "calcCapacity", "maxEntries", "loadFactor", "", "calcDataPages", "capacity", "bucketsPerPage", "calcFor", "Ldev/evo/persistent/hashmap/straight/MapInfo;", "maxDistance", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapInfo calcFor(int maxEntries, double loadFactor, int bucketSize, int maxDistance) {
            int capacity = this.calcCapacity(maxEntries, loadFactor);
            int bucketsPerPage = this.calcBucketsPerPage(bucketSize);
            int numDataPages = this.calcDataPages(capacity, bucketsPerPage);
            return new MapInfo(maxEntries, loadFactor, capacity, bucketsPerPage, numDataPages, maxDistance, (1 + numDataPages) * 4096);
        }

        public static /* synthetic */ MapInfo calcFor$default(Companion companion, int n, double d, int n2, int n3, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = Integer.MAX_VALUE;
            }
            return companion.calcFor(n, d, n2, n3);
        }

        public final int calcCapacity(int maxEntries, double loadFactor) {
            int element$iv;
            block2: {
                int minCapacity = (int)Math.ceil((double)maxEntries / loadFactor);
                int[] $this$first$iv = ConstantsKt.getPRIMES();
                boolean $i$f$first = false;
                int n = $this$first$iv.length;
                for (int i = 0; i < n; ++i) {
                    int it = element$iv = $this$first$iv[i];
                    boolean bl = false;
                    if (!(it >= minCapacity)) {
                        continue;
                    }
                    break block2;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            return element$iv;
        }

        public final int calcDataPages(int capacity, int bucketsPerPage) {
            return (capacity + bucketsPerPage - 1) / bucketsPerPage;
        }

        public final int calcBucketsPerPage(int bucketSize) {
            return 4080 / bucketSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

