/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.MutableIOBuffer;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.VersionedDirectory;
import dev.evo.persistent.VersionedMmapDirectory;
import dev.evo.persistent.VersionedRamDirectory;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.HasherProvider;
import dev.evo.persistent.hashmap.straight.MapInfo;
import dev.evo.persistent.hashmap.straight.StraightHashMap;
import dev.evo.persistent.hashmap.straight.StraightHashMapBaseEnv;
import dev.evo.persistent.hashmap.straight.StraightHashMapRO;
import dev.evo.persistent.hashmap.straight.StraightHashMapROEnv;
import dev.evo.persistent.hashmap.straight.StraightHashMapType;
import dev.evo.rc.IllegalRefCountException;
import dev.evo.rc.RefCounted;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 $*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u00020\t:\u0002#$B?\b\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00028\u00022\u0006\u0010\u0017\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u001c\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00028\u00022\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u000b\u0010!\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv;", "P", "Ldev/evo/persistent/hashmap/HasherProvider;", "H", "Ldev/evo/persistent/hashmap/Hasher;", "W", "Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "RO", "Ldev/evo/persistent/hashmap/straight/StraightHashMapRO;", "Ldev/evo/persistent/hashmap/straight/StraightHashMapBaseEnv;", "dir", "Ldev/evo/persistent/VersionedDirectory;", "loadFactor", "", "mapType", "Ldev/evo/persistent/hashmap/straight/StraightHashMapType;", "hasher", "(Ldev/evo/persistent/VersionedDirectory;DLdev/evo/persistent/hashmap/straight/StraightHashMapType;Ldev/evo/persistent/hashmap/Hasher;)V", "getLoadFactor", "()D", "close", "", "commit", "map", "(Ldev/evo/persistent/hashmap/straight/StraightHashMap;)V", "copyMap", "(Ldev/evo/persistent/hashmap/straight/StraightHashMap;)Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "discard", "newMap", "oldMap", "maxEntries", "", "(Ldev/evo/persistent/hashmap/straight/StraightHashMap;I)Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "openMap", "()Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "Builder", "Companion", "persistent-hashmap"})
public final class StraightHashMapEnv<P extends HasherProvider<? extends H>, H extends Hasher, W extends StraightHashMap, RO extends StraightHashMapRO>
extends StraightHashMapBaseEnv {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double loadFactor;
    @NotNull
    private final StraightHashMapType<P, H, W, RO> mapType;
    @NotNull
    private final Hasher hasher;
    @NotNull
    private static final List<Character> TEMP_SYMBOLS = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)new CharRange('0', '9'))), (Iterable)CollectionsKt.toList((Iterable)((Iterable)new CharRange('a', 'z')))), (Iterable)CollectionsKt.toList((Iterable)((Iterable)new CharRange('A', 'Z'))));

    private StraightHashMapEnv(VersionedDirectory dir, double loadFactor, StraightHashMapType<P, H, W, RO> mapType, Hasher hasher) {
        super(dir);
        this.loadFactor = loadFactor;
        this.mapType = mapType;
        this.hasher = hasher;
    }

    public final double getLoadFactor() {
        return this.loadFactor;
    }

    @NotNull
    public final W openMap() {
        long ver = this.getDir().readVersion();
        RefCounted<MappedFile<MutableIOBuffer>> mapBuffer = this.getDir().openFileWritable(StraightHashMapBaseEnv.Companion.getHashmapFilename(ver));
        return this.mapType.createWritable(ver, mapBuffer);
    }

    @NotNull
    public final W newMap(@NotNull W oldMap, int maxEntries) {
        W w;
        Intrinsics.checkNotNullParameter(oldMap, (String)"oldMap");
        long version = oldMap.getVersion() + 1L;
        long[] bookmarks = oldMap.loadAllBookmarks();
        MapInfo mapInfo = MapInfo.Companion.calcFor(maxEntries, this.loadFactor, this.mapType.getBucketLayout().getSize(), oldMap.getMaxDistance());
        String mapFilename = StraightHashMapEnv.Companion.tempFileName();
        RefCounted<MappedFile<MutableIOBuffer>> mappedFile = this.getDir().createFile(mapFilename, mapInfo.getBufferSize(), true);
        mapInfo.initBuffer(mappedFile.get().getBuffer(), this.mapType.getKeySerializer(), this.mapType.getValueSerializer(), this.hasher);
        W $this$newMap_u24lambda_u240 = w = this.mapType.createWritable(version, mappedFile);
        boolean bl = false;
        $this$newMap_u24lambda_u240.storeAllBookmarks(bookmarks);
        return w;
    }

    @NotNull
    public final W copyMap(@NotNull W map) {
        W newMap;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        int newMaxEntries = map.size() * 2;
        while (!this.mapType.copyMap(map, newMap = this.newMap(map, newMaxEntries))) {
            newMaxEntries *= 2;
            newMap.close();
        }
        return newMap;
    }

    public final void commit(@NotNull W map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        long curVersion = this.getDir().readVersion();
        if (map.getVersion() <= curVersion) {
            throw new IllegalArgumentException("Map have already been committed");
        }
        this.getDir().rename(map.getName(), StraightHashMapBaseEnv.Companion.getHashmapFilename(map.getVersion()));
        map.flush();
        this.getDir().writeVersion(map.getVersion());
        this.getDir().deleteFile(StraightHashMapBaseEnv.Companion.getHashmapFilename(curVersion));
    }

    public final void discard(@NotNull W map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        long curVersion = this.getDir().readVersion();
        if (map.getVersion() == curVersion) {
            throw new IllegalArgumentException("Cannot delete active map");
        }
        this.getDir().deleteFile(map.getName());
    }

    @Override
    public void close() {
        this.getDir().close();
    }

    public /* synthetic */ StraightHashMapEnv(VersionedDirectory dir, double loadFactor, StraightHashMapType mapType, Hasher hasher, DefaultConstructorMarker $constructor_marker) {
        this(dir, loadFactor, mapType, hasher);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\u000e\b\u0004\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0005\u0010\u0003*\u00020\u0004*\b\b\u0006\u0010\u0005*\u00020\u0006*\b\b\u0007\u0010\u0007*\u00020\b2\u00020\t:\u00016B%\u0012\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010%\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070&2\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070&J\u001e\u0010*\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070&J+\u0010\r\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010\r\u001a\u00028\u0005\u00a2\u0006\u0002\u0010+J&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010,\u001a\u00020-J&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010.\u001a\u00020\u0013J&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010\u0018\u001a\u00020\u0017J&\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010/\u001a\u00020\u0013J&\u00100\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070&2\u0006\u00101\u001a\u000202J&\u00103\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u0007042\u0006\u00101\u001a\u000202J(\u00105\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070&2\u0006\u0010'\u001a\u00020(H\u0002J&\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u00002\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00067"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv$Builder;", "P", "Ldev/evo/persistent/hashmap/HasherProvider;", "H", "Ldev/evo/persistent/hashmap/Hasher;", "W", "Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "RO", "Ldev/evo/persistent/hashmap/straight/StraightHashMapRO;", "", "mapType", "Ldev/evo/persistent/hashmap/straight/StraightHashMapType;", "(Ldev/evo/persistent/hashmap/straight/StraightHashMapType;)V", "hasher", "getHasher", "()Ldev/evo/persistent/hashmap/Hasher;", "setHasher", "(Ldev/evo/persistent/hashmap/Hasher;)V", "<set-?>", "", "initialEntries", "getInitialEntries", "()I", "", "loadFactor", "getLoadFactor", "()D", "maxDistance", "getMaxDistance", "setMaxDistance", "(I)V", "useUnmapHack", "", "getUseUnmapHack", "()Z", "setUseUnmapHack", "(Z)V", "create", "Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv;", "dir", "Ldev/evo/persistent/VersionedDirectory;", "createAnonymousDirect", "createAnonymousHeap", "(Ldev/evo/persistent/hashmap/Hasher;)Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv$Builder;", "serial", "", "maxEntries", "maxDist", "open", "path", "Ljava/nio/file/Path;", "openReadOnly", "Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv;", "openWritable", "Companion", "persistent-hashmap"})
    public static final class Builder<P extends HasherProvider<? extends H>, H extends Hasher, W extends StraightHashMap, RO extends StraightHashMapRO> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final StraightHashMapType<P, H, W, RO> mapType;
        @NotNull
        private Hasher hasher;
        private int initialEntries;
        private double loadFactor;
        private int maxDistance;
        private boolean useUnmapHack;
        @NotNull
        private static final String VERSION_FILENAME = "hashmap.ver";
        private static final int DEFAULT_INITIAL_ENTRIES = 1024;
        private static final double DEFAULT_LOAD_FACTOR = 0.75;

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull StraightHashMapType<P, H, W, RO> mapType) {
            void $this$hasher_u24lambda_u240;
            Intrinsics.checkNotNullParameter(mapType, (String)"mapType");
            this.mapType = mapType;
            HasherProvider<H> hasherProvider = this.mapType.getHasherProvider();
            Builder builder = this;
            boolean bl = false;
            builder.hasher = $this$hasher_u24lambda_u240.getHasher($this$hasher_u24lambda_u240.getDefaultHasherSerial());
            this.initialEntries = 1024;
            this.loadFactor = 0.75;
        }

        @NotNull
        public final Hasher getHasher() {
            return this.hasher;
        }

        public final void setHasher(@NotNull Hasher hasher) {
            Intrinsics.checkNotNullParameter((Object)hasher, (String)"<set-?>");
            this.hasher = hasher;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder<P, H, W, RO> hasher(long serial) {
            void $this$hasher_u24lambda_u242_u24lambda_u241;
            Builder builder;
            Builder $this$hasher_u24lambda_u242 = builder = this;
            boolean bl = false;
            HasherProvider<H> hasherProvider = $this$hasher_u24lambda_u242.mapType.getHasherProvider();
            Builder builder2 = $this$hasher_u24lambda_u242;
            boolean bl2 = false;
            builder2.hasher = $this$hasher_u24lambda_u242_u24lambda_u241.getHasher(serial);
            return builder;
        }

        @NotNull
        public final Builder<P, H, W, RO> hasher(@NotNull H hasher) {
            Builder builder;
            Intrinsics.checkNotNullParameter(hasher, (String)"hasher");
            Builder $this$hasher_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$hasher_u24lambda_u243.hasher = hasher;
            return builder;
        }

        public final int getInitialEntries() {
            return this.initialEntries;
        }

        @NotNull
        public final Builder<P, H, W, RO> initialEntries(int maxEntries) {
            Builder builder;
            Builder $this$initialEntries_u24lambda_u244 = builder = this;
            boolean bl = false;
            if (maxEntries <= 0) {
                throw new IllegalArgumentException("Maximum number of entries cannot be negative or zero");
            }
            $this$initialEntries_u24lambda_u244.initialEntries = maxEntries;
            return builder;
        }

        public final double getLoadFactor() {
            return this.loadFactor;
        }

        @NotNull
        public final Builder<P, H, W, RO> loadFactor(double loadFactor) {
            Builder builder;
            Builder $this$loadFactor_u24lambda_u245 = builder = this;
            boolean bl = false;
            if (loadFactor <= 0.0 || loadFactor > 1.0) {
                throw new IllegalArgumentException("Load factor must be great than zero and less or equal 1");
            }
            $this$loadFactor_u24lambda_u245.loadFactor = loadFactor;
            return builder;
        }

        public final int getMaxDistance() {
            return this.maxDistance;
        }

        public final void setMaxDistance(int n) {
            this.maxDistance = n;
        }

        @NotNull
        public final Builder<P, H, W, RO> maxDistance(int maxDist) {
            Builder builder;
            Builder $this$maxDistance_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$maxDistance_u24lambda_u246.maxDistance = maxDist;
            return builder;
        }

        public final boolean getUseUnmapHack() {
            return this.useUnmapHack;
        }

        public final void setUseUnmapHack(boolean bl) {
            this.useUnmapHack = bl;
        }

        @NotNull
        public final Builder<P, H, W, RO> useUnmapHack(boolean useUnmapHack2) {
            Builder builder;
            Builder $this$useUnmapHack_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$useUnmapHack_u24lambda_u247.useUnmapHack = useUnmapHack2;
            return builder;
        }

        @NotNull
        public final StraightHashMapEnv<P, H, W, RO> open(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            VersionedMmapDirectory dir = VersionedMmapDirectory.Companion.openWritable(path, VERSION_FILENAME);
            dir.setUseUnmapHack(this.useUnmapHack);
            return dir.getCreated() ? this.create(dir) : this.openWritable(dir);
        }

        @NotNull
        public final StraightHashMapROEnv<P, H, W, RO> openReadOnly(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            VersionedMmapDirectory dir = VersionedMmapDirectory.Companion.openReadOnly(path, VERSION_FILENAME);
            dir.setUseUnmapHack(this.useUnmapHack);
            return new StraightHashMapROEnv<P, H, W, RO>(dir, this.mapType);
        }

        @NotNull
        public final StraightHashMapEnv<P, H, W, RO> createAnonymousDirect() {
            VersionedRamDirectory dir = VersionedRamDirectory.Companion.createDirect();
            dir.setUseUnmapHack(this.useUnmapHack);
            return this.create(dir);
        }

        @NotNull
        public final StraightHashMapEnv<P, H, W, RO> createAnonymousHeap() {
            VersionedRamDirectory dir = VersionedRamDirectory.Companion.createHeap();
            return this.create(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final StraightHashMapEnv<P, H, W, RO> create(VersionedDirectory dir) {
            RefCounted $this$use$iv;
            block5: {
                block4: {
                    long version = dir.readVersion();
                    String filename = StraightHashMapBaseEnv.Companion.getHashmapFilename(version);
                    MapInfo mapInfo = MapInfo.Companion.calcFor(this.initialEntries, this.loadFactor, this.mapType.getBucketLayout().getSize(), this.maxDistance);
                    $this$use$iv = VersionedDirectory.DefaultImpls.createFile$default(dir, filename, mapInfo.getBufferSize(), false, 4, null);
                    boolean $i$f$use = false;
                    boolean acquired$iv = false;
                    try {
                        Object value$iv = $this$use$iv.retain();
                        if (value$iv == null) break block4;
                        acquired$iv = true;
                        MappedFile file2 = (MappedFile)value$iv;
                        boolean bl = false;
                        mapInfo.initBuffer((MutableIOBuffer)file2.getBuffer(), this.mapType.getKeySerializer(), this.mapType.getValueSerializer(), this.hasher);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        if (acquired$iv) {
                            $this$use$iv.release();
                        }
                        throw throwable;
                    }
                    break block5;
                }
                throw new IllegalRefCountException();
            }
            $this$use$iv.release();
            return new StraightHashMapEnv(dir, this.loadFactor, this.mapType, this.hasher, null);
        }

        private final StraightHashMapEnv<P, H, W, RO> openWritable(VersionedDirectory dir) {
            return new StraightHashMapEnv(dir, this.loadFactor, this.mapType, this.hasher, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv$Builder$Companion;", "", "()V", "DEFAULT_INITIAL_ENTRIES", "", "DEFAULT_LOAD_FACTOR", "", "VERSION_FILENAME", "", "persistent-hashmap"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapEnv$Companion;", "", "()V", "TEMP_SYMBOLS", "", "", "tempFileName", "", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String tempFileName() {
            void $this$fold$iv;
            Iterable iterable = (Iterable)new IntRange(1, 8);
            String initial$iv = "";
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv = ((IntIterator)iterator).nextInt();
                String s = accumulator$iv;
                boolean bl = false;
                accumulator$iv = s + TEMP_SYMBOLS.get(Random.Default.nextInt(TEMP_SYMBOLS.size()));
            }
            String randomPart = accumulator$iv;
            return ".hashmap_" + randomPart + ".tmp";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

