/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.MutableIOBuffer;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.hashmap.straight.PutResult;
import dev.evo.persistent.hashmap.straight.StraightHashMapIterator_Int_Short;
import dev.evo.persistent.hashmap.straight.StraightHashMapROImpl_Int_Short;
import dev.evo.persistent.hashmap.straight.StraightHashMapType_Int_Short;
import dev.evo.persistent.hashmap.straight.StraightHashMap_Int_Short;
import dev.evo.rc.RefCounted;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002:\u0001*B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\fj\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0014\u001a\u00060\fj\u0002`\u0015H\u0016J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0004J(\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\fj\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0004J \u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\fH\u0004J\u001c\u0010$\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\fj\u0002`\u0015H\u0004J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\fH\u0004J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\fH\u0004J\u001c\u0010)\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\f2\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0004R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapImpl_Int_Short;", "Ldev/evo/persistent/hashmap/straight/StraightHashMap_Int_Short;", "Ldev/evo/persistent/hashmap/straight/StraightHashMapROImpl_Int_Short;", "version", "", "file", "Ldev/evo/rc/RefCounted;", "Ldev/evo/persistent/MappedFile;", "Ldev/evo/io/MutableIOBuffer;", "(JLdev/evo/rc/RefCounted;)V", "buffer", "cleanupTombstones", "", "bucketIx", "flush", "", "iterator", "Ldev/evo/persistent/hashmap/straight/StraightHashMapIterator_Int_Short;", "put", "Ldev/evo/persistent/hashmap/straight/PutResult;", "key", "Ldev/evo/persistent/hashmap/straight/keyTypes/Int/K;", "value", "", "Ldev/evo/persistent/hashmap/straight/valueTypes/Short/V;", "remove", "", "storeAllBookmarks", "values", "", "storeBookmark", "ix", "writeBucketData", "bucketOffset", "writeBucketMeta", "tag", "writeKey", "writeSize", "size", "writeTombstones", "tombstones", "writeValue", "Iterator", "persistent-hashmap"})
public final class StraightHashMapImpl_Int_Short
extends StraightHashMapROImpl_Int_Short
implements StraightHashMap_Int_Short {
    @NotNull
    private final RefCounted<MappedFile<MutableIOBuffer>> file;
    @NotNull
    private final MutableIOBuffer buffer;

    public StraightHashMapImpl_Int_Short(long version, @NotNull RefCounted<? extends MappedFile<? extends MutableIOBuffer>> file2) {
        Intrinsics.checkNotNullParameter(file2, (String)"file");
        super(version, file2);
        this.file = file2;
        this.buffer = this.file.get().getBuffer();
    }

    protected final void writeSize(int size) {
        this.buffer.writeIntOrdered(32, size);
    }

    protected final void writeTombstones(int tombstones) {
        this.buffer.writeIntOrdered(40, tombstones);
    }

    protected final void writeBucketMeta(int bucketOffset, int tag, int version) {
        this.buffer.writeShortVolatile(bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getMetaOffset(), (short)(tag | version & 0x3FFF));
    }

    protected final void writeKey(int bucketOffset, int key) {
        StraightHashMapType_Int_Short.INSTANCE.getKeySerializer().write(this.buffer, bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getKeyOffset(), key);
    }

    protected final void writeValue(int bucketOffset, short value) {
        StraightHashMapType_Int_Short.INSTANCE.getValueSerializer().write(this.buffer, bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getValueOffset(), value);
    }

    protected final void writeBucketData(int bucketOffset, int key, short value) {
        this.writeValue(bucketOffset, value);
        this.writeKey(bucketOffset, key);
    }

    @Override
    public final void storeBookmark(int ix, long value) {
        this.getHeader().storeBookmark(this.buffer, ix, value);
    }

    @Override
    public final void storeAllBookmarks(@NotNull long[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.getHeader().storeAllBookmarks(this.buffer, values);
    }

    @Override
    public void flush() {
        this.buffer.fsync();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PutResult put(int key, short value) {
        StraightHashMapROImpl_Int_Short this_$iv = this;
        boolean $i$f$find = false;
        int hash$iv = StraightHashMapROImpl_Int_Short.access$getHasher(this_$iv).hash(key);
        int bucketIx$iv = hash$iv % this_$iv.getCapacity();
        int probe$iv = 0;
        int dist$iv = -1;
        int tombstoneBucketOffset$iv = -1;
        int tombstoneMeta$iv = -1;
        while (true) {
            ++dist$iv;
            int pageOffset$iv = StraightHashMapROImpl_Int_Short.access$getPageOffset(this_$iv, bucketIx$iv);
            int bucketOffset$iv = StraightHashMapROImpl_Int_Short.access$getBucketOffset(this_$iv, pageOffset$iv, bucketIx$iv);
            int meta$iv = StraightHashMapROImpl_Int_Short.access$readBucketMeta(this_$iv, bucketOffset$iv);
            if (StraightHashMapROImpl_Int_Short.access$isBucketTombstoned(this_$iv, meta$iv)) {
                tombstoneBucketOffset$iv = bucketOffset$iv;
                tombstoneMeta$iv = meta$iv;
            } else {
                if (StraightHashMapROImpl_Int_Short.access$isBucketFree(this_$iv, meta$iv) || dist$iv > this_$iv.getMaxDistance()) {
                    void tombstoneMeta;
                    void tombstoneOffset;
                    void dist;
                    int n = dist$iv;
                    int n2 = tombstoneMeta$iv;
                    int n3 = tombstoneBucketOffset$iv;
                    int n4 = meta$iv;
                    int bucketOffset = bucketOffset$iv;
                    boolean bl = false;
                    if (dist > this.getMaxDistance()) {
                        return PutResult.OVERFLOW;
                    }
                    if (this.size() + this.tombstones() >= this.getHeader().getMaxEntries()) {
                        return PutResult.OVERFLOW;
                    }
                    if (tombstoneOffset < 0) {
                        void meta;
                        this.writeBucketData(bucketOffset, key, value);
                        this.writeBucketMeta(bucketOffset, 32768, this.bucketVersion((int)meta) + 1);
                        this.writeSize(this.size() + 1);
                        break;
                    }
                    this.writeBucketData((int)tombstoneOffset, key, value);
                    this.writeBucketMeta((int)tombstoneOffset, 32768, this.bucketVersion((int)tombstoneMeta) + 1);
                    this.writeTombstones(this.tombstones() - 1);
                    this.writeSize(this.size() + 1);
                    break;
                }
                if (key == StraightHashMapROImpl_Int_Short.access$readKey(this_$iv, bucketOffset$iv)) {
                    int bucketOffset = bucketOffset$iv;
                    boolean bl = false;
                    this.writeValue(bucketOffset, value);
                    return PutResult.OK;
                }
            }
            bucketIx$iv = StraightHashMapROImpl_Int_Short.access$getHasher(this_$iv).probe(++probe$iv, bucketIx$iv, hash$iv, this_$iv.getCapacity());
        }
        return PutResult.OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(int key) {
        StraightHashMapROImpl_Int_Short this_$iv = this;
        boolean $i$f$find = false;
        int hash$iv = StraightHashMapROImpl_Int_Short.access$getHasher(this_$iv).hash(key);
        int bucketIx$iv = hash$iv % this_$iv.getCapacity();
        int probe$iv = 0;
        int dist$iv = -1;
        int tombstoneBucketOffset$iv = -1;
        int tombstoneMeta$iv = -1;
        while (true) {
            ++dist$iv;
            int pageOffset$iv = StraightHashMapROImpl_Int_Short.access$getPageOffset(this_$iv, bucketIx$iv);
            int bucketOffset$iv = StraightHashMapROImpl_Int_Short.access$getBucketOffset(this_$iv, pageOffset$iv, bucketIx$iv);
            int meta$iv = StraightHashMapROImpl_Int_Short.access$readBucketMeta(this_$iv, bucketOffset$iv);
            if (StraightHashMapROImpl_Int_Short.access$isBucketTombstoned(this_$iv, meta$iv)) {
                tombstoneBucketOffset$iv = bucketOffset$iv;
                tombstoneMeta$iv = meta$iv;
            } else {
                if (StraightHashMapROImpl_Int_Short.access$isBucketFree(this_$iv, meta$iv) || dist$iv > this_$iv.getMaxDistance()) {
                    boolean bl = false;
                    return false;
                }
                if (key == StraightHashMapROImpl_Int_Short.access$readKey(this_$iv, bucketOffset$iv)) {
                    void meta;
                    void bucketOffset;
                    int nextBucketIx;
                    int nextBucketPageOffset;
                    int nextBucketOffset;
                    int nextMeta;
                    int n = meta$iv;
                    int n2 = bucketOffset$iv;
                    int bucketIx = bucketIx$iv;
                    boolean bl = false;
                    if (this.getHasher().isSequential() && this.isBucketFree(nextMeta = this.readBucketMeta(nextBucketOffset = this.getBucketOffset(nextBucketPageOffset = this.getPageOffset(nextBucketIx = this.nextBucketIx(bucketIx)), nextBucketIx)))) {
                        this.writeBucketMeta((int)bucketOffset, 0, this.bucketVersion((int)meta) + 1);
                        this.writeTombstones(this.tombstones() - this.cleanupTombstones(bucketIx));
                        this.writeSize(this.size() - 1);
                        return true;
                    }
                    this.writeBucketMeta((int)bucketOffset, 16384, this.bucketVersion((int)meta) + 1);
                    this.writeTombstones(this.tombstones() + 1);
                    this.writeSize(this.size() - 1);
                    return true;
                }
            }
            bucketIx$iv = StraightHashMapROImpl_Int_Short.access$getHasher(this_$iv).probe(++probe$iv, bucketIx$iv, hash$iv, this_$iv.getCapacity());
        }
    }

    private final int cleanupTombstones(int bucketIx) {
        int prevBucketIx;
        int pageOffset;
        int prevBucketOffset;
        int meta;
        int curBucketIx = bucketIx;
        int cleaned = 0;
        while (this.isBucketTombstoned(meta = this.readBucketMeta(prevBucketOffset = this.getBucketOffset(pageOffset = this.getPageOffset(prevBucketIx = this.prevBucketIx(curBucketIx)), prevBucketIx)))) {
            this.writeBucketMeta(prevBucketOffset, 0, this.bucketVersion(meta) + 1);
            ++cleaned;
            curBucketIx = prevBucketIx;
        }
        return cleaned;
    }

    @Override
    @NotNull
    public StraightHashMapIterator_Int_Short iterator() {
        return new Iterator();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u00060\u0004j\u0002`\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapImpl_Int_Short$Iterator;", "Ldev/evo/persistent/hashmap/straight/StraightHashMapIterator_Int_Short;", "(Ldev/evo/persistent/hashmap/straight/StraightHashMapImpl_Int_Short;)V", "curBucketIx", "", "curBucketOffset", "key", "Ldev/evo/persistent/hashmap/straight/keyTypes/Int/K;", "next", "", "value", "", "Ldev/evo/persistent/hashmap/straight/valueTypes/Short/V;", "persistent-hashmap"})
    public final class Iterator
    implements StraightHashMapIterator_Int_Short {
        private int curBucketIx = -1;
        private int curBucketOffset = -1;

        @Override
        public boolean next() {
            int pageOffset;
            int bucketOffset;
            do {
                int n = this.curBucketIx;
                this.curBucketIx = n + 1;
                if (this.curBucketIx < StraightHashMapImpl_Int_Short.this.getCapacity()) continue;
                return false;
            } while (!StraightHashMapImpl_Int_Short.this.isBucketOccupied(StraightHashMapImpl_Int_Short.this.readBucketMeta(bucketOffset = StraightHashMapImpl_Int_Short.this.getBucketOffset(pageOffset = StraightHashMapImpl_Int_Short.this.getPageOffset(this.curBucketIx), this.curBucketIx))));
            this.curBucketOffset = bucketOffset;
            return true;
        }

        @Override
        public int key() {
            if (this.curBucketIx >= StraightHashMapImpl_Int_Short.this.getCapacity()) {
                throw new IndexOutOfBoundsException();
            }
            return StraightHashMapImpl_Int_Short.this.readKey(this.curBucketOffset);
        }

        @Override
        public short value() {
            if (this.curBucketIx >= StraightHashMapImpl_Int_Short.this.getCapacity()) {
                throw new IndexOutOfBoundsException();
            }
            return StraightHashMapImpl_Int_Short.this.readValue(this.curBucketOffset);
        }
    }
}

