/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.IOBuffer;
import dev.evo.persistent.FileDoesNotExistException;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.VersionedDirectory;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.HasherProvider;
import dev.evo.persistent.hashmap.straight.StraightHashMap;
import dev.evo.persistent.hashmap.straight.StraightHashMapBaseEnv;
import dev.evo.persistent.hashmap.straight.StraightHashMapRO;
import dev.evo.persistent.hashmap.straight.StraightHashMapType;
import dev.evo.rc.RefCounted;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u0017*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u00020\t:\u0002\u0017\u0018B-\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000b\u0010\u0015\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv;", "P", "Ldev/evo/persistent/hashmap/HasherProvider;", "H", "Ldev/evo/persistent/hashmap/Hasher;", "W", "Ldev/evo/persistent/hashmap/straight/StraightHashMap;", "RO", "Ldev/evo/persistent/hashmap/straight/StraightHashMapRO;", "Ldev/evo/persistent/hashmap/straight/StraightHashMapBaseEnv;", "dir", "Ldev/evo/persistent/VersionedDirectory;", "mapType", "Ldev/evo/persistent/hashmap/straight/StraightHashMapType;", "(Ldev/evo/persistent/VersionedDirectory;Ldev/evo/persistent/hashmap/straight/StraightHashMapType;)V", "currentFile", "Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv$VersionedFile;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "getCurrentMap", "()Ldev/evo/persistent/hashmap/straight/StraightHashMapRO;", "Companion", "VersionedFile", "persistent-hashmap"})
public final class StraightHashMapROEnv<P extends HasherProvider<? extends H>, H extends Hasher, W extends StraightHashMap, RO extends StraightHashMapRO>
extends StraightHashMapBaseEnv {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StraightHashMapType<P, H, W, RO> mapType;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private volatile VersionedFile currentFile;

    public StraightHashMapROEnv(@NotNull VersionedDirectory dir, @NotNull StraightHashMapType<P, H, W, RO> mapType) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(mapType, (String)"mapType");
        super(dir);
        this.mapType = mapType;
        this.lock = new ReentrantLock();
        this.currentFile = StraightHashMapROEnv.Companion.openFile(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RO getCurrentMap() {
        VersionedFile curFile = null;
        while ((curFile = this.currentFile).getFile().retain() == null) {
        }
        long version = this.getDir().readVersion();
        if (curFile.getVersion() != version && this.lock.tryLock()) {
            try {
                this.currentFile = StraightHashMapROEnv.Companion.openFile(this.getDir());
                curFile.getFile().release();
                curFile = this.currentFile;
                if (curFile.getFile().retain() == null) {
                    throw new IllegalStateException("Somehow the file just opened has been released");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return (RO)StraightHashMapType.DefaultImpls.createReadOnly$default(this.mapType, curFile.getVersion(), curFile.getFile(), false, 4, null);
    }

    @Override
    public void close() {
        this.currentFile.getFile().release();
        this.getDir().close();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv$VersionedFile;", "", "version", "", "file", "Ldev/evo/rc/RefCounted;", "Ldev/evo/persistent/MappedFile;", "Ldev/evo/io/IOBuffer;", "(JLdev/evo/rc/RefCounted;)V", "getFile", "()Ldev/evo/rc/RefCounted;", "getVersion", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "persistent-hashmap"})
    private static final class VersionedFile {
        private final long version;
        @NotNull
        private final RefCounted<MappedFile<IOBuffer>> file;

        public VersionedFile(long version, @NotNull RefCounted<? extends MappedFile<? extends IOBuffer>> file2) {
            Intrinsics.checkNotNullParameter(file2, (String)"file");
            this.version = version;
            this.file = file2;
        }

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final RefCounted<MappedFile<IOBuffer>> getFile() {
            return this.file;
        }

        public final long component1() {
            return this.version;
        }

        @NotNull
        public final RefCounted<MappedFile<IOBuffer>> component2() {
            return this.file;
        }

        @NotNull
        public final VersionedFile copy(long version, @NotNull RefCounted<? extends MappedFile<? extends IOBuffer>> file2) {
            Intrinsics.checkNotNullParameter(file2, (String)"file");
            return new VersionedFile(version, file2);
        }

        public static /* synthetic */ VersionedFile copy$default(VersionedFile versionedFile, long l, RefCounted refCounted, int n, Object object) {
            if ((n & 1) != 0) {
                l = versionedFile.version;
            }
            if ((n & 2) != 0) {
                refCounted = versionedFile.file;
            }
            return versionedFile.copy(l, refCounted);
        }

        @NotNull
        public String toString() {
            return "VersionedFile(version=" + this.version + ", file=" + this.file + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.version);
            result = result * 31 + this.file.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionedFile)) {
                return false;
            }
            VersionedFile versionedFile = (VersionedFile)other;
            if (this.version != versionedFile.version) {
                return false;
            }
            return Intrinsics.areEqual(this.file, versionedFile.file);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv$Companion;", "", "()V", "openFile", "Ldev/evo/persistent/hashmap/straight/StraightHashMapROEnv$VersionedFile;", "dir", "Ldev/evo/persistent/VersionedDirectory;", "tryOpenFile", "version", "", "persistent-hashmap"})
    public static final class Companion {
        private Companion() {
        }

        private final VersionedFile openFile(VersionedDirectory dir) {
            long version = dir.readVersion();
            VersionedFile newFile;
            while ((newFile = this.tryOpenFile(dir, version)) == null) {
                long newVersion = dir.readVersion();
                if (newVersion == version) {
                    Path path = Paths.get(StraightHashMapBaseEnv.Companion.getHashmapFilename(version), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(getHashmapFilename(version))");
                    throw new FileDoesNotExistException(path);
                }
                version = newVersion;
            }
            return newFile;
        }

        private final VersionedFile tryOpenFile(VersionedDirectory dir, long version) {
            VersionedFile versionedFile;
            try {
                versionedFile = new VersionedFile(version, dir.openFileReadOnly(StraightHashMapBaseEnv.Companion.getHashmapFilename(version)));
            }
            catch (FileDoesNotExistException e) {
                versionedFile = null;
            }
            return versionedFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

