/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.persistent.hashmap.straight;

import dev.evo.io.IOBuffer;
import dev.evo.persistent.MappedFile;
import dev.evo.persistent.hashmap.Hasher;
import dev.evo.persistent.hashmap.HasherProvider;
import dev.evo.persistent.hashmap.Hasher_Int;
import dev.evo.persistent.hashmap.Serializer;
import dev.evo.persistent.hashmap.straight.Header;
import dev.evo.persistent.hashmap.straight.InvalidHashtableException;
import dev.evo.persistent.hashmap.straight.MapInfo;
import dev.evo.persistent.hashmap.straight.StraightHashMapRO_Int_Short;
import dev.evo.persistent.hashmap.straight.StraightHashMapType_Int_Short;
import dev.evo.rc.RefCounted;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0004J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u00020(2\n\u0010)\u001a\u00060\nj\u0002`*H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020(H\u0016J\u00f1\u0001\u0010-\u001a\u00020&2\n\u0010)\u001a\u00060\nj\u0002`*2`\u0010.\u001a\\\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020&0/2u\u00104\u001aq\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(6\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(7\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b0\u0012\b\b\u001d\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020&05H\u0084\b\u00f8\u0001\u0000J$\u00108\u001a\u000609j\u0002`:2\n\u0010)\u001a\u00060\nj\u0002`*2\n\u0010;\u001a\u000609j\u0002`:H\u0016J\u0018\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0004J\u0010\u0010>\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0004J\u0010\u0010?\u001a\u00020(2\u0006\u0010$\u001a\u00020\nH\u0004J\u0010\u0010@\u001a\u00020(2\u0006\u0010$\u001a\u00020\nH\u0004J\u0010\u0010A\u001a\u00020(2\u0006\u0010$\u001a\u00020\nH\u0004J\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\nJ\u0010\u0010F\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0004J\u0010\u0010G\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0004J\u0010\u0010H\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0004J\u0014\u0010I\u001a\u00060\nj\u0002`*2\u0006\u00102\u001a\u00020\nH\u0004J\u0010\u0010J\u001a\u00020K2\u0006\u00102\u001a\u00020\nH\u0002J\u0010\u0010L\u001a\u00020K2\u0006\u00102\u001a\u00020\nH\u0002J\b\u0010M\u001a\u00020\nH\u0004J\b\u0010N\u001a\u00020\nH\u0004J\u0014\u0010O\u001a\u000609j\u0002`:2\u0006\u00102\u001a\u00020\nH\u0004J\u0006\u0010P\u001a\u00020\nJ\b\u0010Q\u001a\u00020\u001eH\u0016J\u0006\u0010R\u001a\u00020\nR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006S"}, d2={"Ldev/evo/persistent/hashmap/straight/StraightHashMapROImpl_Int_Short;", "Ldev/evo/persistent/hashmap/straight/StraightHashMapRO_Int_Short;", "version", "", "file", "Ldev/evo/rc/RefCounted;", "Ldev/evo/persistent/MappedFile;", "Ldev/evo/io/IOBuffer;", "(JLdev/evo/rc/RefCounted;)V", "bucketsPerPage", "", "getBucketsPerPage", "()I", "buffer", "capacity", "getCapacity", "hasher", "Ldev/evo/persistent/hashmap/Hasher_Int;", "Ldev/evo/persistent/hashmap/straight/keyTypes/Int/Hasher_K;", "getHasher", "()Ldev/evo/persistent/hashmap/Hasher_Int;", "header", "Ldev/evo/persistent/hashmap/straight/Header;", "getHeader", "()Ldev/evo/persistent/hashmap/straight/Header;", "maxDistance", "getMaxDistance", "maxEntries", "getMaxEntries", "name", "", "getName", "()Ljava/lang/String;", "getVersion", "()J", "bucketVersion", "meta", "close", "", "contains", "", "key", "Ldev/evo/persistent/hashmap/straight/keyTypes/Int/K;", "dump", "dumpContent", "find", "found", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "bucketIx", "bucketOffset", "dist", "notFound", "Lkotlin/Function5;", "tombstoneOffset", "tombstoneMeta", "get", "", "Ldev/evo/persistent/hashmap/straight/valueTypes/Short/V;", "defaultValue", "getBucketOffset", "pageOffset", "getPageOffset", "isBucketFree", "isBucketOccupied", "isBucketTombstoned", "loadAllBookmarks", "", "loadBookmark", "ix", "nextBucketIx", "prevBucketIx", "readBucketMeta", "readKey", "readRawKey", "", "readRawValue", "readSize", "readTombstones", "readValue", "size", "toString", "tombstones", "persistent-hashmap"})
public class StraightHashMapROImpl_Int_Short
implements StraightHashMapRO_Int_Short {
    private final long version;
    @NotNull
    private final RefCounted<MappedFile<IOBuffer>> file;
    @NotNull
    private final IOBuffer buffer;
    @NotNull
    private final String name;
    private final int bucketsPerPage;
    @NotNull
    private final Header<Hasher_Int> header;
    @NotNull
    private final Hasher_Int hasher;
    private final int maxEntries;
    private final int maxDistance;
    private final int capacity;

    /*
     * WARNING - void declaration
     */
    public StraightHashMapROImpl_Int_Short(long version, @NotNull RefCounted<? extends MappedFile<? extends IOBuffer>> file2) {
        boolean $i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222;
        boolean bl;
        void keyClazz$iv;
        Serializer serializer;
        void buffer$iv;
        void this_$iv;
        boolean bl2;
        Intrinsics.checkNotNullParameter(file2, (String)"file");
        this.version = version;
        this.file = file2;
        this.buffer = this.file.get().getBuffer();
        this.name = this.file.get().getPath();
        boolean bl3 = bl2 = this.buffer.size() % 4096 == 0;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-StraightHashMapROImpl_Int_Short$22 = false;
            String $i$a$-assert-StraightHashMapROImpl_Int_Short$22 = "Buffer length should be a multiple of 4096";
            throw new AssertionError((Object)$i$a$-assert-StraightHashMapROImpl_Int_Short$22);
        }
        this.bucketsPerPage = MapInfo.Companion.calcBucketsPerPage(StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getSize());
        Header.Companion companion = Header.Companion;
        IOBuffer $i$a$-assert-StraightHashMapROImpl_Int_Short$22 = this.buffer;
        Class<Integer> clazz = Integer.TYPE;
        Class<Short> valueClazz$iv = Short.TYPE;
        boolean $i$f$load = false;
        byte[] magic$iv = new byte[this_$iv.getMAGIC().length];
        buffer$iv.readBytes(0, magic$iv);
        if (!Arrays.equals(magic$iv, this_$iv.getMAGIC())) {
            String string = Arrays.toString(this_$iv.getMAGIC());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            String string2 = Arrays.toString(magic$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
            throw new InvalidHashtableException("Expected " + string + " magic number but was: " + string2);
        }
        long flags$iv = buffer$iv.readLong(8);
        Serializer it$iv = serializer = Serializer.Companion.getForClass(keyClazz$iv);
        boolean bl4 = false;
        long serial$iv = Header.Companion.getKeySerial(flags$iv);
        boolean bl5 = bl = serial$iv == it$iv.getSerial();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222 = false;
            String $i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222 = "Mismatch key type serial: expected " + it$iv.getSerial() + " but was " + serial$iv;
            throw new AssertionError((Object)$i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222);
        }
        Serializer keySerializer$iv = serializer;
        Serializer it$iv2 = it$iv = Serializer.Companion.getForClass(valueClazz$iv);
        boolean bl6 = false;
        long serial$iv2 = Header.Companion.getValueSerial(flags$iv);
        boolean bl7 = $i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222 = serial$iv2 == it$iv2.getSerial();
        if (_Assertions.ENABLED && !$i$a$-assert-Header$Companion$load$keySerializer$1$1$iv222) {
            boolean $i$a$-assert-Header$Companion$load$valueSerializer$1$1$iv22 = false;
            String $i$a$-assert-Header$Companion$load$valueSerializer$1$1$iv22 = "Mismatch value type serial: expected " + it$iv2.getSerial() + " but was " + serial$iv2;
            throw new AssertionError((Object)$i$a$-assert-Header$Companion$load$valueSerializer$1$1$iv22);
        }
        Serializer valueSerializer$iv = it$iv;
        Hasher hasher = HasherProvider.Companion.getHashProvider(keyClazz$iv).getHasher(this_$iv.getHasherSerial(flags$iv));
        if (!(hasher instanceof Hasher_Int)) {
            hasher = null;
        }
        Hasher hasher2 = (Hasher_Int)hasher;
        if (hasher2 == null) {
            throw new InvalidHashtableException("Mismatched hasher for a key type");
        }
        Hasher hasher$iv = hasher2;
        int capacity$iv = this_$iv.toPositiveIntOrFail(buffer$iv.readLong(16), "capacity");
        int maxEntries$iv = this_$iv.toPositiveIntOrFail(buffer$iv.readLong(24), "initialEntries");
        int maxDist$iv = this_$iv.toPositiveIntOrFail(buffer$iv.readLong(48), "maxDistance");
        boolean bl8 = false;
        int maxDistance$iv = maxDist$iv <= 0 ? maxEntries$iv : maxDist$iv;
        this.header = new Header<Hasher>(capacity$iv, maxEntries$iv, maxDistance$iv, keySerializer$iv, valueSerializer$iv, hasher$iv);
        this.hasher = this.header.getHasher();
        this.maxEntries = this.header.getMaxEntries();
        this.maxDistance = this.header.getMaxDistance();
        this.capacity = this.header.getCapacity();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final int getBucketsPerPage() {
        return this.bucketsPerPage;
    }

    @NotNull
    public final Header<Hasher_Int> getHeader() {
        return this.header;
    }

    @NotNull
    protected final Hasher_Int getHasher() {
        return this.hasher;
    }

    @Override
    public final int getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public final int getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        this.file.release();
    }

    @Override
    public final int size() {
        return this.readSize();
    }

    @Override
    public final int tombstones() {
        return this.readTombstones();
    }

    @Override
    public final long loadBookmark(int ix) {
        return this.header.loadBookmark(this.buffer, ix);
    }

    @Override
    @NotNull
    public final long[] loadAllBookmarks() {
        return this.header.loadAllBookmarks(this.buffer);
    }

    @NotNull
    public String toString() {
        return this.dump(false);
    }

    @Override
    @NotNull
    public String dump(boolean dumpContent) {
        int indexPad = String.valueOf(this.capacity).length();
        String description = StringsKt.trimMargin$default((String)("Header: " + this.header + "\n            |Bucket layout: " + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout() + "\n            |Size: " + this.size() + "\n            |Tombstones: " + this.tombstones() + "\n        "), null, (int)1, null);
        if (dumpContent) {
            String content2 = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.capacity)), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this, indexPad){
                final /* synthetic */ StraightHashMapROImpl_Int_Short this$0;
                final /* synthetic */ int $indexPad;
                {
                    this.this$0 = $receiver;
                    this.$indexPad = $indexPad;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(int bucketIx) {
                    int pageOffset = this.this$0.getPageOffset(bucketIx);
                    int bucketOffset = this.this$0.getBucketOffset(pageOffset, bucketIx);
                    String string = StringsKt.padEnd$default((String)String.valueOf(bucketIx), (int)this.$indexPad, (char)'\u0000', (int)2, null);
                    String string2 = Integer.toString(this.this$0.readBucketMeta(bucketOffset), CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                    return string + ": 0x" + string2 + ", " + ArraysKt.joinToString$default((byte[])StraightHashMapROImpl_Int_Short.access$readRawKey(this.this$0, bucketOffset), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) + ", " + ArraysKt.joinToString$default((byte[])StraightHashMapROImpl_Int_Short.access$readRawValue(this.this$0, bucketOffset), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
                }
            }), (int)30, null);
            return description + "\n" + content2;
        }
        return description;
    }

    protected final boolean isBucketFree(int meta) {
        return (meta & 0xC000) == 0;
    }

    protected final boolean isBucketOccupied(int meta) {
        return (meta & 0x8000) != 0;
    }

    protected final boolean isBucketTombstoned(int meta) {
        return (meta & 0x4000) != 0;
    }

    protected final int bucketVersion(int meta) {
        return meta & 0x3FFF;
    }

    protected final int nextBucketIx(int bucketIx) {
        if (bucketIx >= this.header.getCapacity() - 1) {
            return 0;
        }
        return bucketIx + 1;
    }

    protected final int prevBucketIx(int bucketIx) {
        if (bucketIx <= 0) {
            return this.header.getCapacity() - 1;
        }
        return bucketIx - 1;
    }

    protected final int getPageOffset(int bucketIx) {
        return 4096 * (1 + bucketIx / this.bucketsPerPage);
    }

    protected final int getBucketOffset(int pageOffset, int bucketIx) {
        return pageOffset + 16 + bucketIx % this.bucketsPerPage * StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getSize();
    }

    protected final int readSize() {
        return this.buffer.readInt(32);
    }

    protected final int readTombstones() {
        return this.buffer.readInt(40);
    }

    protected final int readBucketMeta(int bucketOffset) {
        return this.buffer.readShortVolatile(bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getMetaOffset()) & 0xFFFF;
    }

    protected final int readKey(int bucketOffset) {
        return StraightHashMapType_Int_Short.INSTANCE.getKeySerializer().read(this.buffer, bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getKeyOffset());
    }

    protected final short readValue(int bucketOffset) {
        return StraightHashMapType_Int_Short.INSTANCE.getValueSerializer().read(this.buffer, bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getValueOffset());
    }

    private final byte[] readRawKey(int bucketOffset) {
        byte[] rawKey = new byte[StraightHashMapType_Int_Short.INSTANCE.getKeySerializer().getSize()];
        this.buffer.readBytes(bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getKeyOffset(), rawKey);
        return rawKey;
    }

    private final byte[] readRawValue(int bucketOffset) {
        byte[] rawValue = new byte[StraightHashMapType_Int_Short.INSTANCE.getValueSerializer().getSize()];
        this.buffer.readBytes(bucketOffset + StraightHashMapType_Int_Short.INSTANCE.getBucketLayout().getValueOffset(), rawValue);
        return rawValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(int key) {
        StraightHashMapROImpl_Int_Short this_$iv = this;
        boolean $i$f$find = false;
        int hash$iv = this_$iv.hasher.hash(key);
        int bucketIx$iv = hash$iv % this_$iv.getCapacity();
        int probe$iv = 0;
        int dist$iv = -1;
        int tombstoneBucketOffset$iv = -1;
        int tombstoneMeta$iv = -1;
        while (true) {
            ++dist$iv;
            int pageOffset$iv = this_$iv.getPageOffset(bucketIx$iv);
            int bucketOffset$iv = this_$iv.getBucketOffset(pageOffset$iv, bucketIx$iv);
            int meta$iv = this_$iv.readBucketMeta(bucketOffset$iv);
            if (this_$iv.isBucketTombstoned(meta$iv)) {
                tombstoneBucketOffset$iv = bucketOffset$iv;
                tombstoneMeta$iv = meta$iv;
            } else {
                if (this_$iv.isBucketFree(meta$iv) || dist$iv > this_$iv.getMaxDistance()) {
                    boolean bl = false;
                    return false;
                }
                if (key == this_$iv.readKey(bucketOffset$iv)) {
                    int meta2;
                    void meta;
                    int n = meta$iv;
                    int bucketOffset = bucketOffset$iv;
                    boolean bl = false;
                    int m = meta;
                    while (m != (meta2 = this.readBucketMeta(bucketOffset))) {
                        m = meta2;
                        if (this.isBucketOccupied(m) && key == this.readKey(bucketOffset)) continue;
                        return false;
                    }
                    return true;
                }
            }
            bucketIx$iv = this_$iv.hasher.probe(++probe$iv, bucketIx$iv, hash$iv, this_$iv.getCapacity());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short get(int key, short defaultValue) {
        StraightHashMapROImpl_Int_Short this_$iv = this;
        boolean $i$f$find = false;
        int hash$iv = this_$iv.hasher.hash(key);
        int bucketIx$iv = hash$iv % this_$iv.getCapacity();
        int probe$iv = 0;
        int dist$iv = -1;
        int tombstoneBucketOffset$iv = -1;
        int tombstoneMeta$iv = -1;
        while (true) {
            ++dist$iv;
            int pageOffset$iv = this_$iv.getPageOffset(bucketIx$iv);
            int bucketOffset$iv = this_$iv.getBucketOffset(pageOffset$iv, bucketIx$iv);
            int meta$iv = this_$iv.readBucketMeta(bucketOffset$iv);
            if (this_$iv.isBucketTombstoned(meta$iv)) {
                tombstoneBucketOffset$iv = bucketOffset$iv;
                tombstoneMeta$iv = meta$iv;
            } else {
                if (this_$iv.isBucketFree(meta$iv) || dist$iv > this_$iv.getMaxDistance()) {
                    boolean bl = false;
                    return defaultValue;
                }
                if (key == this_$iv.readKey(bucketOffset$iv)) {
                    short value;
                    block6: {
                        int meta2;
                        void meta;
                        int n = meta$iv;
                        int bucketOffset = bucketOffset$iv;
                        boolean bl = false;
                        int meta1 = meta;
                        value = 0;
                        do {
                            value = this.readValue(bucketOffset);
                            meta2 = this.readBucketMeta(bucketOffset);
                            if (meta1 == meta2) break block6;
                        } while (this.isBucketOccupied(meta1 = meta2) && key == this.readKey(bucketOffset));
                        return defaultValue;
                    }
                    return value;
                }
            }
            bucketIx$iv = this_$iv.hasher.probe(++probe$iv, bucketIx$iv, hash$iv, this_$iv.getCapacity());
        }
    }

    protected final void find(int key, @NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> found, @NotNull Function5<? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> notFound) {
        Intrinsics.checkNotNullParameter(found, (String)"found");
        Intrinsics.checkNotNullParameter(notFound, (String)"notFound");
        boolean $i$f$find = false;
        int hash = this.hasher.hash(key);
        int bucketIx = hash % this.getCapacity();
        int probe = 0;
        int dist = -1;
        int tombstoneBucketOffset = -1;
        int tombstoneMeta = -1;
        while (true) {
            ++dist;
            int pageOffset = this.getPageOffset(bucketIx);
            int bucketOffset = this.getBucketOffset(pageOffset, bucketIx);
            int meta = this.readBucketMeta(bucketOffset);
            if (this.isBucketTombstoned(meta)) {
                tombstoneBucketOffset = bucketOffset;
                tombstoneMeta = meta;
            } else {
                if (this.isBucketFree(meta) || dist > this.getMaxDistance()) {
                    notFound.invoke((Object)bucketOffset, (Object)meta, (Object)tombstoneBucketOffset, (Object)tombstoneMeta, (Object)dist);
                    break;
                }
                if (key == this.readKey(bucketOffset)) {
                    found.invoke((Object)bucketIx, (Object)bucketOffset, (Object)meta, (Object)dist);
                    break;
                }
            }
            bucketIx = this.hasher.probe(++probe, bucketIx, hash, this.getCapacity());
        }
    }

    public static final /* synthetic */ byte[] access$readRawKey(StraightHashMapROImpl_Int_Short $this, int bucketOffset) {
        return $this.readRawKey(bucketOffset);
    }

    public static final /* synthetic */ byte[] access$readRawValue(StraightHashMapROImpl_Int_Short $this, int bucketOffset) {
        return $this.readRawValue(bucketOffset);
    }
}

