/*
 * Decompiled with CFR 0.152.
 */
package dev.evo.rc;

import dev.evo.rc.IllegalRefCountException;
import dev.evo.rc.RefCounted;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B0\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u000f\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0005X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Ldev/evo/rc/AtomicRefCounted;", "T", "Ldev/evo/rc/RefCounted;", "value", "drop", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "v", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "rc", "Ljava/util/concurrent/atomic/AtomicLong;", "Ljava/lang/Object;", "ensureValid", "", "get", "()Ljava/lang/Object;", "isValid", "", "refCount", "release", "retain", "persistent-hashmap"})
public final class AtomicRefCounted<T>
implements RefCounted<T> {
    private final T value;
    @NotNull
    private final Function1<T, Unit> drop;
    @NotNull
    private final AtomicLong rc;

    public AtomicRefCounted(T value, @NotNull Function1<? super T, Unit> drop) {
        Intrinsics.checkNotNullParameter(drop, (String)"drop");
        this.value = value;
        this.drop = drop;
        this.rc = new AtomicLong(2L);
    }

    @Override
    public long refCount() {
        long rc = this.rc.get();
        this.ensureValid(rc);
        return rc >>> 1;
    }

    @Override
    public T get() {
        this.ensureValid(this.rc.get());
        return this.value;
    }

    @Override
    @Nullable
    public T retain() {
        long oldRc = this.rc.getAndAdd(2L);
        if (!this.isValid(oldRc)) {
            return null;
        }
        return this.value;
    }

    @Override
    public boolean release() {
        boolean bl;
        block2: {
            while (true) {
                long curRc = this.rc.get();
                this.ensureValid(curRc);
                if (curRc == 2L) {
                    if (!this.rc.compareAndSet(curRc, 1L)) continue;
                    this.drop.invoke(this.value);
                    bl = true;
                    break block2;
                }
                if (this.rc.compareAndSet(curRc, curRc - (long)2)) break;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isValid(long rc) {
        return (rc & 1L) == 0L;
    }

    private final void ensureValid(long rc) {
        if (!this.isValid(rc)) {
            throw new IllegalRefCountException();
        }
    }
}

