/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.components.basic.compiler;

import com.google.auto.service.AutoService;
import dev.fastball.compile.AbstractComponentCompiler;
import dev.fastball.compile.CompileContext;
import dev.fastball.compile.ComponentCompiler;
import dev.fastball.compile.exception.CompilerException;
import dev.fastball.meta.component.ReferencedComponentInfo;
import dev.fastball.ui.components.basic.ReferenceComponent;
import dev.fastball.ui.components.basic.ReferenceComponentProps_AutoValue;
import dev.fastball.ui.components.basic.config.ReferenceComponentConfig;
import java.util.HashSet;

@AutoService(value={ComponentCompiler.class})
public class ReferenceComponentCompiler
extends AbstractComponentCompiler<ReferenceComponent, ReferenceComponentProps_AutoValue> {
    protected ReferenceComponentProps_AutoValue buildProps(CompileContext compileContext) {
        String componentClassName = compileContext.getComponentElement().getQualifiedName().toString();
        ReferenceComponentConfig config = compileContext.getComponentElement().getAnnotation(ReferenceComponentConfig.class);
        if (config == null) {
            String message = String.format("Class [%s] implements ReferenceComponent, but not found annotation @ReferenceComponentConfig", componentClassName);
            throw new CompilerException(message);
        }
        ReferenceComponentProps_AutoValue props = new ReferenceComponentProps_AutoValue();
        ReferencedComponentInfo componentInfo = new ReferencedComponentInfo();
        componentInfo.setComponentClass(componentClassName);
        componentInfo.setComponent(config.componentName());
        componentInfo.setComponentPackage(config.npmPackage());
        componentInfo.setComponentPath(config.fromPath());
        componentInfo.setDefaultComponent(config.defaultComponent());
        if (props.referencedComponentInfoList() == null) {
            props.referencedComponentInfoList(new HashSet<ReferencedComponentInfo>());
        }
        props.referencedComponentInfoList().add(componentInfo);
        props.component(componentInfo);
        return props;
    }

    public String getComponentName() {
        return "ReferenceComponent";
    }
}

