/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.components.compiler.form;

import dev.fastball.compile.AbstractComponentCompiler;
import dev.fastball.compile.CompileContext;
import dev.fastball.compile.exception.CompilerException;
import dev.fastball.compile.utils.ElementCompileUtils;
import dev.fastball.compile.utils.TypeCompileUtils;
import dev.fastball.core.annotation.Field;
import dev.fastball.core.annotation.ViewAction;
import dev.fastball.core.component.Component;
import dev.fastball.core.component.DownloadFile;
import dev.fastball.meta.action.ActionInfo;
import dev.fastball.meta.action.ApiActionInfo;
import dev.fastball.meta.basic.FieldInfo;
import dev.fastball.meta.component.ComponentProps;
import dev.fastball.ui.components.form.config.FieldDependencies;
import dev.fastball.ui.components.form.config.FieldDependency;
import dev.fastball.ui.components.form.config.FormConfig;
import dev.fastball.ui.components.form.config.FormField;
import dev.fastball.ui.components.form.config.FormFieldConfig;
import dev.fastball.ui.components.form.config.FormListConfig;
import dev.fastball.ui.components.form.config.SubTableRecordAction;
import dev.fastball.ui.components.form.config.SubTableRecordViewAction;
import dev.fastball.ui.components.form.config.ValueChangeHandler;
import dev.fastball.ui.components.metadata.form.FieldConfigOverrideInfo;
import dev.fastball.ui.components.metadata.form.FieldDependencyInfo;
import dev.fastball.ui.components.metadata.form.FormFieldInfo;
import dev.fastball.ui.components.metadata.form.FormProps_AutoValue;
import dev.fastball.ui.components.metadata.form.ValueChangeHandlerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractFormCompiler<T extends Component>
extends AbstractComponentCompiler<T, FormProps_AutoValue> {
    private static final String COMPONENT_TYPE = "FastballForm";

    protected FormProps_AutoValue buildProps(CompileContext compileContext) {
        return new FormProps_AutoValue();
    }

    protected void compileProps(FormProps_AutoValue props, CompileContext compileContext) {
        List genericTypes = this.getGenericTypeElements(compileContext);
        FormConfig config = compileContext.getComponentElement().getAnnotation(FormConfig.class);
        if (config != null) {
            props.showReset(Boolean.valueOf(config.showReset()));
            props.column(config.column());
            if (config.readonly()) {
                props.readonly(true);
                props.showReset(Boolean.valueOf(false));
            }
        } else {
            props.column(3);
            props.showReset(Boolean.valueOf(true));
        }
        props.fields(TypeCompileUtils.compileTypeFields((TypeElement)((TypeElement)genericTypes.get(0)), (ProcessingEnvironment)compileContext.getProcessingEnv(), (ComponentProps)props, FormFieldInfo::new, (variableElement, formFieldInfo) -> this.afterFieldBuild(props, (VariableElement)variableElement, (FormFieldInfo)formFieldInfo)));
        this.compileOnValueChange(props, compileContext);
        if (config != null) {
            this.compileComponentFields(props, config);
            this.compileSubTableRecordViewActions(props, config);
        }
        this.compileSubTableRecordActions(props, compileContext);
    }

    private void compileSubTableRecordViewActions(FormProps_AutoValue props, FormConfig config) {
        for (SubTableRecordViewAction subTableRecordViewAction : config.subTableViewActions()) {
            List<ActionInfo> actionInfoList = Arrays.stream(subTableRecordViewAction.recordActions()).map(annotation -> this.buildViewActionInfo((ViewAction)annotation, (ComponentProps)props)).collect(Collectors.toList());
            this.setFieldsSubTableRecordActionProps(props.fields(), subTableRecordViewAction.fields(), actionInfoList, 0);
        }
    }

    protected void compileSubTableRecordActions(FormProps_AutoValue props, CompileContext compileContext) {
        for (ExecutableElement method : compileContext.getMethodMap().values()) {
            SubTableRecordAction actionAnnotation = method.getAnnotation(SubTableRecordAction.class);
            if (actionAnnotation == null) continue;
            if (actionAnnotation.fields().length == 0) {
                throw new CompilerException("@SubTableRecordAction.fields cannot empty");
            }
            ApiActionInfo.ApiActionInfoBuilder builder = (ApiActionInfo.ApiActionInfoBuilder)((ApiActionInfo.ApiActionInfoBuilder)((ApiActionInfo.ApiActionInfoBuilder)((ApiActionInfo.ApiActionInfoBuilder)((ApiActionInfo.ApiActionInfoBuilder)ApiActionInfo.builder().componentKey(props.componentKey())).refresh(actionAnnotation.refresh())).confirmMessage(actionAnnotation.confirmMessage()).closePopupOnSuccess(actionAnnotation.closePopupOnSuccess())).actionName(actionAnnotation.name())).actionKey(actionAnnotation.key().isEmpty() ? method.getSimpleName().toString() : actionAnnotation.key());
            builder.uploadFileAction(method.getParameters().stream().anyMatch(param -> this.isUploadField(param.asType(), compileContext.getProcessingEnv())));
            if (method.getReturnType() != null) {
                TypeElement returnType = (TypeElement)compileContext.getProcessingEnv().getTypeUtils().asElement(method.getReturnType());
                builder.downloadFileAction(returnType != null && ElementCompileUtils.isAssignableFrom(DownloadFile.class, (TypeElement)returnType, (ProcessingEnvironment)compileContext.getProcessingEnv()));
            }
            this.setFieldsSubTableRecordActionProps(props.fields(), actionAnnotation.fields(), Collections.singletonList(builder.build()), 0);
        }
    }

    protected void setFieldsSubTableRecordActionProps(List<FormFieldInfo> fieldInfoList, String[] subTableFields, List<ActionInfo> actionInfo, int index) {
        for (FormFieldInfo fieldInfo : fieldInfoList) {
            if (!subTableFields[index].equals(fieldInfo.getDataIndex().get(0))) continue;
            if (index == subTableFields.length - 1) {
                ArrayList<ActionInfo> subTableRecordActions = fieldInfo.getSubTableRecordActions();
                if (subTableRecordActions == null) {
                    subTableRecordActions = new ArrayList<ActionInfo>();
                    fieldInfo.setSubTableRecordActions(subTableRecordActions);
                }
                subTableRecordActions.addAll(actionInfo);
                continue;
            }
            if (fieldInfo.getSubFields() != null) {
                this.setFieldsSubTableRecordActionProps(fieldInfo.getSubFields(), subTableFields, actionInfo, index + 1);
                continue;
            }
            throw new CompilerException("@SubTableRecordAction.fields cannot found model field");
        }
    }

    public String getComponentName() {
        return COMPONENT_TYPE;
    }

    protected void compileComponentFields(FormProps_AutoValue props, FormConfig formConfig) {
        HashMap<String, FieldConfigOverrideInfo> fieldConfigMap = new HashMap<String, FieldConfigOverrideInfo>();
        for (FormFieldConfig fieldConfig : formConfig.fieldsConfig()) {
            FieldConfigOverrideInfo overrideInfo;
            if (fieldConfig.field().length == 1) {
                fieldConfigMap.put(fieldConfig.field()[0], FieldConfigOverrideInfo.builder().config(fieldConfig).build());
                continue;
            }
            if (fieldConfigMap.containsKey(fieldConfig.field()[0])) {
                overrideInfo = (FieldConfigOverrideInfo)fieldConfigMap.get(fieldConfig.field()[0]);
            } else {
                overrideInfo = FieldConfigOverrideInfo.builder().subFieldsConfigMap(new HashMap()).build();
                fieldConfigMap.put(fieldConfig.field()[0], overrideInfo);
            }
            for (int i = 1; i < fieldConfig.field().length - 1; ++i) {
                if (overrideInfo.getSubFieldsConfigMap().containsKey(fieldConfig.field()[i])) {
                    overrideInfo = (FieldConfigOverrideInfo)overrideInfo.getSubFieldsConfigMap().get(fieldConfig.field()[i]);
                    continue;
                }
                FieldConfigOverrideInfo nextOverrideInfo = FieldConfigOverrideInfo.builder().subFieldsConfigMap(new HashMap()).build();
                overrideInfo.getSubFieldsConfigMap().put(fieldConfig.field()[i], nextOverrideInfo);
                overrideInfo = nextOverrideInfo;
            }
            overrideInfo.getSubFieldsConfigMap().put(fieldConfig.field()[fieldConfig.field().length - 1], FieldConfigOverrideInfo.builder().config(fieldConfig).build());
        }
        this.overrideFields(props.fields(), fieldConfigMap);
        props.fields(props.fields().stream().sorted().collect(Collectors.toList()));
    }

    private void overrideFields(Collection<FormFieldInfo> fields, Map<String, FieldConfigOverrideInfo> fieldsConfigMap) {
        for (FieldInfo fieldInfo : fields) {
            FieldConfigOverrideInfo overrideInfo;
            Optional fieldName = fieldInfo.getDataIndex().stream().findFirst();
            if (!fieldName.isPresent() || !fieldsConfigMap.containsKey(fieldName.get()) || (overrideInfo = fieldsConfigMap.get(fieldName.get())) == null) continue;
            if (overrideInfo.getConfig() != null) {
                FormFieldConfig fieldConfig = overrideInfo.getConfig();
                fieldInfo.setDisplay(fieldConfig.display());
                fieldInfo.setReadonly(fieldConfig.readonly());
                if (StringUtils.hasLength((String)fieldConfig.title())) {
                    fieldInfo.setTitle(fieldConfig.title());
                }
                fieldInfo.setOrder(fieldConfig.order());
            }
            if (CollectionUtils.isEmpty((Collection)fieldInfo.getSubFields()) || CollectionUtils.isEmpty((Map)overrideInfo.getSubFieldsConfigMap())) continue;
            this.overrideFields(fieldInfo.getSubFields(), overrideInfo.getSubFieldsConfigMap());
        }
    }

    private void afterFieldBuild(FormProps_AutoValue props, VariableElement variableElement, FormFieldInfo fieldInfo) {
        FormListConfig formListConfig;
        FormField formField = variableElement.getAnnotation(FormField.class);
        Field fieldAnnotation = variableElement.getAnnotation(Field.class);
        if (formField != null) {
            if (props.readonly() || fieldAnnotation != null && fieldAnnotation.readonly()) {
                fieldInfo.setDisplay(formField.readonlyDisplay());
            } else {
                fieldInfo.setDisplay(formField.editableDisplay());
            }
        }
        FieldDependencies fieldDependencies = variableElement.getAnnotation(FieldDependencies.class);
        FieldDependency fieldDependency = variableElement.getAnnotation(FieldDependency.class);
        if (fieldDependencies != null && fieldDependency != null) {
            String message = String.format("Form component [%s] cannot have both @FieldDependency and @FieldDependencies.", variableElement.getEnclosingElement());
            throw new CompilerException(message);
        }
        if (fieldDependencies != null) {
            fieldInfo.setConditionComposeType(fieldDependencies.composeType());
            fieldInfo.setFieldDependencyType(fieldDependencies.type());
            fieldInfo.setFieldDependencyInfoList(Arrays.stream(fieldDependencies.value()).map(this::buildFieldDependencyInfo).collect(Collectors.toList()));
        }
        if (fieldDependency != null) {
            fieldInfo.setFieldDependencyType(fieldDependency.type());
            fieldInfo.setFieldDependencyInfoList(Collections.singletonList(this.buildFieldDependencyInfo(fieldDependency)));
        }
        if ((formListConfig = variableElement.getAnnotation(FormListConfig.class)) != null) {
            fieldInfo.setSubTableCreatorButtonText(formListConfig.creatorButtonText());
        }
    }

    private FieldDependencyInfo buildFieldDependencyInfo(FieldDependency fieldDependency) {
        return FieldDependencyInfo.builder().field(fieldDependency.field()).value(fieldDependency.value()).condition(fieldDependency.condition()).build();
    }

    private void compileOnValueChange(FormProps_AutoValue props, CompileContext compileContext) {
        List valueChangeHandlers = compileContext.getMethodMap().values().stream().map(this::buildValueChangeHandlerInfo).filter(Objects::nonNull).collect(Collectors.toList());
        List allWatchFields = valueChangeHandlers.stream().flatMap(info -> Arrays.stream(info.getWatchFields())).collect(Collectors.toList());
        if ((long)allWatchFields.size() != allWatchFields.stream().distinct().count()) {
            String message = String.format("Form component [%s] @ValueChangeHandler has duplicate watchFields.", compileContext.getComponentElement().getQualifiedName());
            throw new CompilerException(message);
        }
        props.valueChangeHandlers(valueChangeHandlers);
    }

    private ValueChangeHandlerInfo buildValueChangeHandlerInfo(ExecutableElement method) {
        ValueChangeHandler actionAnnotation = method.getAnnotation(ValueChangeHandler.class);
        if (actionAnnotation == null) {
            return null;
        }
        return ValueChangeHandlerInfo.builder().watchFields(actionAnnotation.watchFields()).handlerKey(method.getSimpleName().toString()).build();
    }
}

