/*
 * Decompiled with CFR 0.152.
 */
package dev.fastball.ui.components.compiler.layout;

import com.google.auto.service.AutoService;
import dev.fastball.compile.AbstractComponentCompiler;
import dev.fastball.compile.CompileContext;
import dev.fastball.compile.ComponentCompiler;
import dev.fastball.compile.exception.CompilerException;
import dev.fastball.compile.utils.ElementCompileUtils;
import dev.fastball.meta.component.ComponentProps;
import dev.fastball.ui.components.layout.LayoutComponent;
import dev.fastball.ui.components.layout.config.GridCell;
import dev.fastball.ui.components.layout.config.GridLayout;
import dev.fastball.ui.components.layout.config.LeftAndRight;
import dev.fastball.ui.components.layout.config.LeftAndTopBottom;
import dev.fastball.ui.components.layout.config.TabItem;
import dev.fastball.ui.components.layout.config.TabsLayout;
import dev.fastball.ui.components.layout.config.TopAndBottom;
import dev.fastball.ui.components.metadata.layout.GridCellProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.GridLayoutProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.LayoutProps;
import dev.fastball.ui.components.metadata.layout.LeftAndRightLayoutProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.LeftAndTopBottomLayoutProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.TabItemProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.TabsLayoutProps_AutoValue;
import dev.fastball.ui.components.metadata.layout.TopAndBottomLayoutProps_AutoValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AutoService(value={ComponentCompiler.class})
public class LayoutCompiler
extends AbstractComponentCompiler<LayoutComponent, LayoutProps> {
    private static final String COMPONENT_TYPE = "FastballLayout";

    protected LayoutProps buildProps(CompileContext compileContext) {
        LeftAndRight leftAndRight = compileContext.getComponentElement().getAnnotation(LeftAndRight.class);
        if (leftAndRight != null) {
            LeftAndRightLayoutProps_AutoValue props = new LeftAndRightLayoutProps_AutoValue();
            props.interlocking(leftAndRight.interlocking());
            props.left(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((LeftAndRight)leftAndRight).left()));
            props.leftWidth(leftAndRight.leftWidth());
            props.right(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((LeftAndRight)leftAndRight).right()));
            return props;
        }
        TopAndBottom topAndBottom = compileContext.getComponentElement().getAnnotation(TopAndBottom.class);
        if (topAndBottom != null) {
            TopAndBottomLayoutProps_AutoValue props = new TopAndBottomLayoutProps_AutoValue();
            props.interlocking(topAndBottom.interlocking());
            props.top(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((TopAndBottom)topAndBottom).top()));
            props.bottom(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((TopAndBottom)topAndBottom).bottom()));
            return props;
        }
        LeftAndTopBottom leftAndTopBottom = compileContext.getComponentElement().getAnnotation(LeftAndTopBottom.class);
        if (leftAndTopBottom != null) {
            LeftAndTopBottomLayoutProps_AutoValue props = new LeftAndTopBottomLayoutProps_AutoValue();
            props.interlocking(leftAndTopBottom.interlocking());
            props.left(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((LeftAndTopBottom)leftAndTopBottom).left()));
            props.top(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((LeftAndTopBottom)leftAndTopBottom).top()));
            props.bottom(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((LeftAndTopBottom)leftAndTopBottom).bottom()));
            return props;
        }
        GridLayout gridLayout = compileContext.getComponentElement().getAnnotation(GridLayout.class);
        if (gridLayout != null) {
            GridLayoutProps_AutoValue props = new GridLayoutProps_AutoValue();
            List cells = Arrays.stream(gridLayout.cells()).map(cell -> {
                GridCellProps_AutoValue cellProps = new GridCellProps_AutoValue();
                cellProps.x(cell.x());
                cellProps.y(cell.y());
                cellProps.width(cell.width());
                cellProps.height(cell.height());
                cellProps.component(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((GridCell)cell).component()));
                return cellProps;
            }).collect(Collectors.toList());
            props.cells(cells);
            props.cols(gridLayout.cols());
            props.rowHeight(gridLayout.rowHeight());
            props.resizable(gridLayout.resizable());
            props.draggable(gridLayout.draggable());
            return props;
        }
        TabsLayout tabsLayout = compileContext.getComponentElement().getAnnotation(TabsLayout.class);
        if (tabsLayout != null) {
            TabsLayoutProps_AutoValue props = new TabsLayoutProps_AutoValue();
            props.defaultActiveTab(tabsLayout.defaultActiveTab());
            List items = Arrays.stream(tabsLayout.items()).map(item -> {
                TabItemProps_AutoValue tabItemProps = new TabItemProps_AutoValue();
                tabItemProps.label(item.label());
                tabItemProps.component(ElementCompileUtils.getReferencedComponentInfo((ComponentProps)props, () -> ((TabItem)item).component()));
                return tabItemProps;
            }).collect(Collectors.toList());
            props.items(items);
            return props;
        }
        String message = String.format("LayoutComponent [%s] must add annotation @LeftAndRight, @TopAndBottom, @LeftAndTopBottom or @GridLayout", compileContext.getComponentElement().getQualifiedName());
        throw new CompilerException(message);
    }

    public String getComponentName() {
        return COMPONENT_TYPE;
    }
}

