/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cicsts.ceci.manager.ivt;

import dev.galasa.Before;
import dev.galasa.BeforeClass;
import dev.galasa.Test;
import dev.galasa.cicsts.CeciException;
import dev.galasa.cicsts.CeciManagerException;
import dev.galasa.cicsts.CemtException;
import dev.galasa.cicsts.CicsRegion;
import dev.galasa.cicsts.CicsTerminal;
import dev.galasa.cicsts.CicstsManagerException;
import dev.galasa.cicsts.ICeciResponse;
import dev.galasa.cicsts.ICeciResponseOutputValue;
import dev.galasa.cicsts.ICicsRegion;
import dev.galasa.cicsts.ICicsTerminal;
import dev.galasa.cicsts.IExecInterfaceBlock;
import dev.galasa.core.manager.Logger;
import dev.galasa.zos3270.FieldNotFoundException;
import dev.galasa.zos3270.KeyboardLockedException;
import dev.galasa.zos3270.TerminalInterruptedException;
import dev.galasa.zos3270.TimeoutException;
import dev.galasa.zos3270.spi.NetworkException;
import dev.galasa.zosbatch.IZosBatch;
import dev.galasa.zosbatch.IZosBatchJob;
import dev.galasa.zosbatch.ZosBatch;
import dev.galasa.zosbatch.ZosBatchException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;

@Test
public class CECIManagerIVT {
    @Logger
    public Log logger;
    @CicsRegion(cicsTag="A")
    public ICicsRegion cics;
    @CicsTerminal(cicsTag="A")
    public ICicsTerminal ceciTerminal;
    @CicsTerminal(cicsTag="A")
    public ICicsTerminal otherTerminal;
    @ZosBatch(imageTag="PRIMARY")
    public IZosBatch batch;
    public String tsqName = "IVTQUEUE";
    public String variableName = "VARNAME";

    @BeforeClass
    public void checkCeciLoaded() throws CicstsManagerException {
        Assertions.assertThat((Object)this.cics.ceci()).isNotNull();
    }

    @Before
    public void before() throws CeciException, CicstsManagerException {
        this.cics.ceci().startCECISession(this.ceciTerminal);
    }

    @Test
    public void testStartCeciSession() throws TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException {
        this.logger.info((Object)"If the CECI session started successfully, the terminal should be able to process a CECI command");
        this.ceciTerminal.type("DEF").enter().waitForKeyboard();
        Assertions.assertThat((boolean)this.ceciTerminal.retrieveScreen().contains("ENTER ONE OF THE FOLLOWING")).isTrue();
    }

    @Test
    public void testDefineRetrieveDeleteTextVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining, retrieving then deleting the variable " + this.variableName + " using CECI"));
        String variableValue = "THIS IS A TEXT STRING";
        this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, variableValue);
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, this.variableName)).isEqualTo((Object)variableValue);
        this.cics.ceci().deleteVariable(this.ceciTerminal, this.variableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.cics.ceci().retrieveVariableText(this.ceciTerminal, this.variableName)).isInstanceOf(CeciException.class)).hasMessageContaining("Unable to find variable &" + this.variableName);
    }

    @Test
    public void testLongVariableName() throws CeciException, CicstsManagerException {
        this.logger.info((Object)"Testing that defining a variable using CECI with a name longer than 10 characters throws an exception");
        String tenCharacterName = "ABCDEFGHIJ";
        String variableValue = "THIS IS A TEXT STRING";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.cics.ceci().defineVariableText(this.ceciTerminal, tenCharacterName, variableValue)).isInstanceOf(CeciException.class)).hasMessageContaining("CECI variable name \"&ABCDEFGHIJ\" greater than maximum length of 10 characters including the leading \"&\"");
    }

    @Test
    public void testDefineTwoVariablesWithSameName() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining two variables with the name " + this.variableName + " using CECI. The value should be overwritten with the second definition"));
        String value1 = "A VALUE";
        String value2 = "A LONGER VALUE";
        int length = 0;
        length = this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, value1);
        Assertions.assertThat((int)length).isEqualTo(value1.length());
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, this.variableName)).isEqualTo((Object)value1);
        length = this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, value2);
        Assertions.assertThat((int)length).isEqualTo(value2.length());
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, this.variableName)).isEqualTo((Object)value2);
    }

    @Test
    public void testBinaryDataTypeVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining a binary variable with the name " + this.variableName));
        String variableValue = "BinaryString";
        this.cics.ceci().defineVariableBinary(this.ceciTerminal, this.variableName, variableValue.toCharArray());
        String response = new String(this.cics.ceci().retrieveVariableBinary(this.ceciTerminal, this.variableName));
        Assertions.assertThat((String)response).isEqualTo((Object)variableValue);
        this.cics.ceci().deleteVariable(this.ceciTerminal, this.variableName);
        this.logger.info((Object)"Testing that when you define a binary data type variable longer than allowed that an exception is thrown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.cics.ceci().defineVariableBinary(this.ceciTerminal, this.variableName, this.constructRandomString(32768).toCharArray())).isInstanceOf(CeciException.class)).hasMessageContaining("CECI variable value length 32768 greater than maximum 32767");
    }

    @Test
    public void testDoubleDataTypeVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining a double variable with the name " + this.variableName));
        long variableValue = Long.MAX_VALUE;
        this.cics.ceci().defineVariableDoubleWord(this.ceciTerminal, this.variableName, variableValue);
        long response = this.cics.ceci().retrieveVariableDoubleWord(this.ceciTerminal, this.variableName);
        Assertions.assertThat((long)response).isEqualTo(variableValue);
    }

    @Test
    public void testFullDataTypeVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining a full variable with the name " + this.variableName));
        int variableValue = Integer.MAX_VALUE;
        this.cics.ceci().defineVariableFullWord(this.ceciTerminal, this.variableName, variableValue);
        long response = this.cics.ceci().retrieveVariableFullWord(this.ceciTerminal, this.variableName);
        Assertions.assertThat((long)response).isEqualTo((long)variableValue);
    }

    @Test
    public void testHalfDataTypeVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining a half variable with the name " + this.variableName));
        int variableValue = Short.MAX_VALUE;
        this.cics.ceci().defineVariableHalfWord(this.ceciTerminal, this.variableName, variableValue);
        int response = this.cics.ceci().retrieveVariableHalfWord(this.ceciTerminal, this.variableName);
        Assertions.assertThat((int)response).isEqualTo(variableValue);
    }

    @Test
    public void test4BytePackedVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining a 4-byte packed variable with the name " + this.variableName));
        int variableValue = 9999999;
        this.cics.ceci().defineVariable4BytePacked(this.ceciTerminal, this.variableName, variableValue);
        int response = this.cics.ceci().retrieveVariable4BytePacked(this.ceciTerminal, this.variableName);
        Assertions.assertThat((int)response).isEqualTo(variableValue);
        this.cics.ceci().deleteVariable(this.ceciTerminal, this.variableName);
        this.logger.info((Object)"Testing that when you define a 4 byte packed data type variable longer than allowed that an exception is thrown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.cics.ceci().defineVariable4BytePacked(this.ceciTerminal, this.variableName, 10000000)).isInstanceOf(CeciException.class)).hasMessageContaining("CECI variable value length 9 greater than maximum of 8 for type \"P\"");
    }

    @Test
    public void test8BytePackedVariable() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Defining an 8-byte packed variable with the name " + this.variableName));
        long variableValue = 999999999999999L;
        this.cics.ceci().defineVariable8BytePacked(this.ceciTerminal, this.variableName, variableValue);
        long response = this.cics.ceci().retrieveVariable8BytePacked(this.ceciTerminal, this.variableName);
        Assertions.assertThat((long)response).isEqualTo(variableValue);
        this.cics.ceci().deleteVariable(this.ceciTerminal, this.variableName);
        this.logger.info((Object)"Testing that when you define an 8 byte packed data type variable longer than allowed that an exception is thrown");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.cics.ceci().defineVariable8BytePacked(this.ceciTerminal, this.variableName, 1000000000000000L)).isInstanceOf(CeciException.class)).hasMessageContaining("CECI variable value length 17 greater than maximum of 16 for type \"D\"");
    }

    @Test
    public void testCommand() throws CeciException, CicstsManagerException {
        String userVariable = this.variableName;
        String ceciCommand = "ASSIGN USERID(&" + userVariable + ")";
        this.cics.ceci().issueCommand(this.ceciTerminal, ceciCommand, false);
        String user = this.cics.ceci().retrieveVariableText(this.ceciTerminal, userVariable);
        Assertions.assertThat((String)user).isEqualTo((Object)"CICSUSER");
    }

    @Test
    public void testDocumentationCommand() throws CeciException, CicstsManagerException, ZosBatchException {
        String message = "GALASA TEST " + Instant.now().toString();
        String ceciCommand = "EXEC CICS WRITE OPERATOR TEXT('" + message + "')";
        ICeciResponse resp = this.cics.ceci().issueCommand(this.ceciTerminal, ceciCommand);
        Assertions.assertThat((boolean)resp.isNormal()).isTrue();
        this.logger.info((Object)"Checking that the message was written to the CICS log");
        boolean messageFound = false;
        List jobs = this.batch.getJobs(this.cics.getApplid(), "*");
        for (IZosBatchJob job : jobs) {
            String output = job.getSpoolFile("JESMSGLG").getRecords();
            if (!output.contains(message)) continue;
            messageFound = true;
            break;
        }
        Assertions.assertThat((boolean)messageFound).isTrue();
    }

    @Test
    public void testCommandWithOptions() throws CeciException, CicstsManagerException {
        this.logger.info((Object)("Putting and getting data from a container into variable " + this.variableName));
        String ceciCommand = "PUT";
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("CONTAINER", "FRED");
        options.put("CHANNEL", "FRED");
        options.put("FROM", "'HELLO'");
        ICeciResponse resp = this.cics.ceci().issueCommand(this.ceciTerminal, ceciCommand, options);
        Assertions.assertThat((boolean)resp.isNormal()).isTrue();
        ceciCommand = "GET";
        options.clear();
        options.put("CONTAINER", "FRED");
        options.put("CHANNEL", "FRED");
        options.put("INTO", "&" + this.variableName);
        resp = this.cics.ceci().issueCommand(this.ceciTerminal, ceciCommand, options);
        Assertions.assertThat((boolean)resp.isNormal()).isTrue();
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, this.variableName)).isEqualTo((Object)"HELLO");
    }

    @Test
    public void testWriteToTSQ() throws CeciException, CicstsManagerException, TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException {
        this.logger.info((Object)("Testing writing data to a Temporary Storage Queue called " + this.tsqName + " from variable " + this.variableName));
        String dataToWrite = "THIS IS A GALASA TEST";
        this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, dataToWrite);
        String command = "WRITEQ TS QUEUE('" + this.tsqName + "') FROM(&" + this.variableName + ")";
        this.cics.ceci().issueCommand(this.ceciTerminal, command);
        this.otherTerminal.type("CEBR " + this.tsqName).enter().waitForKeyboard();
        Assertions.assertThat((String)this.otherTerminal.retrieveScreen()).containsIgnoringCase((CharSequence)dataToWrite);
        this.otherTerminal.pf3().waitForKeyboard();
        command = "DELETEQ TS QUEUE('" + this.tsqName + "')";
        this.cics.ceci().issueCommand(this.ceciTerminal, command);
        this.otherTerminal.type("CEBR " + this.tsqName).enter().waitForKeyboard();
        Assertions.assertThat((boolean)this.otherTerminal.retrieveScreen().contains("DOES NOT EXIST")).isTrue();
        this.otherTerminal.resetAndClear();
    }

    @Test
    public void testPutAndGetDataFromContainer() throws CeciException, CicstsManagerException, TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException {
        String programName = "CONTTEST";
        String channelName = "MY-CHANNEL";
        String containerName = "HOBBIT";
        String content = "my-content";
        this.logger.info((Object)("Linking program " + programName + " to channel " + channelName + " then putting the output into variable " + this.variableName));
        int programUseCountBefore = Integer.parseInt((String)this.cics.cemt().inquireResource(this.otherTerminal, "PROGRAM", programName).get((Object)"usecount"));
        Assertions.assertThat((int)programUseCountBefore).isZero();
        this.otherTerminal.setUppercaseTranslation(false);
        ICeciResponse resp = this.cics.ceci().putContainer(this.ceciTerminal, channelName, containerName, content, null, null, null);
        resp.checkNormal();
        resp = this.cics.ceci().linkProgramWithChannel(this.ceciTerminal, programName, channelName, null, null, false);
        resp.checkNormal();
        resp = this.cics.ceci().getContainer(this.ceciTerminal, channelName, containerName, this.variableName, null, null);
        resp.checkNormal();
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, "&" + this.variableName)).isUpperCase();
        Assertions.assertThat((String)this.cics.ceci().retrieveVariableText(this.ceciTerminal, "&" + this.variableName)).startsWith((CharSequence)content.toUpperCase());
        int programUseCountAfter = Integer.parseInt((String)this.cics.cemt().inquireResource(this.otherTerminal, "PROGRAM", programName).get((Object)"usecount"));
        Assertions.assertThat((int)programUseCountAfter).isEqualTo(1);
    }

    @Test
    public void testLinkToProgramToCommarea() throws CeciException, CicstsManagerException {
        String programName = "APITEST";
        String variableValue = "galasa";
        this.logger.info((Object)("Linking program " + programName + " to variable " + this.variableName));
        this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, variableValue);
        ICeciResponse resp = this.cics.ceci().linkProgram(this.ceciTerminal, programName, "&" + this.variableName, null, null, false);
        Assertions.assertThat((int)resp.getEIBRESP()).isZero();
        String outputData = this.cics.ceci().retrieveVariableText(this.ceciTerminal, "&" + this.variableName);
        Assertions.assertThat((String)outputData).isUpperCase();
        Assertions.assertThat((String)outputData).startsWith((CharSequence)variableValue.toUpperCase());
        Map respOutputValues = resp.getResponseOutputValues();
        Assertions.assertThat((String)((ICeciResponseOutputValue)respOutputValues.get("PROGRAM")).getTextValue().trim()).isEqualTo((Object)"APITEST");
        Assertions.assertThat((String)((ICeciResponseOutputValue)respOutputValues.get("COMMAREA")).getTextValue().trim()).isEqualTo((Object)"GALASA");
    }

    @Test
    public void testGetEIBFields() throws CeciException, CicstsManagerException, TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException {
        int second;
        int minute;
        int hour;
        this.logger.info((Object)"Testing that fields from the Exec Interface Block are retrieved correctly, first testing on a good command");
        ICeciResponse resp = this.cics.ceci().issueCommand(this.ceciTerminal, "PUT CONTAINER(BOB) CHANNEL(BOB) FROM('HELLO')");
        IExecInterfaceBlock eib = this.cics.ceci().getEIB(this.ceciTerminal);
        Assertions.assertThat((String)eib.getResponse()).isEqualTo((Object)"NORMAL");
        Assertions.assertThat((int)eib.getEIBRESP()).isEqualTo(0);
        Assertions.assertThat((int)eib.getEIBRESP2()).isEqualTo(0);
        Assertions.assertThat((String)resp.getResponse()).isEqualTo((Object)"NORMAL");
        Assertions.assertThat((int)resp.getEIBRESP()).isEqualTo(0);
        Assertions.assertThat((int)resp.getEIBRESP2()).isEqualTo(0);
        Assertions.assertThat((String)eib.getEIBTRNID(false)).isEqualTo((Object)"CECI");
        int expectedEIBDate = this.getExpectedEIBDate();
        Assertions.assertThat((int)eib.getEIBDATE()).isEqualTo(expectedEIBDate);
        Assertions.assertThat((int)eib.getEIBTIME()).isNotNull();
        String eibTimeString = Integer.toString(eib.getEIBTIME());
        if (eibTimeString.length() == 5) {
            hour = Integer.parseInt(eibTimeString.substring(0, 1));
            minute = Integer.parseInt(eibTimeString.substring(1, 3));
            second = Integer.parseInt(eibTimeString.substring(3));
        } else {
            hour = Integer.parseInt(eibTimeString.substring(0, 2));
            minute = Integer.parseInt(eibTimeString.substring(2, 4));
            second = Integer.parseInt(eibTimeString.substring(4));
        }
        Assertions.assertThat((hour >= 0 && hour <= 23 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((minute >= 0 && minute <= 59 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((second >= 0 && second <= 59 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)eib.getEIBCALEN()).isEqualTo(0);
        Assertions.assertThat((char)eib.getEIBAID()).isNotNull();
        Assertions.assertThat((int)eib.getEIBCPOSN()).isNotNull();
        Assertions.assertThat((String)eib.getEIBDS(false)).isNotNull();
        Assertions.assertThat((String)eib.getEIBREQID(false)).isNotNull();
        Assertions.assertThat((int)eib.getEIBTASKN()).isNotNull();
        Assertions.assertThat((String)eib.getEIBTRMID(false)).isNotNull();
        this.logger.info((Object)"Testing the EIB fields on a bad command - linking to a program that doesn't exist");
        resp = this.cics.ceci().linkProgramWithChannel(this.ceciTerminal, "NOEXIST", "MY-CHANNEL", null, null, false);
        eib = this.cics.ceci().getEIB(this.ceciTerminal);
        Assertions.assertThat((String)eib.getResponse()).isEqualTo((Object)"PGMIDERR");
        Assertions.assertThat((int)eib.getEIBRESP()).isEqualTo(27);
        Assertions.assertThat((int)eib.getEIBRESP2()).isEqualTo(1);
        Assertions.assertThat((String)resp.getResponse()).isEqualTo((Object)"PGMIDERR");
        Assertions.assertThat((int)resp.getEIBRESP()).isEqualTo(27);
        Assertions.assertThat((int)resp.getEIBRESP2()).isEqualTo(1);
    }

    @Test
    public void testAbendResponse() throws CeciException, CicstsManagerException, TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException {
        String programName = "PRGABEND";
        String variableValue = "galasa";
        this.logger.info((Object)"Testing that an abend response is picked up by CECI");
        this.cics.ceci().defineVariableText(this.ceciTerminal, this.variableName, variableValue);
        ICeciResponse resp = this.cics.ceci().linkProgram(this.ceciTerminal, programName, "&" + this.variableName, null, null, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> resp.checkNotAbended()).isInstanceOf(CeciManagerException.class)).hasMessageContaining("CECI response is an abend");
        Assertions.assertThat((Object)resp.checkAbended(null)).isInstanceOf(ICeciResponse.class);
    }

    private int getExpectedEIBDate() throws TimeoutException, KeyboardLockedException, TerminalInterruptedException, NetworkException, FieldNotFoundException, CicstsManagerException {
        this.otherTerminal.clear().waitForKeyboard();
        this.otherTerminal.type("CEMT INQUIRE SYSTEM").enter().waitForKeyboard();
        String screen = this.otherTerminal.retrieveScreen();
        if (!screen.contains("DATE:")) {
            throw new CemtException("CEMT INQUIRE SYSTEM did not navigate to correct screen");
        }
        this.otherTerminal.resetAndClear();
        String dateString = screen.substring(screen.lastIndexOf("DATE: ") + 6, screen.lastIndexOf("DATE: ") + 14);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/yy");
        LocalDate date = LocalDate.parse(dateString, formatter);
        String expectedEIBDate = (date.getYear() <= 1999 ? "0" : "1") + Integer.toString(date.getYear()).substring(2) + (Serializable)(date.getDayOfYear() <= 99 ? (date.getDayOfYear() <= 9 ? "00" + date.getDayOfYear() : "0" + date.getDayOfYear()) : Integer.valueOf(date.getDayOfYear()));
        return Integer.parseInt(expectedEIBDate);
    }

    private String constructRandomString(int length) {
        String alphabet = "abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder();
        SecureRandom r = new SecureRandom();
        for (int a = 0; a < length; ++a) {
            sb.append(alphabet.charAt(r.nextInt(26)));
        }
        return sb.toString();
    }
}

