/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import dev.galasa.cps.etcd.internal.Etcd3ConfigurationPropertyStore;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import dev.galasa.framework.spi.IConfigurationPropertyStoreRegistration;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IConfigurationPropertyStoreRegistration.class})
public class Etcd3ConfigurationPropertyRegistration
implements IConfigurationPropertyStoreRegistration {
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws ConfigurationPropertyStoreException {
        URI cps = frameworkInitialisation.getBootstrapConfigurationPropertyStore();
        if (Etcd3ConfigurationPropertyRegistration.isEtcdUri(cps)) {
            try {
                URI uri = new URI(cps.toString().replace("etcd:", ""));
                frameworkInitialisation.registerConfigurationPropertyStore((IConfigurationPropertyStore)new Etcd3ConfigurationPropertyStore(uri));
            }
            catch (URISyntaxException e) {
                throw new ConfigurationPropertyStoreException("Could not create URI", (Throwable)e);
            }
        }
    }

    public static boolean isEtcdUri(URI uri) {
        return "etcd".equals(uri.getScheme());
    }
}

