/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import com.google.common.base.Charsets;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

public class Etcd3ConfigurationPropertyStore
implements IConfigurationPropertyStore {
    private final Client client;
    private final KV kvClient;

    public Etcd3ConfigurationPropertyStore(URI cpsUri) {
        this.client = Client.builder().endpoints(new URI[]{cpsUri}).build();
        this.kvClient = this.client.getKVClient();
    }

    @Null
    public String getProperty(@NotNull String key) throws ConfigurationPropertyStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        CompletableFuture getFuture = this.kvClient.get(bsKey);
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            if (kvs.isEmpty()) {
                return null;
            }
            return ((KeyValue)kvs.get(0)).getValue().toString(Charsets.UTF_8);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationPropertyStoreException("Could not retrieve key, interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationPropertyStoreException("Could not retrieve key", (Throwable)e);
        }
    }

    @NotNull
    public Map<String, String> getPrefixedProperties(@NotNull String prefix) throws ConfigurationPropertyStoreException {
        HashMap<String, String> returnValues = new HashMap<String, String>();
        ByteSequence bsKey = ByteSequence.from((String)prefix, (Charset)Charsets.UTF_8);
        GetOption option = GetOption.newBuilder().withPrefix(bsKey).build();
        CompletableFuture getFuture = this.kvClient.get(bsKey, option);
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            for (KeyValue kv : kvs) {
                returnValues.put(kv.getKey().toString(Charsets.UTF_8), kv.getValue().toString(Charsets.UTF_8));
            }
            return returnValues;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationPropertyStoreException("Could not retrieve key, interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationPropertyStoreException("Could not retrieve key", (Throwable)e);
        }
    }

    public void shutdown() throws ConfigurationPropertyStoreException {
        this.kvClient.close();
        this.client.close();
    }

    public void setProperty(@NotNull String key, @NotNull String value) throws ConfigurationPropertyStoreException {
        ByteSequence bytesKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        ByteSequence bytesValue = ByteSequence.from((String)value, (Charset)Charsets.UTF_8);
        try {
            this.kvClient.put(bytesKey, bytesValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationPropertyStoreException("Could not set key and value.", (Throwable)e);
        }
    }

    public Map<String, String> getPropertiesFromNamespace(String namespace) {
        ByteSequence bsNamespace = ByteSequence.from((String)(namespace + "."), (Charset)Charsets.UTF_8);
        GetOption option = GetOption.newBuilder().withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.DESCEND).withRange(bsNamespace).withPrefix(ByteSequence.from((String)(namespace + "."), (Charset)Charsets.UTF_8)).build();
        CompletableFuture futureResponse = this.client.getKVClient().get(bsNamespace, option);
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            GetResponse response = (GetResponse)futureResponse.get();
            List kvs = response.getKvs();
            for (KeyValue kv : kvs) {
                results.put(kv.getKey().toString(Charsets.UTF_8), kv.getValue().toString(Charsets.UTF_8));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        return results;
    }

    public List<String> getNamespaces() {
        ByteSequence empty = ByteSequence.from((String)"\u0000", (Charset)Charsets.UTF_8);
        GetOption option = GetOption.newBuilder().withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.DESCEND).withRange(empty).build();
        CompletableFuture futureResponse = this.client.getKVClient().get(empty, option);
        ArrayList<String> results = new ArrayList<String>();
        try {
            GetResponse response = (GetResponse)futureResponse.get();
            List kvs = response.getKvs();
            for (KeyValue kv : kvs) {
                String key = kv.getKey().toString(Charsets.UTF_8);
                if (results.contains(key = key.substring(0, key.indexOf(".")))) continue;
                results.add(key);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
        }
        return results;
    }
}

