/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import com.google.common.base.Charsets;
import dev.galasa.ICredentials;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.CredentialsToken;
import dev.galasa.framework.spi.creds.CredentialsUsername;
import dev.galasa.framework.spi.creds.CredentialsUsernamePassword;
import dev.galasa.framework.spi.creds.CredentialsUsernameToken;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.crypto.spec.SecretKeySpec;

public class Etcd3CredentialsStore
implements ICredentialsStore {
    private final Client client;
    private final KV kvClient;
    private final SecretKeySpec key;

    public Etcd3CredentialsStore(IFramework framework, URI etcd) throws CredentialsException {
        try {
            this.client = Client.builder().endpoints(new URI[]{etcd}).build();
            this.kvClient = this.client.getKVClient();
            IConfigurationPropertyStoreService cpsService = framework.getConfigurationPropertyService("secure");
            String encryptionKey = cpsService.getProperty("credentials.file", "encryption.key", new String[0]);
            this.key = encryptionKey != null ? Etcd3CredentialsStore.createKey(encryptionKey) : null;
        }
        catch (Exception e) {
            throw new CredentialsException("Unable to initialise the etcd credentials store", (Throwable)e);
        }
    }

    public ICredentials getCredentials(String credentialsId) throws CredentialsException {
        String token = this.get("secure.credentials." + credentialsId + ".token");
        if (token != null) {
            String username = this.get("secure.credentials." + credentialsId + ".username");
            if (username != null) {
                return new CredentialsUsernameToken(this.key, username, token);
            }
            return new CredentialsToken(this.key, token);
        }
        String username = this.get("secure.credentials." + credentialsId + ".username");
        String password = this.get("secure.credentials." + credentialsId + ".password");
        if (username == null) {
            return null;
        }
        if (password == null) {
            return new CredentialsUsername(this.key, username);
        }
        return new CredentialsUsernamePassword(this.key, username, password);
    }

    private String get(String key) throws CredentialsException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        CompletableFuture getFuture = this.kvClient.get(bsKey);
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            if (kvs.isEmpty()) {
                return null;
            }
            return ((KeyValue)kvs.get(0)).getValue().toString(Charsets.UTF_8);
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new CredentialsException("Could not retrieve key.", (Throwable)e);
        }
    }

    private static SecretKeySpec createKey(String secret) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] key = secret.getBytes("UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        return new SecretKeySpec(key, "AES");
    }

    public void shutdown() throws CredentialsException {
        this.kvClient.close();
        this.client.close();
    }
}

