/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import dev.galasa.cps.etcd.internal.Etcd3CredentialsStore;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import dev.galasa.framework.spi.creds.ICredentialsStoreRegistration;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ICredentialsStoreRegistration.class})
public class Etcd3CredentialsStoreRegistration
implements ICredentialsStoreRegistration {
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws CredentialsException {
        URI creds = frameworkInitialisation.getCredentialsStoreUri();
        if (Etcd3CredentialsStoreRegistration.isEtcdUri(creds)) {
            try {
                URI uri = new URI(creds.toString().replace("etcd:", ""));
                frameworkInitialisation.registerCredentialsStore((ICredentialsStore)new Etcd3CredentialsStore(frameworkInitialisation.getFramework(), uri));
            }
            catch (URISyntaxException e) {
                throw new CredentialsException("Could not find etcd creds store", (Throwable)e);
            }
        }
    }

    public static boolean isEtcdUri(URI uri) {
        return "etcd".equals(uri.getScheme());
    }
}

