/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import com.google.common.base.Charsets;
import dev.galasa.framework.spi.DssAdd;
import dev.galasa.framework.spi.DssDelete;
import dev.galasa.framework.spi.DssDeletePrefix;
import dev.galasa.framework.spi.DssSwap;
import dev.galasa.framework.spi.DssUpdate;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreWatcher;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.validation.constraints.NotNull;

public class Etcd3DynamicStatusStore
implements IDynamicStatusStore {
    private final Client client;
    private final KV kvClient;
    private final Watch watchClient;
    private final HashMap<UUID, PassthroughWatcher> watchers = new HashMap();

    public Etcd3DynamicStatusStore(URI dssUri) {
        this.client = Client.builder().endpoints(new URI[]{dssUri}).build();
        this.kvClient = this.client.getKVClient();
        this.watchClient = this.client.getWatchClient();
    }

    public void put(@NotNull String key, @NotNull String value) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        ByteSequence bsValue = ByteSequence.from((String)value, (Charset)Charsets.UTF_8);
        CompletableFuture response = this.kvClient.put(bsKey, bsValue);
        try {
            response.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not put key-value", (Throwable)e);
        }
    }

    public void put(@NotNull Map<String, String> keyValues) throws DynamicStatusStoreException {
        Txn txn = this.kvClient.txn();
        PutOption options = PutOption.DEFAULT;
        ArrayList<Op.PutOp> ops = new ArrayList<Op.PutOp>();
        for (String key : keyValues.keySet()) {
            ByteSequence obsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
            ByteSequence obsValue = ByteSequence.from((String)keyValues.get(key), (Charset)Charsets.UTF_8);
            ops.add(Op.put((ByteSequence)obsKey, (ByteSequence)obsValue, (PutOption)options));
        }
        Txn request = txn.Then(ops.toArray(new Op[ops.size()]));
        CompletableFuture response = request.commit();
        try {
            response.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("", (Throwable)e);
        }
    }

    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        ByteSequence bsNewValue = ByteSequence.from((String)newValue, (Charset)Charsets.UTF_8);
        Txn txn = this.kvClient.txn();
        Cmp cmp = null;
        if (oldValue == null) {
            cmp = new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L));
        } else {
            ByteSequence bsOldValue = ByteSequence.from((String)oldValue, (Charset)Charsets.UTF_8);
            cmp = new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)bsOldValue));
        }
        PutOption option = PutOption.DEFAULT;
        Txn check = txn.If(new Cmp[]{cmp});
        Txn request = check.Then(new Op[]{Op.put((ByteSequence)bsKey, (ByteSequence)bsNewValue, (PutOption)option)});
        CompletableFuture response = request.commit();
        try {
            return ((TxnResponse)response.get()).isSucceeded();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Put Swap failed", (Throwable)e);
        }
    }

    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue, @NotNull Map<String, String> others) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        ByteSequence bsNewValue = ByteSequence.from((String)newValue, (Charset)Charsets.UTF_8);
        Txn txn = this.kvClient.txn();
        Cmp cmp = null;
        if (oldValue == null) {
            cmp = new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L));
        } else {
            ByteSequence bsOldValue = ByteSequence.from((String)oldValue, (Charset)Charsets.UTF_8);
            cmp = new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)bsOldValue));
        }
        ArrayList<Op.PutOp> ops = new ArrayList<Op.PutOp>();
        PutOption option = PutOption.DEFAULT;
        ops.add(Op.put((ByteSequence)bsKey, (ByteSequence)bsNewValue, (PutOption)option));
        for (Map.Entry<String, String> entry : others.entrySet()) {
            ByteSequence obsKey = ByteSequence.from((String)entry.getKey(), (Charset)Charsets.UTF_8);
            ByteSequence obsValue = ByteSequence.from((String)entry.getValue(), (Charset)Charsets.UTF_8);
            ops.add(Op.put((ByteSequence)obsKey, (ByteSequence)obsValue, (PutOption)option));
        }
        CompletableFuture response = txn.If(new Cmp[]{cmp}).Then(ops.toArray(new Op[ops.size()])).commit();
        try {
            return ((TxnResponse)response.get()).isSucceeded();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Put Swap failed", (Throwable)e);
        }
    }

    public String get(@NotNull String key) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        CompletableFuture getFuture = this.kvClient.get(bsKey);
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            if (kvs.isEmpty()) {
                return null;
            }
            return ((KeyValue)kvs.get(0)).getValue().toString(Charsets.UTF_8);
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not retrieve key.", (Throwable)e);
        }
    }

    @NotNull
    public Map<String, String> getPrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        ByteSequence bsPrefix = ByteSequence.from((String)keyPrefix, (Charset)Charsets.UTF_8);
        GetOption options = GetOption.newBuilder().withPrefix(bsPrefix).build();
        CompletableFuture getFuture = this.kvClient.get(bsPrefix, options);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        try {
            GetResponse response = (GetResponse)getFuture.get();
            List kvs = response.getKvs();
            if (kvs.isEmpty()) {
                return new HashMap<String, String>();
            }
            for (KeyValue kv : kvs) {
                keyValues.put(kv.getKey().toString(Charsets.UTF_8), kv.getValue().toString(Charsets.UTF_8));
            }
            return keyValues;
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not retrieve key.", (Throwable)e);
        }
    }

    public void delete(@NotNull String key) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        CompletableFuture deleteFuture = this.kvClient.delete(bsKey);
        try {
            deleteFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not delete key.", (Throwable)e);
        }
    }

    public void delete(@NotNull Set<String> keys) throws DynamicStatusStoreException {
        Txn txn = this.kvClient.txn();
        DeleteOption options = DeleteOption.DEFAULT;
        ArrayList<Op.DeleteOp> ops = new ArrayList<Op.DeleteOp>();
        for (String key : keys) {
            ByteSequence obsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
            ops.add(Op.delete((ByteSequence)obsKey, (DeleteOption)options));
        }
        CompletableFuture response = txn.Then(ops.toArray(new Op[ops.size()])).commit();
        try {
            response.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not delete key(s).", (Throwable)e);
        }
    }

    public void deletePrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)keyPrefix, (Charset)Charsets.UTF_8);
        DeleteOption options = DeleteOption.newBuilder().withPrefix(bsKey).build();
        CompletableFuture deleteFuture = this.kvClient.delete(bsKey, options);
        try {
            deleteFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("Could not delete key(s).", (Throwable)e);
        }
    }

    public UUID watch(IDynamicStatusStoreWatcher watcher, String key) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)key, (Charset)Charsets.UTF_8);
        PassthroughWatcher passWatcher = new PassthroughWatcher(watcher);
        passWatcher.setEtcdWatcher(this.watchClient.watch(bsKey, (Watch.Listener)passWatcher));
        this.watchers.put(passWatcher.getID(), passWatcher);
        return passWatcher.getID();
    }

    public UUID watchPrefix(IDynamicStatusStoreWatcher watcher, String keyPrefix) throws DynamicStatusStoreException {
        ByteSequence bsKey = ByteSequence.from((String)keyPrefix, (Charset)Charsets.UTF_8);
        PassthroughWatcher passWatcher = new PassthroughWatcher(watcher);
        WatchOption watchOption = WatchOption.newBuilder().withPrefix(bsKey).build();
        Watch.Watcher etcdWatcher = this.watchClient.watch(bsKey, watchOption, (Watch.Listener)passWatcher);
        passWatcher.setEtcdWatcher(etcdWatcher);
        this.watchers.put(passWatcher.getID(), passWatcher);
        return passWatcher.getID();
    }

    public void unwatch(UUID watchId) throws DynamicStatusStoreException {
        PassthroughWatcher passWatcher = this.watchers.remove(watchId);
        if (passWatcher == null) {
            return;
        }
        passWatcher.getEtcdWatcher().close();
    }

    public void shutdown() throws DynamicStatusStoreException {
        this.watchClient.close();
        this.kvClient.close();
        this.client.close();
    }

    public void performActions(IDssAction ... actions) throws DynamicStatusStoreException {
        Txn txn = this.kvClient.txn();
        for (IDssAction action : actions) {
            if (action instanceof DssAdd) {
                txn = this.performActionsAddIf(txn, (DssAdd)action);
                continue;
            }
            if (action instanceof DssDelete) {
                txn = this.performActionsDeleteIf(txn, (DssDelete)action);
                continue;
            }
            if (action instanceof DssDeletePrefix) {
                txn = this.performActionsDeletePrefixIf(txn, (DssDeletePrefix)action);
                continue;
            }
            if (action instanceof DssUpdate) {
                txn = this.performActionsUpdateIf(txn, (DssUpdate)action);
                continue;
            }
            if (action instanceof DssSwap) {
                txn = this.performActionsSwapIf(txn, (DssSwap)action);
                continue;
            }
            throw new DynamicStatusStoreException("Unrecognised DSS Action - " + action.getClass().getName());
        }
        for (IDssAction action : actions) {
            if (action instanceof DssAdd) {
                txn = this.performActionsAddThen(txn, (DssAdd)action);
                continue;
            }
            if (action instanceof DssDelete) {
                txn = this.performActionsDeleteThen(txn, (DssDelete)action);
                continue;
            }
            if (action instanceof DssDeletePrefix) {
                txn = this.performActionsDeletePrefixThen(txn, (DssDeletePrefix)action);
                continue;
            }
            if (action instanceof DssUpdate) {
                txn = this.performActionsUpdateThen(txn, (DssUpdate)action);
                continue;
            }
            if (action instanceof DssSwap) {
                txn = this.performActionsSwapThen(txn, (DssSwap)action);
                continue;
            }
            throw new DynamicStatusStoreException("Unrecognised DSS Action - " + action.getClass().getName());
        }
        CompletableFuture response = txn.commit();
        try {
            if (!((TxnResponse)response.get()).isSucceeded()) {
                throw new DynamicStatusStoreException("DSS transaction failed");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new DynamicStatusStoreException("DSS transaction failed", (Throwable)e);
        }
    }

    private Txn performActionsAddIf(Txn txn, DssAdd action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        txn = txn.If(new Cmp[]{new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L))});
        return txn;
    }

    private Txn performActionsAddThen(Txn txn, DssAdd action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        ByteSequence bsNewValue = ByteSequence.from((String)action.getValue(), (Charset)Charsets.UTF_8);
        PutOption option = PutOption.DEFAULT;
        txn = txn.Then(new Op[]{Op.put((ByteSequence)bsKey, (ByteSequence)bsNewValue, (PutOption)option)});
        return txn;
    }

    private Txn performActionsUpdateIf(Txn txn, DssUpdate action) {
        return txn;
    }

    private Txn performActionsUpdateThen(Txn txn, DssUpdate action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        ByteSequence bsNewValue = ByteSequence.from((String)action.getValue(), (Charset)Charsets.UTF_8);
        PutOption option = PutOption.DEFAULT;
        txn = txn.Then(new Op[]{Op.put((ByteSequence)bsKey, (ByteSequence)bsNewValue, (PutOption)option)});
        return txn;
    }

    private Txn performActionsSwapIf(Txn txn, DssSwap action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        ByteSequence bsOldValue = ByteSequence.from((String)action.getOldValue(), (Charset)Charsets.UTF_8);
        txn = txn.If(new Cmp[]{new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)bsOldValue))});
        return txn;
    }

    private Txn performActionsSwapThen(Txn txn, DssSwap action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        ByteSequence bsNewValue = ByteSequence.from((String)action.getNewValue(), (Charset)Charsets.UTF_8);
        PutOption option = PutOption.DEFAULT;
        txn = txn.Then(new Op[]{Op.put((ByteSequence)bsKey, (ByteSequence)bsNewValue, (PutOption)option)});
        return txn;
    }

    private Txn performActionsDeleteIf(Txn txn, DssDelete action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        if (action.getOldValue() != null) {
            ByteSequence bsOldValue = ByteSequence.from((String)action.getOldValue(), (Charset)Charsets.UTF_8);
            txn = txn.If(new Cmp[]{new Cmp(bsKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteSequence)bsOldValue))});
        }
        return txn;
    }

    private Txn performActionsDeleteThen(Txn txn, DssDelete action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getKey(), (Charset)Charsets.UTF_8);
        DeleteOption option = DeleteOption.DEFAULT;
        txn = txn.Then(new Op[]{Op.delete((ByteSequence)bsKey, (DeleteOption)option)});
        return txn;
    }

    private Txn performActionsDeletePrefixIf(Txn txn, DssDeletePrefix action) {
        return txn;
    }

    private Txn performActionsDeletePrefixThen(Txn txn, DssDeletePrefix action) {
        ByteSequence bsKey = ByteSequence.from((String)action.getPrefix(), (Charset)Charsets.UTF_8);
        DeleteOption option = DeleteOption.newBuilder().withPrefix(bsKey).build();
        txn = txn.Then(new Op[]{Op.delete((ByteSequence)bsKey, (DeleteOption)option)});
        return txn;
    }

    private class PassthroughWatcher
    implements Watch.Listener {
        private final UUID id = UUID.randomUUID();
        private final IDynamicStatusStoreWatcher watcher;
        private Watch.Watcher etcdWatcher;

        public PassthroughWatcher(IDynamicStatusStoreWatcher watcher) {
            this.watcher = watcher;
        }

        public void onNext(WatchResponse response) {
            if (response == null) {
                return;
            }
            List events = response.getEvents();
            if (events == null) {
                return;
            }
            block4: for (WatchEvent event : events) {
                WatchEvent.EventType eventType = event.getEventType();
                KeyValue eventKey = event.getKeyValue();
                KeyValue eventPrev = event.getPrevKV();
                if (eventType == null || eventKey == null) continue;
                switch (eventType) {
                    case DELETE: {
                        this.watcher.propertyModified(eventKey.getKey().toString(Charsets.UTF_8), IDynamicStatusStoreWatcher.Event.DELETE, null, null);
                        continue block4;
                    }
                    case PUT: {
                        if (eventPrev != null) {
                            this.watcher.propertyModified(eventKey.getKey().toString(Charsets.UTF_8), IDynamicStatusStoreWatcher.Event.MODIFIED, eventPrev.getValue().toString(Charsets.UTF_8), eventKey.getValue().toString(Charsets.UTF_8));
                            continue block4;
                        }
                        this.watcher.propertyModified(eventKey.getKey().toString(Charsets.UTF_8), IDynamicStatusStoreWatcher.Event.NEW, null, eventKey.getValue().toString(Charsets.UTF_8));
                        continue block4;
                    }
                }
            }
        }

        public void onError(Throwable throwable) {
        }

        public void onCompleted() {
        }

        public UUID getID() {
            return this.id;
        }

        public void setEtcdWatcher(Watch.Watcher etcdWatcher) {
            this.etcdWatcher = etcdWatcher;
        }

        public Watch.Watcher getEtcdWatcher() {
            return this.etcdWatcher;
        }
    }
}

