/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.cps.etcd.internal;

import dev.galasa.cps.etcd.internal.Etcd3DynamicStatusStore;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreRegistration;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IDynamicStatusStoreRegistration.class})
public class Etcd3DynamicStatusStoreRegistration
implements IDynamicStatusStoreRegistration {
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws DynamicStatusStoreException {
        URI dss = frameworkInitialisation.getDynamicStatusStoreUri();
        if (Etcd3DynamicStatusStoreRegistration.isEtcdUri(dss)) {
            try {
                URI uri = new URI(dss.toString().replace("etcd:", ""));
                frameworkInitialisation.registerDynamicStatusStore((IDynamicStatusStore)new Etcd3DynamicStatusStore(uri));
            }
            catch (URISyntaxException e) {
                throw new DynamicStatusStoreException("Could not create URI", (Throwable)e);
            }
        }
    }

    public static boolean isEtcdUri(URI uri) {
        return "etcd".equals(uri.getScheme());
    }
}

