/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.elasticlog.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.galasa.ManagerException;
import dev.galasa.elasticlog.internal.ElasticLogManagerException;
import dev.galasa.elasticlog.internal.properties.ElasticLogEndpoint;
import dev.galasa.elasticlog.internal.properties.ElasticLogIndex;
import dev.galasa.elasticlog.internal.properties.ElasticLogLocalRun;
import dev.galasa.elasticlog.internal.properties.ElasticLogPropertiesSingleton;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.ILoggingManager;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.http.HttpClientException;
import dev.galasa.http.IHttpClient;
import dev.galasa.http.spi.IHttpManagerSpi;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class ElasticLogManagerImpl
extends AbstractManager {
    private static final Log logger = LogFactory.getLog(ElasticLogManagerImpl.class);
    public static final String NAMESPACE = "elasticlog";
    private IFramework framework;
    private IConfigurationPropertyStoreService cps;
    private IConfidentialTextService ctf;
    private List<IManager> otherManagers = new ArrayList<IManager>();
    private IHttpManagerSpi httpManager;
    private HashMap<String, Object> runProperties = new HashMap();

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        try {
            this.framework = framework;
            this.cps = framework.getConfigurationPropertyService(NAMESPACE);
            this.ctf = framework.getConfidentialTextService();
            ElasticLogPropertiesSingleton.setCps(this.cps);
        }
        catch (Exception e) {
            throw new ElasticLogManagerException("Unable to request framework services", e);
        }
        if (!framework.getTestRun().isLocal() || ElasticLogLocalRun.get().equals("true")) {
            this.youAreRequired(allManagers, activeManagers);
        }
        this.otherManagers = activeManagers;
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers) throws ManagerException {
        if (activeManagers.contains((Object)this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.httpManager = (IHttpManagerSpi)this.addDependentManager(allManagers, activeManagers, IHttpManagerSpi.class);
    }

    public void testClassResult(@NotNull String finalResult, Throwable finalException) throws ManagerException {
        this.runProperties.put("testCase", this.framework.getTestRun().getTestClassName());
        this.runProperties.put("runId", this.framework.getTestRunName());
        this.runProperties.put("startTimestamp", Date.from(this.framework.getTestRun().getQueued()));
        this.runProperties.put("endTimestamp", Date.from(Instant.now()));
        this.runProperties.put("requestor", this.framework.getTestRun().getRequestor());
        this.runProperties.put("result", finalResult);
        String testTooling = "Galasa";
        String testType = "Galasa";
        String testingEnvironment = "NOT_ASSIGNED";
        String productRelease = null;
        String buildLevel = null;
        String customBuild = null;
        ArrayList testingAreas = new ArrayList();
        ArrayList tags = new ArrayList();
        for (IManager manager : this.otherManagers) {
            List tagList;
            List areas;
            String custom;
            String level;
            String release;
            String environment;
            String type;
            if (!(manager instanceof ILoggingManager)) continue;
            ILoggingManager loggingManager = (ILoggingManager)manager;
            String tooling = loggingManager.getTestTooling();
            if (tooling != null) {
                testTooling = tooling;
            }
            if ((type = loggingManager.getTestType()) != null) {
                testType = type;
            }
            if ((environment = loggingManager.getTestingEnvironment()) != null) {
                testingEnvironment = environment;
            }
            if ((release = loggingManager.getProductRelease()) != null) {
                productRelease = release;
            }
            if ((level = loggingManager.getBuildLevel()) != null) {
                buildLevel = level;
            }
            if ((custom = loggingManager.getCustomBuild()) != null) {
                customBuild = custom;
            }
            if ((areas = loggingManager.getTestingAreas()) != null) {
                testingAreas.addAll(areas);
            }
            if ((tagList = loggingManager.getTags()) == null) continue;
            tags.addAll(tagList);
        }
        if (testingAreas.isEmpty()) {
            testingAreas = null;
        }
        if (tags.isEmpty()) {
            tags = null;
        }
        this.runProperties.put("testTooling", testTooling);
        this.runProperties.put("testType", testType);
        this.runProperties.put("testingEnvironment", testingEnvironment);
        this.runProperties.put("productRelease", productRelease);
        this.runProperties.put("buildLevel", buildLevel);
        this.runProperties.put("customBuild", customBuild);
        if (testingAreas != null) {
            this.runProperties.put("testingAreas", testingAreas.toArray(new String[0]));
        }
        if (tags != null) {
            this.runProperties.put("tags", tags.toArray(new String[0]));
        }
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();
        String request = gson.toJson(this.runProperties);
        logger.info((Object)"Sending Run Request to ElasticLog Endpoint");
        logger.trace((Object)("Document Request -\n" + request));
        String index = ElasticLogIndex.get();
        String endpoint = ElasticLogEndpoint.get();
        this.ctf.registerText(index, "ElasticLog Index");
        this.ctf.registerText(endpoint, "ElasticLog Endpoint");
        try {
            IHttpClient client = this.httpManager.newHttpClient();
            client.setTrustingSSLContext();
            client.addOkResponseCode(201);
            client.setURI(new URI(endpoint));
            client.postText(index + "/_doc", request);
            logger.info((Object)("Run successfully logged to Elastic index " + index));
            index = index + "_latest";
            String testCase = (String)this.runProperties.get("testCase");
            client.postText(index + "/_doc/" + testCase + testingEnvironment, request);
            logger.info((Object)("Run successfully logged to Elastic index " + index));
        }
        catch (HttpClientException e) {
            logger.info((Object)"ElasticLog Manager failed to send information to Elastic Endpoint");
        }
        catch (URISyntaxException e) {
            logger.info((Object)"ElasticLog Manager failed to send parse URI of Elastic Endpoint");
        }
    }
}

