/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.elasticlog.internal;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.ManagerException;
import dev.galasa.elasticlog.internal.ElasticLogManagerException;
import dev.galasa.elasticlog.internal.properties.ElasticLogCredentials;
import dev.galasa.elasticlog.internal.properties.ElasticLogEndpoint;
import dev.galasa.elasticlog.internal.properties.ElasticLogIndex;
import dev.galasa.elasticlog.internal.properties.ElasticLogLocalRun;
import dev.galasa.elasticlog.internal.properties.ElasticLogPropertiesSingleton;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.ILoggingManager;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsService;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.utils.GalasaGsonBuilder;
import dev.galasa.http.HttpClientException;
import dev.galasa.http.HttpClientResponse;
import dev.galasa.http.IHttpClient;
import dev.galasa.http.spi.IHttpManagerSpi;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class ElasticLogManagerImpl
extends AbstractManager {
    private static final Log logger = LogFactory.getLog(ElasticLogManagerImpl.class);
    public static final String NAMESPACE = "elasticlog";
    private IFramework framework;
    private IConfigurationPropertyStoreService cps;
    private IConfidentialTextService ctf;
    private ICredentialsService credService;
    private List<IManager> otherManagers = new ArrayList<IManager>();
    private IHttpManagerSpi httpManager;
    private HashMap<String, Object> runProperties = new HashMap();

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        try {
            this.framework = framework;
            this.cps = framework.getConfigurationPropertyService(NAMESPACE);
            this.ctf = framework.getConfidentialTextService();
            this.credService = framework.getCredentialsService();
            ElasticLogPropertiesSingleton.setCps(this.cps);
        }
        catch (Exception e) {
            throw new ElasticLogManagerException("Unable to request framework services", e);
        }
        if (!framework.getTestRun().isLocal() || ElasticLogLocalRun.get().equals("true")) {
            this.youAreRequired(allManagers, activeManagers, galasaTest);
        }
        this.otherManagers = activeManagers;
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        if (activeManagers.contains((Object)this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.httpManager = (IHttpManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IHttpManagerSpi.class);
    }

    public boolean doYouSupportSharedEnvironments() {
        return true;
    }

    public void testClassResult(@NotNull String finalResult, Throwable finalException) throws ManagerException {
        this.runProperties.put("testCase", this.framework.getTestRun().getTestClassName());
        this.runProperties.put("runId", this.framework.getTestRunName());
        this.runProperties.put("startTimestamp", Date.from(this.framework.getTestRun().getQueued()));
        this.runProperties.put("endTimestamp", Date.from(Instant.now()));
        this.runProperties.put("requestor", this.framework.getTestRun().getRequestor());
        this.runProperties.put("result", finalResult);
        String testTooling = "Galasa";
        String testType = "Galasa";
        String testingEnvironment = "NOT_ASSIGNED";
        String productRelease = null;
        String buildLevel = null;
        String customBuild = null;
        ArrayList testingAreas = new ArrayList();
        ArrayList tags = new ArrayList();
        for (IManager manager : this.otherManagers) {
            List tagList;
            List areas;
            String custom;
            String level;
            String release;
            String environment;
            String type;
            if (!(manager instanceof ILoggingManager)) continue;
            ILoggingManager loggingManager = (ILoggingManager)manager;
            String tooling = loggingManager.getTestTooling();
            if (tooling != null) {
                testTooling = tooling;
            }
            if ((type = loggingManager.getTestType()) != null) {
                testType = type;
            }
            if ((environment = loggingManager.getTestingEnvironment()) != null) {
                testingEnvironment = environment;
            }
            if ((release = loggingManager.getProductRelease()) != null) {
                productRelease = release;
            }
            if ((level = loggingManager.getBuildLevel()) != null) {
                buildLevel = level;
            }
            if ((custom = loggingManager.getCustomBuild()) != null) {
                customBuild = custom;
            }
            if ((areas = loggingManager.getTestingAreas()) != null) {
                testingAreas.addAll(areas);
            }
            if ((tagList = loggingManager.getTags()) == null) continue;
            tags.addAll(tagList);
        }
        if (testingAreas.isEmpty()) {
            testingAreas = null;
        }
        if (tags.isEmpty()) {
            tags = null;
        }
        this.runProperties.put("testTooling", testTooling);
        this.runProperties.put("testType", testType);
        this.runProperties.put("testingEnvironment", testingEnvironment);
        this.runProperties.put("productRelease", productRelease);
        this.runProperties.put("buildLevel", buildLevel);
        this.runProperties.put("customBuild", customBuild);
        if (testingAreas != null) {
            this.runProperties.put("testingAreas", testingAreas.toArray(new String[testingAreas.size()]));
        }
        if (tags != null) {
            this.runProperties.put("tags", tags.toArray(new String[tags.size()]));
        }
        Gson gson = new GalasaGsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").getGson();
        JsonObject json = gson.toJsonTree(this.runProperties).getAsJsonObject();
        logger.info((Object)"Sending Run Request to ElasticLog Endpoint");
        logger.trace((Object)("Document Request -\n" + json.toString()));
        Object index = ElasticLogIndex.get();
        String endpoint = ElasticLogEndpoint.get();
        this.ctf.registerText((String)index, "ElasticLog Index");
        this.ctf.registerText(endpoint, "ElasticLog Endpoint");
        try {
            ICredentials creds = this.getCreds();
            IHttpClient client = this.httpManager.newHttpClient();
            client.setTrustingSSLContext();
            client.addOkResponseCode(201);
            client.setURI(new URI(endpoint));
            if (creds != null && creds instanceof ICredentialsUsernamePassword) {
                ICredentialsUsernamePassword userPass = (ICredentialsUsernamePassword)creds;
                String user = userPass.getUsername();
                String pass = userPass.getPassword();
                client.setAuthorisation(user, pass);
            }
            HttpClientResponse response = client.postJson((String)index + "/_doc", json);
            int statusCode = response.getStatusCode();
            String message = response.getStatusMessage();
            if (statusCode != 201 && statusCode != 200) {
                logger.warn((Object)("Error logging to Elastic index " + (String)index + ": " + statusCode + " - " + message));
            } else {
                logger.info((Object)("Run successfully logged to Elastic index " + (String)index));
            }
            index = (String)index + "_latest";
            String testCase = (String)this.runProperties.get("testCase");
            response = client.postJson((String)index + "/_doc/" + testCase + testingEnvironment, json);
            statusCode = response.getStatusCode();
            message = response.getStatusMessage();
            if (statusCode != 201 && statusCode != 200) {
                logger.warn((Object)("Error logging to Elastic index " + (String)index + ": " + statusCode + " - " + message));
            } else {
                logger.info((Object)("Run successfully logged to Elastic index " + (String)index));
            }
        }
        catch (HttpClientException e) {
            logger.warn((Object)"ElasticLog Manager failed to send information to Elastic Endpoint: ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)"ElasticLog Manager failed to send parse URI of Elastic Endpoint: ", (Throwable)e);
        }
        catch (CredentialsException e) {
            logger.warn((Object)"Problem retrieving credentials: ", (Throwable)e);
        }
    }

    private ICredentials getCreds() throws CredentialsException, ElasticLogManagerException {
        String credKey = ElasticLogCredentials.get();
        ICredentials creds = this.credService.getCredentials(credKey);
        return creds;
    }
}

