/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.kubernetes.manager.ivt;

import dev.galasa.Test;
import dev.galasa.artifact.ArtifactManager;
import dev.galasa.artifact.IArtifactManager;
import dev.galasa.artifact.IBundleResources;
import dev.galasa.artifact.TestBundleResourceException;
import dev.galasa.core.manager.Logger;
import dev.galasa.kubernetes.IConfigMap;
import dev.galasa.kubernetes.IDeployment;
import dev.galasa.kubernetes.IKubernetesNamespace;
import dev.galasa.kubernetes.IPersistentVolumeClaim;
import dev.galasa.kubernetes.ISecret;
import dev.galasa.kubernetes.IService;
import dev.galasa.kubernetes.IStatefulSet;
import dev.galasa.kubernetes.KubernetesManagerException;
import dev.galasa.kubernetes.KubernetesNamespace;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

@Test
public class KubernetesManagerIVT {
    @Logger
    public Log logger;
    @KubernetesNamespace
    public IKubernetesNamespace namespace;
    @ArtifactManager
    public IArtifactManager artifactManager;

    @Test
    public void ensureSetupOk() {
        ((ObjectAssert)Assertions.assertThat((Object)this.namespace).as("Kubernetes Namespace", new Object[0])).isNotNull();
    }

    @Test
    public void createConfigMap() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String configMapYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testConfigMap.yaml"));
        IConfigMap configMap = (IConfigMap)this.namespace.createResource(configMapYaml);
        this.logger.info((Object)("YAML for the created ConfigMap:-\n" + configMap.getYaml()));
    }

    @Test
    public void createPvc() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String pvcYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testPvc.yaml"));
        IPersistentVolumeClaim persistentVolumeClaim = (IPersistentVolumeClaim)this.namespace.createResource(pvcYaml);
        this.logger.info((Object)("YAML for the created PersistentVolumeClaim:-\n" + persistentVolumeClaim.getYaml()));
    }

    @Test
    public void createSecret() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String secretYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testSecret.yaml"));
        ISecret secret = (ISecret)this.namespace.createResource(secretYaml);
        this.logger.info((Object)("YAML for the created Secret:-\n" + secret.getYaml()));
    }

    @Test
    public void createDeployment() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String deploymentYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testDeployment.yaml"));
        IDeployment deployment = (IDeployment)this.namespace.createResource(deploymentYaml);
        this.logger.info((Object)("YAML for the created Deployment:-\n" + deployment.getYaml()));
    }

    @Test
    public void createStatefulSet() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String statefulSetYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testStatefulSet.yaml"));
        IStatefulSet statefulSet = (IStatefulSet)this.namespace.createResource(statefulSetYaml);
        this.logger.info((Object)("YAML for the created StatefulSet:-\n" + statefulSet.getYaml()));
    }

    @Test
    public void createService() throws TestBundleResourceException, IOException, KubernetesManagerException {
        IBundleResources bundleResources = this.artifactManager.getBundleResources(this.getClass());
        String serviceYaml = bundleResources.streamAsString(bundleResources.retrieveFile("/testService.yaml"));
        IService service = (IService)this.namespace.createResource(serviceYaml);
        this.logger.info((Object)("YAML for the created Service:-\n" + service.getYaml()));
    }
}

