/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.galasa.framework.spi.ras.ResultArchiveStorePath;
import dev.galasa.ras.couchdb.internal.CoucbDbBasicAttributes;
import java.nio.file.FileSystem;
import java.util.List;
import javax.validation.constraints.NotNull;

public class CouchdbArtifactPath
extends ResultArchiveStorePath {
    private String contentType;
    private int length;
    private String artifactRecordId;
    private boolean directory = false;

    public CouchdbArtifactPath(@NotNull FileSystem fileSystem, String pathName) {
        super(fileSystem, pathName);
    }

    protected CouchdbArtifactPath(FileSystem fileSystem, boolean b, List<String> nameElements, int i, int size) {
        super(fileSystem, b, nameElements, i, size);
    }

    protected CouchdbArtifactPath(@NotNull FileSystem fileSystem, String pathName, JsonObject artifactDetails, String artifactRecordId) {
        super(fileSystem, pathName);
        this.artifactRecordId = artifactRecordId;
        JsonElement ct = artifactDetails.get("content_type");
        this.contentType = ct != null ? ct.getAsString() : "unknown";
        JsonElement len = artifactDetails.get("length");
        this.length = len != null ? len.getAsInt() : 0;
    }

    public CouchdbArtifactPath getParent() {
        if (this.nameElements.isEmpty()) {
            return null;
        }
        CouchdbArtifactPath parentPath = new CouchdbArtifactPath(this.fileSystem, this.absolute, this.nameElements, 0, this.nameElements.size() - 1);
        parentPath.setDirectory(true);
        return parentPath;
    }

    private void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public CouchdbArtifactPath toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        return new CouchdbArtifactPath(this.fileSystem, true, this.nameElements, 0, this.nameElements.size());
    }

    public String getArtifactRecordId() {
        return this.artifactRecordId;
    }

    public CoucbDbBasicAttributes readAttributes() {
        return new CoucbDbBasicAttributes(this);
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected ResultArchiveStorePath newPathObject(String newPath) {
        return new CouchdbArtifactPath(this.fileSystem, newPath);
    }

    protected ResultArchiveStorePath newPathObject(boolean absolute, List<String> nameElements, int start, int end) {
        return new CouchdbArtifactPath(this.fileSystem, absolute, nameElements, start, end);
    }
}

