/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.galasa.framework.spi.IResultArchiveStoreDirectoryService;
import dev.galasa.framework.spi.IRunResult;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.ras.IRasSearchCriteria;
import dev.galasa.framework.spi.ras.RasSearchCriteriaBundle;
import dev.galasa.framework.spi.ras.RasSearchCriteriaQueuedFrom;
import dev.galasa.framework.spi.ras.RasSearchCriteriaQueuedTo;
import dev.galasa.framework.spi.ras.RasSearchCriteriaRequestor;
import dev.galasa.framework.spi.ras.RasSearchCriteriaResult;
import dev.galasa.framework.spi.ras.RasSearchCriteriaRunName;
import dev.galasa.framework.spi.ras.RasSearchCriteriaTestName;
import dev.galasa.framework.spi.ras.RasTestClass;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileStore;
import dev.galasa.ras.couchdb.internal.CouchdbArtifactPath;
import dev.galasa.ras.couchdb.internal.CouchdbRasException;
import dev.galasa.ras.couchdb.internal.CouchdbRasFileSystemProvider;
import dev.galasa.ras.couchdb.internal.CouchdbRasStore;
import dev.galasa.ras.couchdb.internal.CouchdbRunResult;
import dev.galasa.ras.couchdb.internal.pojos.Find;
import dev.galasa.ras.couchdb.internal.pojos.FoundRuns;
import dev.galasa.ras.couchdb.internal.pojos.IdRev;
import dev.galasa.ras.couchdb.internal.pojos.Row;
import dev.galasa.ras.couchdb.internal.pojos.TestStructureCouchdb;
import dev.galasa.ras.couchdb.internal.pojos.ViewResponse;
import dev.galasa.ras.couchdb.internal.pojos.ViewRow;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class CouchdbDirectoryService
implements IResultArchiveStoreDirectoryService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final CouchdbRasStore store;

    public CouchdbDirectoryService(CouchdbRasStore store) {
        this.store = store;
    }

    @NotNull
    public String getName() {
        return "CouchDB - " + this.store.getCouchdbUri();
    }

    public boolean isLocal() {
        return false;
    }

    private Path getRunArtifactPath(TestStructureCouchdb ts) throws CouchdbRasException {
        ResultArchiveStoreFileStore fileStore = new ResultArchiveStoreFileStore();
        CouchdbRasFileSystemProvider runProvider = new CouchdbRasFileSystemProvider((FileStore)fileStore, this.store);
        if (ts.getArtifactRecordIds() == null || ts.getArtifactRecordIds().isEmpty()) {
            return runProvider.getRoot();
        }
        for (String artifactRecordId : ts.getArtifactRecordIds()) {
            HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_artifacts/" + artifactRecordId);
            httpGet.addHeader("Accept", "application/json");
            try {
                CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);
                Throwable throwable = null;
                try {
                    JsonObject attachments;
                    Set entries;
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() == 404) continue;
                    if (statusLine.getStatusCode() != 200) {
                        throw new CouchdbRasException("Unable to find artifacts - " + statusLine.toString());
                    }
                    HttpEntity entity = response.getEntity();
                    String responseEntity = EntityUtils.toString((HttpEntity)entity);
                    JsonObject artifactRecord = (JsonObject)this.store.getGson().fromJson(responseEntity, JsonObject.class);
                    JsonElement attachmentsElement = artifactRecord.get("_attachments");
                    if (attachmentsElement == null || !(attachmentsElement instanceof JsonObject) || (entries = (attachments = (JsonObject)attachmentsElement).entrySet()) == null) continue;
                    for (Map.Entry entry : entries) {
                        JsonElement elem = (JsonElement)entry.getValue();
                        if (!(elem instanceof JsonObject)) continue;
                        runProvider.addPath(new CouchdbArtifactPath((FileSystem)runProvider.getActualFileSystem(), (String)entry.getKey(), (JsonObject)elem, artifactRecordId));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (CouchdbRasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CouchdbRasException("Unable to find runs", e);
            }
        }
        return runProvider.getRoot();
    }

    @NotNull
    private List<IRunResult> getAllRuns() throws ResultArchiveStoreException {
        ArrayList<IRunResult> runs = new ArrayList<IRunResult>();
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_run/_all_docs");
        httpGet.addHeader("Accept", "application/json");
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find runs - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            FoundRuns found = (FoundRuns)this.store.getGson().fromJson(responseEntity, FoundRuns.class);
            if (found.rows == null) {
                throw new CouchdbRasException("Unable to find rows - Invalid JSON response");
            }
            if (found.warning != null) {
                this.logger.warn((Object)("CouchDB warning detected - " + found.warning));
            }
            for (Row row : found.rows) {
                CouchdbRunResult cdbrr = this.fetchRun(row.id);
                if (cdbrr == null || cdbrr.getTestStructure() == null || !cdbrr.getTestStructure().isValid()) continue;
                runs.add(cdbrr);
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to find runs", (Throwable)e);
        }
        return runs;
    }

    private CouchdbRunResult fetchRun(String id) throws ParseException, IOException, CouchdbRasException {
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_run/" + id);
        httpGet.addHeader("Accept", "application/json");
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            CouchdbRunResult cdbrr;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                CouchdbRunResult couchdbRunResult = null;
                return couchdbRunResult;
            }
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            TestStructureCouchdb ts = (TestStructureCouchdb)((Object)this.store.getGson().fromJson(responseEntity, TestStructureCouchdb.class));
            Path runArtifactPath = this.getRunArtifactPath(ts);
            CouchdbRunResult couchdbRunResult = cdbrr = new CouchdbRunResult(this.store, ts, runArtifactPath);
            return couchdbRunResult;
        }
    }

    @NotNull
    public List<String> getRequestors() throws ResultArchiveStoreException {
        ArrayList<String> requestors = new ArrayList<String>();
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_run/_design/docs/_view/requestors-view?group=true");
        httpGet.addHeader("Accept", "application/json");
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find runs - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            ViewResponse view = (ViewResponse)this.store.getGson().fromJson(responseEntity, ViewResponse.class);
            if (view.rows == null) {
                throw new CouchdbRasException("Unable to find requestors - Invalid JSON response");
            }
            for (ViewRow row : view.rows) {
                requestors.add(row.key);
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to find requestors", (Throwable)e);
        }
        return requestors;
    }

    @NotNull
    public List<String> getResultNames() throws ResultArchiveStoreException {
        ArrayList<String> results = new ArrayList<String>();
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_run/_design/docs/_view/result-view?group=true");
        httpGet.addHeader("Accept", "application/json");
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find results - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            ViewResponse view = (ViewResponse)this.store.getGson().fromJson(responseEntity, ViewResponse.class);
            if (view.rows == null) {
                throw new CouchdbRasException("Unable to find results - Invalid JSON response");
            }
            for (ViewRow row : view.rows) {
                if (row.key == null) continue;
                results.add(row.key);
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to find results", (Throwable)e);
        }
        return results;
    }

    @NotNull
    public List<RasTestClass> getTests() throws ResultArchiveStoreException {
        ArrayList<RasTestClass> tests = new ArrayList<RasTestClass>();
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/galasa_run/_design/docs/_view/bundle-testnames-view?group=true");
        httpGet.addHeader("Accept", "application/json");
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find tests - " + statusLine.toString());
            }
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            ViewResponse view = (ViewResponse)this.store.getGson().fromJson(responseEntity, ViewResponse.class);
            if (view.rows == null) {
                throw new CouchdbRasException("Unable to find rows - Invalid JSON response");
            }
            for (ViewRow row : view.rows) {
                int posSlash;
                String bundleTestname = row.key;
                if (bundleTestname == null || "undefined/undefined".equals(bundleTestname) || (posSlash = bundleTestname.indexOf(47)) < 0) continue;
                String bundleName = bundleTestname.substring(0, posSlash);
                String testName = bundleTestname.substring(posSlash + 1);
                RasTestClass rasTestClass = new RasTestClass(testName, bundleName);
                tests.add(rasTestClass);
            }
        }
        catch (CouchdbRasException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to find tests", (Throwable)e);
        }
        return tests;
    }

    @NotNull
    public List<IRunResult> getRuns(IRasSearchCriteria ... searchCriterias) throws ResultArchiveStoreException {
        if (searchCriterias.length == 0) {
            return this.getAllRuns();
        }
        ArrayList<IRunResult> runs = new ArrayList<IRunResult>();
        HttpPost httpPost = new HttpPost(this.store.getCouchdbUri() + "/galasa_run/_find");
        JsonObject selector = new JsonObject();
        JsonArray and = new JsonArray();
        selector.add("$and", (JsonElement)and);
        for (IRasSearchCriteria searchCriteria : searchCriterias) {
            JsonObject criteria;
            if (searchCriteria instanceof RasSearchCriteriaRequestor) {
                RasSearchCriteriaRequestor sRequestor = (RasSearchCriteriaRequestor)searchCriteria;
                this.inArray(and, "requestor", sRequestor.getRequestors());
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaRunName) {
                RasSearchCriteriaRunName sRunName = (RasSearchCriteriaRunName)searchCriteria;
                this.inArray(and, "runName", sRunName.getRunNames());
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaQueuedFrom) {
                RasSearchCriteriaQueuedFrom sFrom = (RasSearchCriteriaQueuedFrom)searchCriteria;
                criteria = new JsonObject();
                JsonObject jFrom = new JsonObject();
                jFrom.addProperty("$gte", sFrom.getFrom().toString());
                criteria.add("queued", (JsonElement)jFrom);
                and.add((JsonElement)criteria);
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaQueuedTo) {
                RasSearchCriteriaQueuedTo sTo = (RasSearchCriteriaQueuedTo)searchCriteria;
                criteria = new JsonObject();
                JsonObject jTo = new JsonObject();
                jTo.addProperty("$lt", sTo.getTo().toString());
                criteria.add("queued", (JsonElement)jTo);
                and.add((JsonElement)criteria);
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaTestName) {
                RasSearchCriteriaTestName sTestName = (RasSearchCriteriaTestName)searchCriteria;
                this.inArray(and, "testName", sTestName.getTestNames());
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaBundle) {
                RasSearchCriteriaBundle sBundle = (RasSearchCriteriaBundle)searchCriteria;
                this.inArray(and, "bundle", sBundle.getBundles());
                continue;
            }
            if (searchCriteria instanceof RasSearchCriteriaResult) {
                RasSearchCriteriaResult sResult = (RasSearchCriteriaResult)searchCriteria;
                this.inArray(and, "result", sResult.getResults());
                continue;
            }
            throw new ResultArchiveStoreException("Unrecognised search criteria class " + searchCriteria.getClass().getName());
        }
        Find find = new Find();
        find.selector = selector;
        find.execution_stats = true;
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-Type", "application/json");
        while (true) {
            String requestContent = this.store.getGson().toJson((Object)find);
            httpPost.setEntity((HttpEntity)new StringEntity(requestContent, UTF8));
            try {
                CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpPost);
                Throwable throwable = null;
                try {
                    StatusLine statusLine = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    String responseEntity = EntityUtils.toString((HttpEntity)entity);
                    if (statusLine.getStatusCode() != 200) {
                        throw new CouchdbRasException("Unable to find runs - " + statusLine.toString());
                    }
                    FoundRuns found = (FoundRuns)this.store.getGson().fromJson(responseEntity, FoundRuns.class);
                    if (found.docs == null) {
                        throw new CouchdbRasException("Unable to find runs - Invalid JSON response");
                    }
                    if (found.warning != null) {
                        this.logger.warn((Object)("CouchDB warning detected - " + found.warning));
                    }
                    if (found.docs.isEmpty()) break;
                    for (TestStructureCouchdb ts : found.docs) {
                        Path runArtifactPath = this.getRunArtifactPath(ts);
                        CouchdbRunResult cdbrr = new CouchdbRunResult(this.store, ts, runArtifactPath);
                        if (!ts.isValid()) continue;
                        runs.add(cdbrr);
                    }
                    find.bookmark = found.bookmark;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (CouchdbRasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResultArchiveStoreException("Unable to find runs", (Throwable)e);
            }
        }
        return runs;
    }

    public void discardRun(String id) throws ResultArchiveStoreException {
        try {
            CouchdbRunResult run = this.fetchRun(id);
            TestStructureCouchdb testStructure = (TestStructureCouchdb)run.getTestStructure();
            this.discardRunLogs(testStructure.getLogRecordIds());
            this.discardRunArtifacts(testStructure.getArtifactRecordIds());
            this.discardRecord("galasa_run", id);
        }
        catch (CouchdbRasException | IOException | ParseException e) {
            throw new ResultArchiveStoreException("Failed to discard run: " + id, (Throwable)e);
        }
    }

    private void discardRunLogs(List<String> ids) throws ResultArchiveStoreException {
        for (String id : ids) {
            this.discardRecord("galasa_log", id);
        }
    }

    private void discardRunArtifacts(List<String> ids) throws ResultArchiveStoreException {
        for (String id : ids) {
            this.discardRecord("galasa_artifacts", id);
        }
    }

    private void discardRecord(String databaseName, String id) throws ResultArchiveStoreException {
        try {
            URIBuilder builder = new URIBuilder(this.store.getCouchdbUri() + "/" + databaseName + "/" + id);
            builder.addParameter("rev", this.getRevision(databaseName, id));
            HttpDelete httpDelete = new HttpDelete(builder.build());
            try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpDelete);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    throw new CouchdbRasException("Unable to delete run " + id + " - " + statusLine.toString());
                }
            }
            catch (IOException e) {
                throw new ResultArchiveStoreException("Failed to execute HTTP DELETE for run: " + id, (Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            throw new ResultArchiveStoreException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRevision(String databaseName, String id) throws ResultArchiveStoreException {
        HttpGet httpGet = new HttpGet(this.store.getCouchdbUri() + "/" + databaseName + "/" + id);
        try (CloseableHttpResponse response = this.store.getHttpClient().execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            String responseEntity = EntityUtils.toString((HttpEntity)entity);
            if (statusLine.getStatusCode() != 200) {
                throw new CouchdbRasException("Unable to find runs - " + statusLine.toString());
            }
            IdRev found = (IdRev)this.store.getGson().fromJson(responseEntity, IdRev.class);
            if (found._id == null) {
                throw new CouchdbRasException("Unable to find runs - Invalid JSON response");
            }
            if (found._rev == null) {
                throw new CouchdbRasException("Unable to find rev - Invalid JSON response");
            }
            String string = found._rev;
            return string;
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException((Throwable)e);
        }
    }

    private void inArray(JsonArray and, String field, String[] inArray) {
        if (inArray == null || inArray.length < 1) {
            return;
        }
        JsonArray jIns = new JsonArray();
        for (String in : inArray) {
            if (in == null || in.isEmpty()) continue;
            jIns.add(in);
        }
        if (jIns.size() == 0) {
            return;
        }
        JsonObject jIn = new JsonObject();
        jIn.add("$in", (JsonElement)jIns);
        JsonObject criteria = new JsonObject();
        criteria.add(field, (JsonElement)jIn);
        and.add((JsonElement)criteria);
    }

    public IRunResult getRunById(@NotNull String runId) throws ResultArchiveStoreException {
        if (!runId.startsWith("cdb-")) {
            return null;
        }
        runId = runId.substring(4);
        try {
            return this.fetchRun(runId);
        }
        catch (Exception e) {
            return null;
        }
    }
}

