/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.SetContentType;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileSystemProvider;
import dev.galasa.ras.couchdb.internal.CoucbDbBasicAttributes;
import dev.galasa.ras.couchdb.internal.CouchdbArtifactPath;
import dev.galasa.ras.couchdb.internal.CouchdbDirectoryStream;
import dev.galasa.ras.couchdb.internal.CouchdbFileSystem;
import dev.galasa.ras.couchdb.internal.CouchdbRasException;
import dev.galasa.ras.couchdb.internal.CouchdbRasReadByteChannel;
import dev.galasa.ras.couchdb.internal.CouchdbRasStore;
import dev.galasa.ras.couchdb.internal.CouchdbRasWriteByteChannel;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CouchdbRasFileSystemProvider
extends ResultArchiveStoreFileSystemProvider {
    private static final String RAS_CONTENT_TYPE = "ras:contentType";
    private static final String BASIC_SIZE = "size";
    private static final String POSIX_SIZE = "posix:size";
    private final HashMap<Path, ResultArchiveStoreContentType> contentTypes = new HashMap();
    private final HashSet<CouchdbArtifactPath> paths = new HashSet();
    private final CouchdbRasStore couchdbRasStore;

    protected CouchdbRasFileSystemProvider(FileStore fileSystemStore, CouchdbRasStore couchdbRasStore) {
        super(fileSystemStore, null);
        this.fileSystem = new CouchdbFileSystem(this);
        this.couchdbRasStore = couchdbRasStore;
        this.paths.add(new CouchdbArtifactPath(this.fileSystem, "/"));
    }

    protected void addPath(CouchdbArtifactPath path) {
        if (this.paths.contains((Object)(path = path.toAbsolutePath()))) {
            return;
        }
        this.paths.add(path);
        for (CouchdbArtifactPath parentPath = path.getParent(); parentPath != null && !this.paths.contains((Object)parentPath); parentPath = parentPath.getParent()) {
            if (this.paths.contains((Object)parentPath)) {
                return;
            }
            this.paths.add(parentPath);
        }
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        boolean write = options.contains(StandardOpenOption.WRITE);
        if (write) {
            Path absolute = path.toAbsolutePath();
            ResultArchiveStoreContentType contentType = null;
            for (OpenOption openOption : options) {
                if (!(openOption instanceof SetContentType)) continue;
                contentType = ((SetContentType)openOption).getContentType();
            }
            if (contentType != null) {
                for (FileAttribute<?> attr : attrs) {
                    if (!(attr instanceof ResultArchiveStoreContentType)) continue;
                    contentType = (ResultArchiveStoreContentType)attr;
                    this.contentTypes.put(absolute, contentType);
                }
            }
            if (contentType == null) {
                contentType = this.contentTypes.get(absolute);
            }
            HashSet<StandardOpenOption> passThroughOptions = new HashSet<StandardOpenOption>();
            passThroughOptions.add(StandardOpenOption.WRITE);
            passThroughOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            return new CouchdbRasWriteByteChannel(this, this.couchdbRasStore, absolute, contentType, passThroughOptions, attrs);
        }
        CouchdbArtifactPath cdbPath = (CouchdbArtifactPath)((Object)path);
        Path cachePath = Files.createTempFile("galasa_couchdb", "temp", new FileAttribute[0]);
        try {
            this.couchdbRasStore.retrieveArtifact(cdbPath, cachePath);
        }
        catch (CouchdbRasException e) {
            throw new IOException("Unable to retrieve artifact", (Throwable)((Object)e));
        }
        return new CouchdbRasReadByteChannel(cachePath);
    }

    public Path getRoot() {
        return new CouchdbArtifactPath((FileSystem)this.getActualFileSystem(), "/");
    }

    public Path getPath(URI uri) {
        return new CouchdbArtifactPath((FileSystem)this.getActualFileSystem(), uri.toString());
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new CouchdbDirectoryStream(dir, filter, this.paths);
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (path instanceof CouchdbArtifactPath && (type == CoucbDbBasicAttributes.class || type == BasicFileAttributes.class)) {
            CouchdbArtifactPath caPath = (CouchdbArtifactPath)((Object)path);
            return (A)((Object)caPath.readAttributes());
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        HashMap<String, Object> returnAttrs = new HashMap<String, Object>();
        if (!(path instanceof CouchdbArtifactPath)) {
            return returnAttrs;
        }
        CouchdbArtifactPath caPath = (CouchdbArtifactPath)((Object)path);
        ArrayList<String> attrs = new ArrayList<String>(Arrays.asList(attributes.replaceAll(" ", "").split(",")));
        Iterator<String> it = attrs.iterator();
        while (it.hasNext()) {
            String attrName;
            String attr = it.next();
            if ("*".equals(attr)) {
                returnAttrs.put(RAS_CONTENT_TYPE, caPath.getContentType());
                returnAttrs.put(BASIC_SIZE, caPath.getLength());
                returnAttrs.put(POSIX_SIZE, caPath.getLength());
                continue;
            }
            if (BASIC_SIZE.equals(attr)) {
                returnAttrs.put(BASIC_SIZE, caPath.getLength());
                continue;
            }
            int colon = attr.indexOf(58);
            if (colon < 0) continue;
            if ("ras".equals(attr.substring(0, colon))) {
                it.remove();
                attrName = attr.substring(colon + 1);
                if ("*".equals(attrName)) {
                    returnAttrs.put(RAS_CONTENT_TYPE, caPath.getContentType());
                    continue;
                }
                if ("contentType".equals(attrName)) {
                    returnAttrs.put(RAS_CONTENT_TYPE, caPath.getContentType());
                    continue;
                }
                throw new UnsupportedOperationException("Attribute ras:" + attrName + " is not available");
            }
            if (!"posix".equals(attr.substring(0, colon))) continue;
            it.remove();
            attrName = attr.substring(colon + 1);
            if ("*".equals(attrName)) {
                returnAttrs.put(POSIX_SIZE, caPath.getLength());
                continue;
            }
            if (!BASIC_SIZE.equals(attrName)) continue;
            returnAttrs.put(POSIX_SIZE, caPath.getLength());
        }
        return returnAttrs;
    }

    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (modes.length == 0) {
            for (CouchdbArtifactPath p : this.paths) {
                if (p.compareTo(path) != 0) continue;
                return;
            }
            throw new IOException("Path " + path.toString() + " is missing");
        }
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case EXECUTE: {
                    throw new UnsupportedOperationException("Path '" + path.toString() + " is not executable");
                }
                case READ: 
                case WRITE: {
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

