/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class CouchdbRasReadByteChannel
implements SeekableByteChannel {
    private final Path cachePath;
    private final SeekableByteChannel cacheByteChannel;

    public CouchdbRasReadByteChannel(Path cachePath) throws IOException {
        this.cachePath = cachePath;
        this.cacheByteChannel = Files.newByteChannel(cachePath, new OpenOption[0]);
    }

    @Override
    public boolean isOpen() {
        return this.cacheByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.cacheByteChannel.close();
        try {
            Files.delete(this.cachePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.cacheByteChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.cacheByteChannel.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.cacheByteChannel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.cacheByteChannel.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.cacheByteChannel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.cacheByteChannel.truncate(size);
    }
}

