/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.ras.couchdb.internal;

import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import dev.galasa.framework.spi.IResultArchiveStoreRegistration;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.ras.couchdb.internal.CouchdbRasStore;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IResultArchiveStoreRegistration.class})
public class CouchdbRasRegistration
implements IResultArchiveStoreRegistration {
    private IFramework framework;
    private URI rasUri;
    private CouchdbRasStore store;

    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws ResultArchiveStoreException {
        this.framework = frameworkInitialisation.getFramework();
        List rasUris = frameworkInitialisation.getResultArchiveStoreUris();
        for (URI uri : rasUris) {
            if (!"couchdb".equals(uri.getScheme())) continue;
            if (this.rasUri != null && !this.store.isShutdown()) {
                throw new ResultArchiveStoreException("The CouchDB RAS currently does not support multiple instances of itself");
            }
            this.rasUri = uri;
        }
        if (this.rasUri == null) {
            return;
        }
        try {
            this.store = new CouchdbRasStore(this.framework, new URI(this.rasUri.toString().substring(8)));
        }
        catch (URISyntaxException e) {
            throw new ResultArchiveStoreException("Invalid CouchDB URI " + this.rasUri.getPath());
        }
        frameworkInitialisation.registerResultArchiveStoreService((IResultArchiveStoreService)this.store);
    }
}

